/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.p;

import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.p.AbstractPacket;
import sba.sl.p.PacketWriter;
import sba.sl.pa.gamemode.GameMode;
import sba.sl.spectator.Component;

public class ClientboundPlayerInfoPacket
extends AbstractPacket {
    @NotNull
    private final Action action;
    @NotNull
    private final @NotNull List<@NotNull PlayerInfoData> data;

    @Override
    public void write(@NotNull PacketWriter writer) {
        if (writer.protocol() >= 761) {
            if (this.action == Action.REMOVE_PLAYER) {
                writer.setCancelled(true);
                writer.append(new PlayerInfoRemovePacket1_19_3(this.data.stream().map(PlayerInfoData::uuid).collect(Collectors.toUnmodifiableList())));
                return;
            }
            BitSet set = new BitSet(6);
            if (Objects.requireNonNull(this.action) == Action.ADD_PLAYER) {
                set.set(0, 6);
            } else {
                int actionOrdinal = this.action.ordinal();
                set.set(actionOrdinal == 1 ? actionOrdinal + 1 : actionOrdinal + 2);
            }
            writer.writeBytes(Arrays.copyOf(set.toByteArray(), 1));
        } else {
            writer.writeVarInt(this.action.ordinal());
        }
        writer.writeSizedCollection(this.data, playerInfoData -> {
            writer.writeUuid(playerInfoData.uuid());
            switch (this.action.ordinal()) {
                case 0: {
                    writer.writeSizedString(playerInfoData.realName());
                    writer.writeSizedCollection(playerInfoData.properties(), property -> {
                        writer.writeSizedString(property.name());
                        writer.writeSizedString(property.value());
                        String signature = property.signature();
                        writer.writeBoolean(signature != null);
                        if (signature != null) {
                            writer.writeSizedString(signature);
                        }
                    });
                    if (writer.protocol() >= 761) {
                        writer.writeBoolean(false);
                    }
                    writer.writeVarInt(playerInfoData.gameMode().id());
                    if (writer.protocol() >= 761) {
                        writer.writeBoolean(playerInfoData.listed());
                    }
                    writer.writeVarInt(playerInfoData.latency());
                    writer.writeBoolean(playerInfoData.displayName() != null);
                    if (playerInfoData.displayName() != null) {
                        writer.writeComponent(playerInfoData.displayName());
                    }
                    if (writer.protocol() != 759 && writer.protocol() != 760) break;
                    writer.writeBoolean(false);
                    break;
                }
                case 1: {
                    writer.writeVarInt(playerInfoData.gameMode().id());
                    break;
                }
                case 2: {
                    writer.writeVarInt(playerInfoData.latency());
                    break;
                }
                case 3: {
                    writer.writeBoolean(playerInfoData.displayName() != null);
                    if (playerInfoData.displayName() == null) break;
                    writer.writeComponent(playerInfoData.displayName());
                }
            }
        });
    }

    @Generated
    ClientboundPlayerInfoPacket(@NotNull Action action, @NotNull @NotNull List<@NotNull PlayerInfoData> data) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.action = action;
        this.data = data;
    }

    @Generated
    public static ClientboundPlayerInfoPacketBuilder builder() {
        return new ClientboundPlayerInfoPacketBuilder();
    }

    @Generated
    public ClientboundPlayerInfoPacketBuilder toBuilder() {
        return new ClientboundPlayerInfoPacketBuilder().action(this.action).data(this.data);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundPlayerInfoPacket)) {
            return false;
        }
        ClientboundPlayerInfoPacket other = (ClientboundPlayerInfoPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Action this$action = this.action();
        Action other$action = other.action();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        List<PlayerInfoData> this$data = this.data();
        List<PlayerInfoData> other$data = other.data();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientboundPlayerInfoPacket;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Action $action = this.action();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        List<PlayerInfoData> $data = this.data();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    @NotNull
    @Generated
    public Action action() {
        return this.action;
    }

    @NotNull
    @Generated
    public @NotNull List<@NotNull PlayerInfoData> data() {
        return this.data;
    }

    @Generated
    public String toString() {
        return "ClientboundPlayerInfoPacket(action=" + String.valueOf((Object)this.action()) + ", data=" + String.valueOf(this.data()) + ")";
    }

    public static enum Action {
        ADD_PLAYER,
        UPDATE_GAME_MODE,
        UPDATE_LATENCY,
        UPDATE_DISPLAY_NAME,
        REMOVE_PLAYER;

    }

    @ApiStatus.Internal
    public static class PlayerInfoRemovePacket1_19_3
    extends AbstractPacket {
        @NotNull
        private final @NotNull List<@NotNull UUID> uuids;

        @Override
        public void write(@NotNull PacketWriter writer) {
            writer.writeSizedCollection(this.uuids, writer::writeUuid);
        }

        @Generated
        public PlayerInfoRemovePacket1_19_3(@NotNull @NotNull List<@NotNull UUID> uuids) {
            if (uuids == null) {
                throw new NullPointerException("uuids is marked non-null but is null");
            }
            this.uuids = uuids;
        }
    }

    @Generated
    public static class ClientboundPlayerInfoPacketBuilder {
        @Generated
        private Action action;
        @Generated
        private List<@NotNull PlayerInfoData> data;

        @Generated
        ClientboundPlayerInfoPacketBuilder() {
        }

        @Generated
        public ClientboundPlayerInfoPacketBuilder action(@NotNull Action action) {
            if (action == null) {
                throw new NullPointerException("action is marked non-null but is null");
            }
            this.action = action;
            return this;
        }

        @Generated
        public ClientboundPlayerInfoPacketBuilder data(@NotNull @NotNull List<@NotNull PlayerInfoData> data) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.data = data;
            return this;
        }

        @Generated
        public ClientboundPlayerInfoPacket build() {
            return new ClientboundPlayerInfoPacket(this.action, this.data);
        }

        @Generated
        public String toString() {
            return "ClientboundPlayerInfoPacket.ClientboundPlayerInfoPacketBuilder(action=" + String.valueOf((Object)this.action) + ", data=" + String.valueOf(this.data) + ")";
        }
    }

    public static class PlayerInfoData {
        @NotNull
        private final UUID uuid;
        @NotNull
        private final String realName;
        private final int latency;
        @NotNull
        private final GameMode gameMode;
        @Nullable
        private final Component displayName;
        @NotNull
        private final @NotNull List<@NotNull Property> properties;
        private final boolean listed;

        @Generated
        public PlayerInfoData(@NotNull UUID uuid, @NotNull String realName, int latency, @NotNull GameMode gameMode, @Nullable Component displayName, @NotNull @NotNull List<@NotNull Property> properties, boolean listed) {
            if (uuid == null) {
                throw new NullPointerException("uuid is marked non-null but is null");
            }
            if (realName == null) {
                throw new NullPointerException("realName is marked non-null but is null");
            }
            if (gameMode == null) {
                throw new NullPointerException("gameMode is marked non-null but is null");
            }
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            this.uuid = uuid;
            this.realName = realName;
            this.latency = latency;
            this.gameMode = gameMode;
            this.displayName = displayName;
            this.properties = properties;
            this.listed = listed;
        }

        @NotNull
        @Generated
        public UUID uuid() {
            return this.uuid;
        }

        @NotNull
        @Generated
        public String realName() {
            return this.realName;
        }

        @Generated
        public int latency() {
            return this.latency;
        }

        @NotNull
        @Generated
        public GameMode gameMode() {
            return this.gameMode;
        }

        @Nullable
        @Generated
        public Component displayName() {
            return this.displayName;
        }

        @NotNull
        @Generated
        public @NotNull List<@NotNull Property> properties() {
            return this.properties;
        }

        @Generated
        public boolean listed() {
            return this.listed;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlayerInfoData)) {
                return false;
            }
            PlayerInfoData other = (PlayerInfoData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.latency() != other.latency()) {
                return false;
            }
            if (this.listed() != other.listed()) {
                return false;
            }
            UUID this$uuid = this.uuid();
            UUID other$uuid = other.uuid();
            if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
                return false;
            }
            String this$realName = this.realName();
            String other$realName = other.realName();
            if (this$realName == null ? other$realName != null : !this$realName.equals(other$realName)) {
                return false;
            }
            GameMode this$gameMode = this.gameMode();
            GameMode other$gameMode = other.gameMode();
            if (this$gameMode == null ? other$gameMode != null : !this$gameMode.equals(other$gameMode)) {
                return false;
            }
            Component this$displayName = this.displayName();
            Component other$displayName = other.displayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                return false;
            }
            List<Property> this$properties = this.properties();
            List<Property> other$properties = other.properties();
            return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PlayerInfoData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.latency();
            result = result * 59 + (this.listed() ? 79 : 97);
            UUID $uuid = this.uuid();
            result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
            String $realName = this.realName();
            result = result * 59 + ($realName == null ? 43 : $realName.hashCode());
            GameMode $gameMode = this.gameMode();
            result = result * 59 + ($gameMode == null ? 43 : $gameMode.hashCode());
            Component $displayName = this.displayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            List<Property> $properties = this.properties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ClientboundPlayerInfoPacket.PlayerInfoData(uuid=" + String.valueOf(this.uuid()) + ", realName=" + this.realName() + ", latency=" + this.latency() + ", gameMode=" + String.valueOf(this.gameMode()) + ", displayName=" + String.valueOf(this.displayName()) + ", properties=" + String.valueOf(this.properties()) + ", listed=" + this.listed() + ")";
        }
    }

    public static class Property {
        @NotNull
        private final String name;
        @NotNull
        private final String value;
        @Nullable
        private final String signature;

        public Property(@NotNull String name, @NotNull String value) {
            this(name, value, null);
        }

        public boolean hasSignature() {
            return this.signature != null;
        }

        @NotNull
        @Generated
        public String name() {
            return this.name;
        }

        @NotNull
        @Generated
        public String value() {
            return this.value;
        }

        @Nullable
        @Generated
        public String signature() {
            return this.signature;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Property)) {
                return false;
            }
            Property other = (Property)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.name();
            String other$name = other.name();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$value = this.value();
            String other$value = other.value();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$signature = this.signature();
            String other$signature = other.signature();
            return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Property;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.name();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $value = this.value();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $signature = this.signature();
            result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ClientboundPlayerInfoPacket.Property(name=" + this.name() + ", value=" + this.value() + ", signature=" + this.signature() + ")";
        }

        @Generated
        public Property(@NotNull String name, @NotNull String value, @Nullable String signature) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.name = name;
            this.value = value;
            this.signature = signature;
        }
    }
}

