/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.p;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import sba.sl.p.AbstractPacket;
import sba.sl.p.PacketWriter;
import sba.sl.w.Location;

public class ClientboundTeleportEntityPacket
extends AbstractPacket {
    private final int entityId;
    @NotNull
    private final Location location;
    private final boolean onGround;

    @Override
    public void write(@NotNull PacketWriter writer) {
        writer.writeVarInt(this.entityId);
        if (writer.protocol() >= 100) {
            writer.writeVector(this.location);
        } else {
            writer.writeFixedPointVector(this.location);
        }
        if (writer.protocol() >= 768) {
            writer.writeDouble(0.0);
            writer.writeDouble(0.0);
            writer.writeDouble(0.0);
            writer.writeFloat(this.location.getYaw());
            writer.writeFloat(this.location.getPitch());
        } else {
            writer.writeByteRotation(this.location);
        }
        writer.writeBoolean(this.onGround);
    }

    @Generated
    ClientboundTeleportEntityPacket(int entityId, @NotNull Location location, boolean onGround) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        this.entityId = entityId;
        this.location = location;
        this.onGround = onGround;
    }

    @Generated
    public static ClientboundTeleportEntityPacketBuilder builder() {
        return new ClientboundTeleportEntityPacketBuilder();
    }

    @Generated
    public ClientboundTeleportEntityPacketBuilder toBuilder() {
        return new ClientboundTeleportEntityPacketBuilder().entityId(this.entityId).location(this.location).onGround(this.onGround);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundTeleportEntityPacket)) {
            return false;
        }
        ClientboundTeleportEntityPacket other = (ClientboundTeleportEntityPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.entityId() != other.entityId()) {
            return false;
        }
        if (this.onGround() != other.onGround()) {
            return false;
        }
        Location this$location = this.location();
        Location other$location = other.location();
        return !(this$location == null ? other$location != null : !((Object)this$location).equals(other$location));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientboundTeleportEntityPacket;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.entityId();
        result = result * 59 + (this.onGround() ? 79 : 97);
        Location $location = this.location();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        return result;
    }

    @Generated
    public int entityId() {
        return this.entityId;
    }

    @NotNull
    @Generated
    public Location location() {
        return this.location;
    }

    @Generated
    public boolean onGround() {
        return this.onGround;
    }

    @Generated
    public String toString() {
        return "ClientboundTeleportEntityPacket(entityId=" + this.entityId() + ", location=" + String.valueOf(this.location()) + ", onGround=" + this.onGround() + ")";
    }

    @Generated
    public static class ClientboundTeleportEntityPacketBuilder {
        @Generated
        private int entityId;
        @Generated
        private Location location;
        @Generated
        private boolean onGround;

        @Generated
        ClientboundTeleportEntityPacketBuilder() {
        }

        @Generated
        public ClientboundTeleportEntityPacketBuilder entityId(int entityId) {
            this.entityId = entityId;
            return this;
        }

        @Generated
        public ClientboundTeleportEntityPacketBuilder location(@NotNull Location location) {
            if (location == null) {
                throw new NullPointerException("location is marked non-null but is null");
            }
            this.location = location;
            return this;
        }

        @Generated
        public ClientboundTeleportEntityPacketBuilder onGround(boolean onGround) {
            this.onGround = onGround;
            return this;
        }

        @Generated
        public ClientboundTeleportEntityPacket build() {
            return new ClientboundTeleportEntityPacket(this.entityId, this.location, this.onGround);
        }

        @Generated
        public String toString() {
            return "ClientboundTeleportEntityPacket.ClientboundTeleportEntityPacketBuilder(entityId=" + this.entityId + ", location=" + String.valueOf(this.location) + ", onGround=" + this.onGround + ")";
        }
    }
}

