/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.p;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.Server;
import sba.sl.b.Block;
import sba.sl.i.ItemStack;
import sba.sl.i.ItemType;
import sba.sl.nbt.NBTSerializer;
import sba.sl.nbt.SNBTSerializer;
import sba.sl.p.AbstractPacket;
import sba.sl.p.MetadataItem;
import sba.sl.sl.EquipmentSlot;
import sba.sl.spectator.Component;
import sba.sl.u.math.Vector3D;
import sba.sl.u.math.Vector3Df;
import sba.sl.w.Location;

public abstract class PacketWriter
extends OutputStream {
    public static final int MAX_STRING_LENGTH = Short.MAX_VALUE;
    @NotNull
    private final ByteBuf buffer;
    @NotNull
    private final @NotNull List<@NotNull AbstractPacket> appendedPackets = new ArrayList<AbstractPacket>();
    private boolean cancelled;

    public static int getVarIntSize(int value) {
        for (int j = 1; j < 5; ++j) {
            if ((value & -1 << j * 7) != 0) continue;
            return j;
        }
        return 5;
    }

    public static long getVarLongSize(long value) {
        for (int j = 1; j < 10; ++j) {
            if ((value & -1L << j * 7) != 0L) continue;
            return j;
        }
        return 10L;
    }

    public void writeComponent(@Nullable Component component) {
        if (this.protocol() >= 765) {
            if (component == null) {
                this.writeByte((byte)8);
                this.writeSizedString("");
            } else {
                try {
                    this.writeBytes(NBTSerializer.INSTANCE.serializeNetworking1_20_2(SNBTSerializer.builder().build().deserialize(component.toJavaJson(false))));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.writeByte((byte)8);
                    this.writeSizedString(component.toLegacy());
                }
            }
        } else {
            this.writeComponentAsString(component);
        }
    }

    public void writeComponentAsString(@Nullable Component component) {
        this.writeSizedString(component == null ? "{\"text\":\"\"}" : component.toJavaJson());
    }

    public void writeBoolean(boolean b) {
        this.buffer.writeBoolean(b);
    }

    public void writeByte(byte b) {
        this.buffer.writeByte((int)b);
    }

    public void writeChar(char c) {
        this.buffer.writeChar((int)c);
    }

    public void writeShort(int s) {
        this.buffer.writeShort(s);
    }

    public void writeInt(int i) {
        this.buffer.writeInt(i);
    }

    public void writeLong(long l) {
        this.buffer.writeLong(l);
    }

    public void writeFloat(float f) {
        this.buffer.writeFloat(f);
    }

    public void writeDouble(double d) {
        this.buffer.writeDouble(d);
    }

    public void writeVarInt(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            this.buffer.writeByte(value);
        } else if ((value & 0xFFFFC000) == 0) {
            int w = (value & 0x7F | 0x80) << 8 | value >>> 7;
            this.buffer.writeShort(w);
        } else {
            this.writeVarIntFull(value);
        }
    }

    public void writeVarIntFull(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            this.buffer.writeByte(value);
        } else if ((value & 0xFFFFC000) == 0) {
            int w = (value & 0x7F | 0x80) << 8 | value >>> 7;
            this.buffer.writeShort(w);
        } else if ((value & 0xFFE00000) == 0) {
            int w = (value & 0x7F | 0x80) << 16 | (value >>> 7 & 0x7F | 0x80) << 8 | value >>> 14;
            this.buffer.writeMedium(w);
        } else {
            int w = (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | (value >>> 21 & 0x7F | 0x80);
            this.buffer.writeInt(w);
            this.buffer.writeByte(value >>> 28);
        }
    }

    public void writeVarLong(long value) {
        do {
            byte temp = (byte)(value & 0x7FL);
            if ((value >>>= 7) != 0L) {
                temp = (byte)(temp | 0x80);
            }
            this.writeByte(temp);
        } while (value != 0L);
    }

    public void writeSizedString(@NotNull String string) {
        this.writeSizedString(string, Short.MAX_VALUE);
    }

    public void writeSizedString(String string, int maxLength) {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        if (bytes.length > maxLength) {
            throw new UnsupportedOperationException("String too big! (is " + bytes.length + " bytes encoded, should be less than: " + maxLength + ")");
        }
        this.writeVarInt(bytes.length);
        this.buffer.writeBytes(bytes);
    }

    public void writeNullTerminatedString(@NotNull String s) {
        this.buffer.writeCharSequence((CharSequence)(s + "\u0000"), StandardCharsets.UTF_8);
    }

    public void writeVarIntArray(int @Nullable [] array) {
        if (array == null) {
            this.writeVarInt(0);
            return;
        }
        this.writeVarInt(array.length);
        for (int element : array) {
            this.writeVarInt(element);
        }
    }

    public void writeLongArray(long @Nullable [] array) {
        if (array == null) {
            this.writeVarInt(0);
            return;
        }
        this.writeVarInt(array.length);
        for (long element : array) {
            this.writeLong(element);
        }
    }

    public void writeBytes(byte @Nullable [] bytes) {
        this.buffer.writeBytes(bytes);
    }

    public void writeStringCollection(@Nullable Collection<@NotNull String> collection) {
        if (collection == null) {
            this.writeVarInt(0);
            return;
        }
        this.writeVarInt(collection.size());
        for (String element : collection) {
            this.writeSizedString(element);
        }
    }

    public void writeStringArray(@NotNull String @Nullable [] array) {
        if (array == null) {
            this.writeVarInt(0);
            return;
        }
        this.writeVarInt(array.length);
        for (String element : array) {
            this.writeSizedString(element);
        }
    }

    public void writeUuid(@NotNull UUID uuid) {
        this.writeLong(uuid.getMostSignificantBits());
        this.writeLong(uuid.getLeastSignificantBits());
    }

    public void writeBlockPosition(@NotNull Location location) {
        this.writeBlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public void writeByteOffset(@NotNull Vector3Df main, @NotNull Vector3Df location) {
        this.writeByte((byte)(location.getX() - main.getX()));
        this.writeByte((byte)(location.getY() - main.getY()));
        this.writeByte((byte)(location.getZ() - main.getZ()));
    }

    public void writeBlockPosition(int x, int y, int z) {
        this.writeLong(((long)x & 0x3FFFFFFL) << 38 | ((long)z & 0x3FFFFFFL) << 12 | (long)y & 0xFFFL);
    }

    public void writeVector(@NotNull Vector3D vector3D) {
        this.writeDouble(vector3D.getX());
        this.writeDouble(vector3D.getY());
        this.writeDouble(vector3D.getZ());
    }

    public void writeVector(@NotNull Location locationHolder) {
        this.writeVector(locationHolder.asVector());
    }

    public void writeFixedPointVector(@NotNull Location locationHolder) {
        this.writeFixedPointVector(locationHolder.asVector());
    }

    public void writeFixedPointVector(@NotNull Vector3D vector3D) {
        this.writeInt((int)(vector3D.getX() * 32.0));
        this.writeInt((int)(vector3D.getY() * 32.0));
        this.writeInt((int)(vector3D.getZ() * 32.0));
    }

    public void writeByteRotation(@NotNull Location locationHolder) {
        this.writeByteRotation(locationHolder.getYaw(), locationHolder.getPitch());
    }

    public void writeByteRotation(float yaw, float pitch) {
        this.writeByte((byte)(yaw * 256.0f / 360.0f));
        this.writeByte((byte)(pitch * 256.0f / 360.0f));
    }

    public void writeVector(@NotNull Vector3Df vector3Df) {
        this.writeFloat(vector3Df.getX());
        this.writeFloat(vector3Df.getY());
        this.writeFloat(vector3Df.getZ());
    }

    public void writeMotion(@NotNull Vector3D vector3D) {
        this.writeShort((int)(vector3D.getX() * 8000.0));
        this.writeShort((int)(vector3D.getY() * 8000.0));
        this.writeShort((int)(vector3D.getZ() * 8000.0));
    }

    public void writeMove(@NotNull Vector3D vector3D) {
        this.writeShort((int)(vector3D.getX() * 4096.0));
        this.writeShort((int)(vector3D.getY() * 4096.0));
        this.writeShort((int)(vector3D.getZ() * 4096.0));
    }

    public void writeItem(@NotNull ItemStack item) {
        if (this.protocol() >= 766) {
            if (item.getType().isAir() || item.getAmount() == 0) {
                this.writeVarInt(0);
                return;
            }
            this.writeVarInt(item.getAmount());
            this.writeVarInt(this.getItemId(item.getType()));
            this.writeItemComponents(item);
            return;
        }
        if (item.getType().isAir()) {
            if (this.protocol() >= 402) {
                this.writeBoolean(false);
            } else {
                this.writeShort(-1);
            }
        } else {
            if (this.protocol() >= 402) {
                this.writeBoolean(true);
                this.writeVarInt(this.getItemId(item.getType()));
            } else {
                this.writeShort(this.getItemId(item.getType()));
            }
            this.write(item.getAmount());
            if (this.protocol() < 351) {
                this.writeShort(this.getForcedDurability(item.getType()));
            }
            this.writeItemComponents(item);
        }
    }

    public <T> void writeSizedArray(@NotNull @NotNull T @NotNull [] array, @NotNull @NotNull Consumer<@NotNull T> consumer) {
        this.writeVarInt(array.length);
        for (T a : array) {
            consumer.accept(a);
        }
    }

    public <T> void writeSizedCollection(@NotNull @NotNull Collection<@NotNull T> collection, @NotNull @NotNull Consumer<@NotNull T> consumer) {
        this.writeVarInt(collection.size());
        for (T a : collection) {
            consumer.accept(a);
        }
    }

    public <K, V> void writeSizedMap(@NotNull @NotNull Map<@NotNull K, V> map, @NotNull @NotNull BiConsumer<@NotNull K, V> consumer) {
        this.writeVarInt(map.size());
        for (Map.Entry<K, V> a : map.entrySet()) {
            consumer.accept(a.getKey(), a.getValue());
        }
    }

    public void writeBlockData(@NotNull Block blockDataHolder) {
        this.writeVarInt(this.getBlockStateId(blockDataHolder));
    }

    public void writeDataWatcherCollection(@NotNull @NotNull Collection<@NotNull MetadataItem> collection) {
        for (MetadataItem item : collection) {
            item.write(this);
        }
        this.writeByte(this.protocol() <= 47 ? (byte)127 : -1);
    }

    private static double sanitizeLpVec3Component(double d) {
        if (Double.isNaN(d)) {
            return 0.0;
        }
        if (d < -1.7179869183E10) {
            return -1.7179869183E10;
        }
        if (d > 1.7179869183E10) {
            return 1.7179869183E10;
        }
        return d;
    }

    private static long packLpVec3Component(double d) {
        return Math.round((d * 0.5 + 0.5) * 32766.0);
    }

    public void writeLpVec3(Vector3D vec) {
        double sanitizedX = PacketWriter.sanitizeLpVec3Component(vec.getX());
        double sanitizedY = PacketWriter.sanitizeLpVec3Component(vec.getY());
        double sanitizedZ = PacketWriter.sanitizeLpVec3Component(vec.getZ());
        double maxVal = Math.max(Math.abs(sanitizedX), Math.max(Math.abs(sanitizedY), Math.abs(sanitizedZ)));
        if (maxVal < 3.051944088384301E-5) {
            this.buffer.writeByte(0);
            return;
        }
        long scale = (long)Math.ceil(maxVal);
        boolean scaleTooLargeForBits = (scale & 3L) != scale;
        long scaleBits = scaleTooLargeForBits ? scale & 3L | 4L : scale;
        long encodedX = PacketWriter.packLpVec3Component(sanitizedX / (double)scale) << 3;
        long encodedY = PacketWriter.packLpVec3Component(sanitizedY / (double)scale) << 18;
        long encodedZ = PacketWriter.packLpVec3Component(sanitizedZ / (double)scale) << 33;
        long packed = scaleBits | encodedX | encodedY | encodedZ;
        this.buffer.writeByte((int)((byte)packed));
        this.buffer.writeByte((int)((byte)(packed >> 8)));
        this.buffer.writeInt((int)(packed >> 16));
        if (scaleTooLargeForBits) {
            this.writeVarInt((int)(scale >> 2));
        }
    }

    public void writeItemComponents(@NotNull ItemStack item) {
        this.write(0);
    }

    public void append(@NotNull AbstractPacket packet) {
        this.appendedPackets.add(packet);
    }

    @Override
    public void write(int b) {
        this.writeByte((byte)b);
    }

    public int protocol() {
        return Server.getProtocolVersion();
    }

    protected abstract int getItemId(@NotNull ItemType var1);

    protected short getForcedDurability(@NotNull ItemType material) {
        return 0;
    }

    protected abstract int getBlockStateId(@NotNull Block var1);

    public abstract int getEquipmentSlotId(@NotNull EquipmentSlot var1);

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PacketWriter)) {
            return false;
        }
        PacketWriter other = (PacketWriter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isCancelled() != other.isCancelled()) {
            return false;
        }
        ByteBuf this$buffer = this.getBuffer();
        ByteBuf other$buffer = other.getBuffer();
        if (this$buffer == null ? other$buffer != null : !this$buffer.equals(other$buffer)) {
            return false;
        }
        List<AbstractPacket> this$appendedPackets = this.getAppendedPackets();
        List<AbstractPacket> other$appendedPackets = other.getAppendedPackets();
        return !(this$appendedPackets == null ? other$appendedPackets != null : !((Object)this$appendedPackets).equals(other$appendedPackets));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PacketWriter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isCancelled() ? 79 : 97);
        ByteBuf $buffer = this.getBuffer();
        result = result * 59 + ($buffer == null ? 43 : $buffer.hashCode());
        List<AbstractPacket> $appendedPackets = this.getAppendedPackets();
        result = result * 59 + ($appendedPackets == null ? 43 : ((Object)$appendedPackets).hashCode());
        return result;
    }

    @Generated
    public PacketWriter(@NotNull ByteBuf buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        this.buffer = buffer;
    }

    @NotNull
    @Generated
    public ByteBuf getBuffer() {
        return this.buffer;
    }

    @NotNull
    @Generated
    public @NotNull List<@NotNull AbstractPacket> getAppendedPackets() {
        return this.appendedPackets;
    }

    @Generated
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Generated
    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Generated
    public String toString() {
        return "PacketWriter(buffer=" + String.valueOf(this.getBuffer()) + ", appendedPackets=" + String.valueOf(this.getAppendedPackets()) + ", cancelled=" + this.isCancelled() + ")";
    }
}

