/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.p.entity;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import sba.sl.Server;
import sba.sl.p.MetadataItem;
import sba.sl.p.entity.FakeEntity;
import sba.sl.p.entity.FakeLivingEntity;
import sba.sl.u.math.Vector3Df;
import sba.sl.w.Location;

public class FakeArmorStandEntity
extends FakeLivingEntity {
    private byte armorStandFlags = 0;
    @NotNull
    private Vector3Df headRotation = new Vector3Df(0.0f, 0.0f, 0.0f);

    public FakeArmorStandEntity(@NotNull Location location, int typeId) {
        super(location, typeId);
        this.setArmorStandFlags();
    }

    @Override
    public void setGravity(boolean gravity) {
        if (Server.isVersion(1, 10)) {
            this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.HAS_NO_GRAVITY), !gravity));
        } else {
            this.setArmorStandFlagsFromValue(2, gravity);
            this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.ARMOR_STAND_FLAGS), this.armorStandFlags));
        }
    }

    public void setArmorStandFlags() {
        this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.ARMOR_STAND_FLAGS), this.armorStandFlags));
    }

    public void setHeadRotation(@NotNull Vector3Df value) {
        this.headRotation = value;
        this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.HEAD_ROTATION), value));
    }

    public void setBodyRotation(@NotNull Vector3Df value) {
        this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.BODY_ROTATION), value));
    }

    public void setLeftArmRotation(@NotNull Vector3Df value) {
        this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.LEFT_ARM_ROTATION), value));
    }

    public void setRightArmRotation(@NotNull Vector3Df value) {
        this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.RIGHT_ARM_ROTATION), value));
    }

    public void setLeftLegRotation(@NotNull Vector3Df value) {
        this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.LEFT_LEG_ROTATION), value));
    }

    public void setRightLegRotation(@NotNull Vector3Df value) {
        this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.RIGHT_LEG_ROTATION), value));
    }

    public void setMarker(boolean marker) {
        this.setArmorStandFlagsFromValue(16, marker);
        this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.ARMOR_STAND_FLAGS), this.armorStandFlags));
    }

    public void setArms(boolean hasArms) {
        this.setArmorStandFlagsFromValue(4, hasArms);
        this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.ARMOR_STAND_FLAGS), this.armorStandFlags));
    }

    public void setBasePlate(boolean hasBasePlate) {
        this.setArmorStandFlagsFromValue(8, hasBasePlate);
        this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.ARMOR_STAND_FLAGS), this.armorStandFlags));
    }

    public void setSmall(boolean isSmall) {
        this.setArmorStandFlagsFromValue(1, isSmall);
        this.put(MetadataItem.of(FakeEntity.EntityMetadata.Registry.getId(FakeEntity.EntityMetadata.ARMOR_STAND_FLAGS), this.armorStandFlags));
    }

    private void setArmorStandFlagsFromValue(int i, boolean flag) {
        this.armorStandFlags = flag ? (byte)(this.armorStandFlags | i) : (byte)(this.armorStandFlags & ~i);
    }

    @Generated
    public byte getArmorStandFlags() {
        return this.armorStandFlags;
    }

    @NotNull
    @Generated
    public Vector3Df getHeadRotation() {
        return this.headRotation;
    }
}

