/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.sl;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.slot.EquipmentSlotGroupRegistry;
import sba.sl.u.Preconditions;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.MinecraftType;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;

public interface EquipmentSlotGroup
extends RegistryItem,
RawValueHolder {
    @ApiStatus.Experimental
    @NotNull
    public String platformName();

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.EQUIPMENT_SLOT_GROUP) @Nullable Object var1);

    @Override
    public boolean is(Object ... var1);

    @NotNull
    public static EquipmentSlotGroup of(@MinecraftType(value=MinecraftType.Type.EQUIPMENT_SLOT_GROUP) @NotNull Object slot) {
        EquipmentSlotGroup result = EquipmentSlotGroup.ofNullable(slot);
        Preconditions.checkNotNullIllegal(result, "Could not find equipment slot group: " + String.valueOf(slot));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static EquipmentSlotGroup ofNullable(@MinecraftType(value=MinecraftType.Type.EQUIPMENT_SLOT_GROUP) @Nullable Object slot) {
        if (slot instanceof EquipmentSlotGroup) {
            return (EquipmentSlotGroup)slot;
        }
        return (EquipmentSlotGroup)EquipmentSlotGroupRegistry.getInstance().resolveMapping(slot);
    }

    @NotNull
    public static @NotNull RegistryItemStream<@NotNull EquipmentSlotGroup> all() {
        return EquipmentSlotGroupRegistry.getInstance().getRegistryItemStream();
    }
}

