/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.mini.resolvers;

import java.util.ArrayList;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.minitag.nodes.TagNode;
import sba.sl.spectator.BlockNBTComponent;
import sba.sl.spectator.Component;
import sba.sl.spectator.EntityNBTComponent;
import sba.sl.spectator.NBTComponent;
import sba.sl.spectator.StorageNBTComponent;
import sba.sl.spectator.mini.MiniMessageParser;
import sba.sl.spectator.mini.placeholders.Placeholder;
import sba.sl.spectator.mini.resolvers.SingleTagResolver;
import sba.sl.u.ResourceLocation;

public class NbtResolver
implements SingleTagResolver {
    @Override
    @Nullable
    public <B extends Component.Builder<B, C>, C extends Component> B resolve(@NotNull MiniMessageParser parser, @NotNull TagNode tag, Placeholder ... placeholders) {
        NBTComponent.Builder<BlockNBTComponent.Builder, BlockNBTComponent> builder;
        if (tag.getArgs().size() < 3) {
            return null;
        }
        String name = tag.getArgs().get(0).toLowerCase(Locale.ROOT);
        String secondArgument = tag.getArgs().get(1);
        String nbtPathArgument = tag.getArgs().get(2);
        switch (name) {
            case "block": {
                builder = Component.blockNBT().blockPosition(secondArgument);
                break;
            }
            case "entity": {
                builder = Component.entityNBT().selector(secondArgument);
                break;
            }
            case "storage": {
                builder = Component.storageNBT().storageKey(ResourceLocation.of(secondArgument));
                break;
            }
            default: {
                return null;
            }
        }
        builder.nbtPath(nbtPathArgument);
        if (tag.getArgs().size() >= 4) {
            String thirdValue = tag.getArgs().get(3);
            if ("interpret".equalsIgnoreCase(thirdValue)) {
                builder.interpret(true);
            } else {
                builder.separator(parser.parse(thirdValue, placeholders));
                if (tag.getArgs().size() >= 5 && "interpret".equalsIgnoreCase(tag.getArgs().get(4))) {
                    builder.interpret(true);
                }
            }
        }
        return (B)builder;
    }

    @Override
    @Nullable
    public TagNode serialize(@NotNull MiniMessageParser parser, @NotNull String tagName, @NotNull Component component) {
        if (component instanceof NBTComponent) {
            ArrayList<String> args = new ArrayList<String>();
            if (component instanceof BlockNBTComponent) {
                args.add("block");
                args.add(((BlockNBTComponent)component).blockPosition());
            } else if (component instanceof EntityNBTComponent) {
                args.add("entity");
                args.add(((EntityNBTComponent)component).selector());
            } else if (component instanceof StorageNBTComponent) {
                args.add("storage");
                args.add(((StorageNBTComponent)component).storageKey().asString());
            } else {
                return null;
            }
            args.add(((NBTComponent)component).nbtPath());
            Component separator = ((NBTComponent)component).separator();
            if (separator != null) {
                args.add(parser.serialize(separator));
            }
            if (((NBTComponent)component).interpret()) {
                args.add("interpret");
            }
            return new TagNode(tagName, args);
        }
        return null;
    }
}

