/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.mini.resolvers;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.minitag.nodes.TagNode;
import sba.sl.spectator.Component;
import sba.sl.spectator.TranslatableComponent;
import sba.sl.spectator.mini.MiniMessageParser;
import sba.sl.spectator.mini.placeholders.Placeholder;
import sba.sl.spectator.mini.resolvers.SingleTagResolver;

public class TranslatableFallbackResolver
implements SingleTagResolver {
    @Override
    @Nullable
    public <B extends Component.Builder<B, C>, C extends Component> B resolve(@NotNull MiniMessageParser parser, @NotNull TagNode tag, Placeholder ... placeholders) {
        if (tag.getArgs().isEmpty()) {
            return null;
        }
        if (tag.getArgs().size() == 1) {
            return (B)Component.translatable().translate(tag.getArgs().get(0));
        }
        if (tag.getArgs().size() == 2) {
            return (B)Component.translatable().translate(tag.getArgs().get(0)).fallback(tag.getArgs().get(1));
        }
        TranslatableComponent.Builder builder = null;
        boolean fallback = false;
        ArrayList<Component> args = new ArrayList<Component>();
        for (String arg : tag.getArgs()) {
            if (builder == null) {
                builder = Component.translatable().translate(arg);
                continue;
            }
            if (!fallback) {
                fallback = true;
                builder.fallback(arg);
                continue;
            }
            args.add(parser.parse(arg, placeholders));
        }
        builder.args(args);
        return (B)builder;
    }

    @Override
    @Nullable
    public TagNode serialize(@NotNull MiniMessageParser parser, @NotNull String tagName, @NotNull Component component) {
        String fallback;
        if (component instanceof TranslatableComponent && (fallback = ((TranslatableComponent)component).fallback()) != null) {
            ArrayList<String> args = new ArrayList<String>();
            args.add(((TranslatableComponent)component).translate());
            args.add(fallback);
            for (Component arg : ((TranslatableComponent)component).args()) {
                args.add(parser.serialize(arg));
            }
            return new TagNode(tagName, args);
        }
        return null;
    }
}

