/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.u.reflect;

import java.lang.reflect.Executable;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public interface ReflectedExecutable<T extends ReflectedExecutable<T>> {
    default public boolean isPresent() {
        return this.get() != null;
    }

    default public boolean isEmpty() {
        return this.get() == null;
    }

    default public T orElse(T newOne) {
        if (this.isEmpty()) {
            return newOne;
        }
        return this.self();
    }

    default public T orElseGet(Supplier<T> supplier) {
        if (this.isEmpty()) {
            return (T)((ReflectedExecutable)supplier.get());
        }
        return this.self();
    }

    default public T orElseThrow() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("No value present");
        }
        return this.self();
    }

    default public void ifPresent(Consumer<T> consumer) {
        if (this.isPresent()) {
            consumer.accept(this.self());
        }
    }

    default public void ifPresentOrElse(Consumer<T> consumer, Runnable orElse) {
        if (this.isPresent()) {
            consumer.accept(this.self());
        } else {
            orElse.run();
        }
    }

    default public <R> R ifPresentOrElseGet(Function<T, R> function, Supplier<R> orElse) {
        if (this.isPresent()) {
            return function.apply(this.self());
        }
        return orElse.get();
    }

    public T self();

    @Nullable
    public Executable get();
}

