/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.zgmobs;

import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;
import net.frozenblock.zgmobs.Config;
import net.frozenblock.zgmobs.GermoniumUtils;
import net.frozenblock.zgmobs.ZGMobs;
import net.minecraft.core.Holder;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import org.lwjgl.system.NonnullDefault;

@NonnullDefault
public enum Germonium implements StringRepresentable
{
    NORMAL(0, "normal"),
    INFERNIUM(1, "infernium"),
    CELESTIUM(2, "celestium");

    public static final StringRepresentable.EnumCodec<Germonium> CODEC;
    private static final IntFunction<Germonium> BY_ID;
    private final int id;
    private final String name;

    private Germonium(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getSerializedName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public static Germonium byName(String name) {
        return (Germonium)CODEC.byName(name, (Enum)NORMAL);
    }

    public static Germonium byId(int id) {
        return BY_ID.apply(id);
    }

    public void setAttributes(AttributeMap attributes) {
        HashMap<Holder, MobEffect.AttributeTemplate> map = new HashMap<Holder, MobEffect.AttributeTemplate>();
        map.put(Attributes.MAX_HEALTH, Germonium.create(this.forVariant(0, 40, 80).intValue(), AttributeModifier.Operation.ADD_VALUE));
        map.put(Attributes.ATTACK_DAMAGE, Germonium.create(this.forVariant(0, 8, 12).intValue(), AttributeModifier.Operation.ADD_VALUE));
        map.put(Attributes.MOVEMENT_SPEED, Germonium.create(this.forVariant(0.0, 0.5, 0.65), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        map.put(Attributes.KNOCKBACK_RESISTANCE, Germonium.create(this.forVariant(0.0, 0.4, 1.0), AttributeModifier.Operation.ADD_VALUE));
        map.put(Attributes.ARMOR, Germonium.create(this.forVariant(0, 20, 25).intValue(), AttributeModifier.Operation.ADD_VALUE));
        map.put(Attributes.ARMOR_TOUGHNESS, Germonium.create(this.forVariant(0, 15, 20).intValue(), AttributeModifier.Operation.ADD_VALUE));
        for (Map.Entry entry : map.entrySet()) {
            AttributeInstance instance = attributes.getInstance((Holder)entry.getKey());
            if (instance == null) continue;
            instance.removeModifier(((MobEffect.AttributeTemplate)entry.getValue()).id());
            instance.addPermanentModifier(((MobEffect.AttributeTemplate)entry.getValue()).create(0));
        }
    }

    private <T> T forVariant(T normal, T infernium, T celestium) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> normal;
            case 1 -> infernium;
            case 2 -> celestium;
        };
    }

    private static MobEffect.AttributeTemplate create(double amount, AttributeModifier.Operation operation) {
        return new MobEffect.AttributeTemplate(ZGMobs.id("zgmobs.variant.germonium"), amount, operation);
    }

    public static void finalizeSpawn(Mob that) {
        if (that instanceof Enemy) {
            boolean infernium;
            if (!((Boolean)Config.DISABLE_GERMONIUM.get()).booleanValue() && Math.random() * 100.0 > (double)((Integer)Config.GERMONIUM_BASE_CHANCE.get()).intValue()) {
                return;
            }
            boolean bl = infernium = Math.random() * 100.0 > (double)((Integer)Config.CELESTIUM_VARIANT.get()).intValue();
            if (infernium) {
                GermoniumUtils.setupInfernium(that);
            } else {
                GermoniumUtils.setupCelestium(that);
            }
            (infernium ? INFERNIUM : CELESTIUM).setAttributes(that.getAttributes());
            that.setHealth(that.getMaxHealth());
        }
    }

    static {
        CODEC = StringRepresentable.fromEnum(Germonium::values);
        BY_ID = ByIdMap.continuous(Germonium::getId, (Object[])Germonium.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
    }
}

