/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.zgmobs;

import com.google.common.base.MoreObjects;
import java.util.List;
import net.frozenblock.zgmobs.Germonium;
import net.frozenblock.zgmobs.GermoniumUtils;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class ShulkerExplosiveBullet
extends ShulkerBullet {
    public ShulkerExplosiveBullet(Level level, LivingEntity shooter, Entity finalTarget, Direction.Axis axis) {
        super(level, shooter, finalTarget, axis);
    }

    protected void onHitEntity(@NotNull EntityHitResult hitResult) {
        Entity entity = hitResult.getEntity();
        Entity entity1 = this.getOwner();
        LivingEntity livingentity = entity1 instanceof LivingEntity ? (LivingEntity)entity1 : null;
        DamageSource damagesource = this.damageSources().mobProjectile((Entity)this, livingentity);
        boolean flag = entity.hurt(this.damageSources().mobProjectile((Entity)this, livingentity), 4.0f);
        if (flag) {
            assert (livingentity != null);
            EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)this.level()), (Entity)entity, (DamageSource)damagesource);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity1 = (LivingEntity)entity;
                if (Math.random() > 0.5) {
                    List<MobEffectInstance> instances = List.of(new MobEffectInstance(MobEffects.WITHER, 100, 2), new MobEffectInstance(MobEffects.DARKNESS, 100), new MobEffectInstance(MobEffects.HARM, 100, 3), new MobEffectInstance(MobEffects.CONFUSION, 100), new MobEffectInstance(MobEffects.BAD_OMEN, 100, 10), new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 2), new MobEffectInstance(MobEffects.BLINDNESS, 100, 0), new MobEffectInstance(MobEffects.WEAKNESS, 100, 2), new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 100, 2));
                    livingEntity1.addEffect(instances.get((int)(Math.random() * (double)instances.size())), (Entity)MoreObjects.firstNonNull((Object)entity1, (Object)((Object)this)));
                } else {
                    this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 4.5f, Level.ExplosionInteraction.NONE);
                }
            }
        }
    }

    protected boolean canHitEntity(@NotNull Entity entity) {
        if (entity instanceof Mob) {
            return GermoniumUtils.getVariant(entity) == Germonium.NORMAL;
        }
        return super.canHitEntity(entity);
    }
}

