/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.zgmobs;

import java.util.ArrayList;
import java.util.List;
import net.frozenblock.zgmobs.Config;
import net.frozenblock.zgmobs.Germonium;
import net.frozenblock.zgmobs.GermoniumUtils;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Enemy;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@Mod(value="zgmobs")
public class ZGMobs {
    public static final String MOD_ID = "zgmobs";
    public static final Material INFERNIUM_FIRE_0 = new Material(TextureAtlas.LOCATION_BLOCKS, ZGMobs.id("block/infernium_fire_0"));
    public static final Material INFERNIUM_FIRE_1 = new Material(TextureAtlas.LOCATION_BLOCKS, ZGMobs.id("block/infernium_fire_1"));
    public static final Material CELESTIUM_FIRE_0 = new Material(TextureAtlas.LOCATION_BLOCKS, ZGMobs.id("block/celestium_fire_0"));
    public static final Material CELESTIUM_FIRE_1 = new Material(TextureAtlas.LOCATION_BLOCKS, ZGMobs.id("block/celestium_fire_1"));
    public static boolean IGNORE_NEXT_SETUP = false;
    public static EntityDataAccessor<Integer> DATA_GERMONIUM;

    public ZGMobs(IEventBus ignored, ModContainer container) {
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public static List<EntityType<?>> getEntitiesFromTag(ResourceLocation id) {
        TagKey entityTag = TagKey.create((ResourceKey)BuiltInRegistries.ENTITY_TYPE.key(), (ResourceLocation)id);
        ArrayList list = new ArrayList();
        BuiltInRegistries.ENTITY_TYPE.getTagOrEmpty(entityTag).forEach(e -> list.add((EntityType)e.value()));
        return list;
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        LivingEntity that = event.getEntity();
        if (that instanceof Enemy && GermoniumUtils.getVariant((Entity)that) == Germonium.CELESTIUM && !that.level().isClientSide()) {
            List<EntityType<?>> entities = ZGMobs.getEntitiesFromTag(ZGMobs.id("celestium_spawns"));
            int i = 0;
            while ((double)i < Math.random() * (double)((Integer)Config.CELESTIUM_DEATH_ROLL.get()).intValue()) {
                EntityType<?> entityType = entities.get((int)(Math.random() * (double)entities.size()));
                IGNORE_NEXT_SETUP = true;
                Entity entity = entityType.spawn((ServerLevel)that.level(), that.getOnPos().above(), MobSpawnType.REINFORCEMENT);
                assert (entity != null);
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    GermoniumUtils.setupInfernium(mob);
                }
                ++i;
            }
        }
    }
}

