/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.zgmobs.mixin;

import net.frozenblock.zgmobs.Germonium;
import net.frozenblock.zgmobs.GermoniumUtils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Shadow
    @Nullable
    protected Player lastHurtByPlayer;

    @Inject(method={"getExperienceReward"}, at={@At(value="RETURN")}, cancellable=true)
    private void getExperienceReward(CallbackInfoReturnable<Integer> cir) {
        if (this instanceof Enemy) {
            int n = cir.getReturnValueI();
            cir.setReturnValue((Object)(n * (switch (GermoniumUtils.getVariant(this)) {
                default -> throw new MatchException(null, null);
                case Germonium.NORMAL -> 1;
                case Germonium.INFERNIUM -> 15;
                case Germonium.CELESTIUM -> 30;
            })));
        }
    }

    @Inject(method={"dropFromLootTable"}, at={@At(value="TAIL")})
    private void dropFromLootTable(DamageSource damageSource, boolean bl, CallbackInfo ci) {
        if (!(this instanceof Enemy)) {
            return;
        }
        LivingEntity that = (LivingEntity)this;
        ResourceLocation resourcelocation = ResourceLocation.fromNamespaceAndPath((String)"zgmobs", (String)("entities/" + GermoniumUtils.getVariant(this).getSerializedName()));
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)resourcelocation);
        LootTable loottable = that.level().getServer().reloadableRegistries().getLootTable(key);
        LootParams.Builder lootparams$builder = new LootParams.Builder((ServerLevel)that.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)that).withParameter(LootContextParams.ORIGIN, (Object)that.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)damageSource).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)damageSource.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)damageSource.getDirectEntity());
        if (bl && this.lastHurtByPlayer != null) {
            lootparams$builder = lootparams$builder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)this.lastHurtByPlayer).withLuck(this.lastHurtByPlayer.getLuck());
        }
        LootParams lootparams = lootparams$builder.create(LootContextParamSets.ENTITY);
        loottable.getRandomItems(lootparams, that.getLootTableSeed(), arg_0 -> ((LivingEntity)that).spawnAtLocation(arg_0));
    }
}

