/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.zgmobs.mixin;

import net.frozenblock.zgmobs.Config;
import net.frozenblock.zgmobs.Germonium;
import net.frozenblock.zgmobs.GermoniumUtils;
import net.frozenblock.zgmobs.ShulkerExplosiveBullet;
import net.frozenblock.zgmobs.ZGMobs;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Shulker;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Mob.class})
public class MobMixin {
    @Unique
    private int zGMobs$attackTime = 0;
    @Unique
    private Germonium zgmobs$variant = Germonium.NORMAL;

    @Inject(method={"<clinit>"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/syncher/SynchedEntityData;defineId(Ljava/lang/Class;Lnet/minecraft/network/syncher/EntityDataSerializer;)Lnet/minecraft/network/syncher/EntityDataAccessor;", ordinal=0)})
    private static void clinit(CallbackInfo ci) {
        ZGMobs.DATA_GERMONIUM = SynchedEntityData.defineId(Mob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void defineSynchedData(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(ZGMobs.DATA_GERMONIUM, (Object)0);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        if (this instanceof Enemy) {
            nbt.putString("Germonium", GermoniumUtils.getVariant(this).getSerializedName());
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        if (this instanceof Enemy) {
            GermoniumUtils.setVariant(this, Germonium.byName(nbt.getString("Germonium")));
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    private void aiStep(CallbackInfo ci) {
        Mob that = (Mob)this;
        Germonium variant = GermoniumUtils.getVariant((Entity)that);
        if (variant != Germonium.NORMAL) {
            for (int i = 0; i < 3; ++i) {
                that.level().addAlwaysVisibleParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)((float)Math.random()), (float)((float)Math.random()), (float)((float)Math.random())), that.getRandomX(that.getBoundingBox().getXsize() / 2.0), that.getRandomY(), that.getRandomZ(that.getBoundingBox().getZsize() / 2.0), Math.random(), Math.random(), Math.random());
            }
        }
        if (!(that instanceof Shulker) && that.level().getDifficulty() != Difficulty.PEACEFUL && that instanceof Enemy && GermoniumUtils.getVariant((Entity)that) != Germonium.NORMAL) {
            --this.zGMobs$attackTime;
            LivingEntity livingentity = that.getTarget();
            if (livingentity != null && ((Boolean)Config.ENABLE_SHULKER_BULLETS.get()).booleanValue()) {
                that.getLookControl().setLookAt((Entity)livingentity, 180.0f, 180.0f);
                double d0 = that.distanceToSqr((Entity)livingentity);
                if (d0 < 400.0) {
                    if (this.zGMobs$attackTime <= 0) {
                        int min = Config.SHULKER_MIN_COOLDOWN.getAsInt();
                        this.zGMobs$attackTime = min + that.getRandom().nextInt(Config.SHULKER_MAX_COOLDOWN.getAsInt() - min);
                        that.level().addFreshEntity((Entity)new ShulkerExplosiveBullet(that.level(), (LivingEntity)that, (Entity)livingentity, Direction.Axis.Y));
                        if (GermoniumUtils.getVariant((Entity)that) == Germonium.CELESTIUM) {
                            that.level().addFreshEntity((Entity)new ShulkerExplosiveBullet(that.level(), (LivingEntity)that, (Entity)livingentity, Direction.Axis.Y));
                        }
                        that.playSound(SoundEvents.SHULKER_SHOOT, 2.0f, (that.getRandom().nextFloat() - that.getRandom().nextFloat()) * 0.2f + 1.0f);
                    }
                } else {
                    that.setTarget(null);
                }
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        Germonium variant;
        Mob that = (Mob)this;
        if (that instanceof Enemy && (variant = GermoniumUtils.getVariant((Entity)that)) != this.zgmobs$variant) {
            this.zgmobs$variant = variant;
            variant.setAttributes(that.getAttributes());
        }
    }
}

