/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.zgmobs;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.BooleanValue DISABLE_GERMONIUM;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ENTITY_BLACKLIST;
    public static final ForgeConfigSpec.DoubleValue GERMONIUM_BASE_CHANCE;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_VARIANT;
    public static final ForgeConfigSpec.DoubleValue GERMONIUM_SLIME_SIZE;
    public static final ForgeConfigSpec.DoubleValue GERMONIUM_MAGMA_SIZE;
    public static final ForgeConfigSpec.DoubleValue GERMONIUM_PHANTOM_SIZE;
    public static final ForgeConfigSpec.DoubleValue GERMONIUM_GHAST_EXPLOSION_POWER;
    public static final ForgeConfigSpec.BooleanValue GERMONIUM_CHARGED_CREEPER;
    public static final ForgeConfigSpec.IntValue CELESTIUM_DEATH_ROLL_MIN;
    public static final ForgeConfigSpec.IntValue CELESTIUM_DEATH_ROLL_MAX;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_XP_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_XP_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_ADDITIONAL_HEALTH;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_ADDITIONAL_HEALTH;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_ADDITIONAL_DAMAGE;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_ADDITIONAL_DAMAGE;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_ADDITIONAL_ARMOR;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_ADDITIONAL_ARMOR;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_ADDITIONAL_AT;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_ADDITIONAL_AT;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_ADDITIONAL_SPEED;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_ADDITIONAL_SPEED;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_ADDITIONAL_KB;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_ADDITIONAL_KB;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_REFLECT_CHANCE;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_REFLECT_CHANCE;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_REFLECT_DAMAGE;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_REFLECT_DAMAGE;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_REFLECT_DAMAGE_CAP;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_REFLECT_DAMAGE_CAP;
    public static final ForgeConfigSpec.BooleanValue ENABLE_SHULKER_BULLETS;
    public static final ForgeConfigSpec.IntValue INFERNIUM_BULLET_AMOUNT;
    public static final ForgeConfigSpec.IntValue CELESTIUM_BULLET_AMOUNT;
    public static final ForgeConfigSpec.DoubleValue GERMONIUM_BULLET_DAMAGE;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_BULLET_NEGATIVE_EFFECTS_CHANCE;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_BULLET_NEGATIVE_EFFECTS_CHANCE;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_BULLET_EXPLOSION_CHANCE;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_BULLET_EXPLOSION_CHANCE;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_BULLET_EXPLOSION_RADIUS;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_BULLET_EXPLOSION_RADIUS;
    public static final ForgeConfigSpec.IntValue SHULKER_MIN_COOLDOWN;
    public static final ForgeConfigSpec.IntValue SHULKER_MAX_COOLDOWN;
    public static final ForgeConfigSpec.BooleanValue INFERNIUM_BULLET_DESTROYS_BLOCKS;
    public static final ForgeConfigSpec.BooleanValue CELESTIUM_BULLET_DESTROYS_BLOCKS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> INFERNIUM_BULLET_EFFECTS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> CELESTIUM_BULLET_EFFECTS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> CELESTIUM_DEATH_ROLL_ENTITIES;
    static final ForgeConfigSpec SPEC;

    static {
        BUILDER.push("Germonium Spawning");
        DISABLE_GERMONIUM = BUILDER.comment("If true no Germonium variants will spawn.").define("disableGermonium", false);
        GERMONIUM_BASE_CHANCE = BUILDER.comment("It determines the general chance for a hostile mob to become a Germonium Variant. If % is 0.5 then thats 0.5%").defineInRange("germoniumBaseChance", 0.5, 0.0, 100.0);
        CELESTIUM_VARIANT = BUILDER.comment("It determines the chance for Germonium Celestiums to spawn. If for example the % is 50 now there is a 50% chance for both Variants. If % is 0, Germonium Celestiums will not spawn.").defineInRange("germoniumEqualizer", 5.0, 0.0, 100.0);
        GERMONIUM_SLIME_SIZE = BUILDER.comment("It determines the added Size for Germonium Slimes. If value is 0 no extra size is gonna be added.").defineInRange("germoniumSlimeSize", 10.0, 0.0, 50.0);
        GERMONIUM_MAGMA_SIZE = BUILDER.comment("It determines the added Size for Germonium Magma Cubes. If value is 0 no extra size is gonna be added.").defineInRange("germoniumMagmaSize", 10.0, 0.0, 50.0);
        GERMONIUM_PHANTOM_SIZE = BUILDER.comment("It determines the added Size for Germonium Phantoms. If value is 0 no extra size is gonna be added.").defineInRange("germoniumPhantomSize", 6.0, 0.0, 50.0);
        GERMONIUM_GHAST_EXPLOSION_POWER = BUILDER.comment("It determines the added Explosion Power for Germonium Ghasts. If value is 0 no extra explosion power is gonna be added.").defineInRange("germoniumGhastExplosionPower", 5.0, 0.0, 50.0);
        GERMONIUM_CHARGED_CREEPER = BUILDER.comment("If true Germonium Creepers will spawn charged.").define("germoniumCreeperIsCharged", true);
        ENTITY_BLACKLIST = BUILDER.comment(new String[]{"Blacklist of entities or tags that cannot become Germonium variants.", "Use entries like:", " - 'minecraft:wither' for a specific entity", " - '#forge:bosses' for a tag", " - you can also use regex for example: '/^minecraft:(zombie|creeper|enderman|skeleton|spider)$/' or '/^minecraft:[a-z0-9_]+$/'"}).defineListAllowEmpty(List.of("entityBlacklist"), () -> List.of("minecraft:ender_dragon", "minecraft:wither"), obj -> obj instanceof String);
        BUILDER.pop();
        BUILDER.push("Germonium Attributes");
        INFERNIUM_ADDITIONAL_HEALTH = BUILDER.comment("The amount of Health added to Germonium Inferniums. If value is 0 it will not add any Health.").defineInRange("infernium_add_health", 50.0, 0.0, 2.147483647E9);
        CELESTIUM_ADDITIONAL_HEALTH = BUILDER.comment("The amount of Health added to Germonium Celestiums. If value is 0 it will not add any Health.").defineInRange("celestium_add_health", 100.0, 0.0, 2.147483647E9);
        INFERNIUM_ADDITIONAL_DAMAGE = BUILDER.comment("The amount of Damage added to Germonium Inferniums. If value is 0 it will not add any Damage.").defineInRange("infernium_add_damage", 10.0, 0.0, 2.147483647E9);
        CELESTIUM_ADDITIONAL_DAMAGE = BUILDER.comment("The amount of Damage added to Germonium Celestiums. If value is 0 it will not add any Damage.").defineInRange("celestium_add_damage", 20.0, 0.0, 2.147483647E9);
        INFERNIUM_ADDITIONAL_ARMOR = BUILDER.comment("The amount of Armor added to Germonium Inferniums. If value is 0 it will not add any Armor.").defineInRange("infernium_add_armor", 20.0, 0.0, 2.147483647E9);
        CELESTIUM_ADDITIONAL_ARMOR = BUILDER.comment("The amount of Armor added to Germonium Celestiums. If value is 0 it will not add any Armor.").defineInRange("celestium_add_armor", 40.0, 0.0, 2.147483647E9);
        INFERNIUM_ADDITIONAL_AT = BUILDER.comment("The amount of Armor Toughness added to Germonium Inferniums. If value is 0 it will not add any Armor Toughness.").defineInRange("infernium_add_armort", 20.0, 0.0, 2.147483647E9);
        CELESTIUM_ADDITIONAL_AT = BUILDER.comment("The amount of Armor Toughness added to Germonium Celestiums. If value is 0 it will not add any Armor Toughness.").defineInRange("celestium_add_armort", 40.0, 0.0, 2.147483647E9);
        INFERNIUM_ADDITIONAL_SPEED = BUILDER.comment("The % of Speed added to Germonium Inferniums. If value is 0 it will not add Speed. If for example % is 0.5, that is +50% more Speed.").defineInRange("infernium_mult_speed", 0.5, 0.0, 2.147483647E9);
        CELESTIUM_ADDITIONAL_SPEED = BUILDER.comment("The % of Speed added to Germonium Celestiums. If value is 0 it will not add Speed. If for example % is 1.0, that is +100% more Speed.").defineInRange("celestium_mult_speed", 1.0, 0.0, 2.147483647E9);
        INFERNIUM_ADDITIONAL_KB = BUILDER.comment("The % of Knockback Resistance added to Germonium Inferniums. If value is 0 it will not add Knockback Resistance. If for example % is 0.5, that is +50% Knockback Resistance.").defineInRange("infernium_add_kb", 0.5, 0.0, 1.0);
        CELESTIUM_ADDITIONAL_KB = BUILDER.comment("The % of Knockback Resistance added to Germonium Celestiums. If value is 0 it will not add Knockback Resistance. If for example % is 1.0, that is +100% Knockback Resistance.").defineInRange("celestium_add_kb", 1.0, 0.0, 1.0);
        BUILDER.pop();
        BUILDER.push("Germonium Abilities");
        BUILDER.push("Celestium Death Roll");
        CELESTIUM_DEATH_ROLL_MIN = BUILDER.comment("The minimum amount of Germonium Infernium mobs that will be spawned when a Germonium Celestium dies.").defineInRange("celestium_death_roll_min", 1, 0, Integer.MAX_VALUE);
        CELESTIUM_DEATH_ROLL_MAX = BUILDER.comment("The maximum amount of Germonium Infernium mobs that will be spawned when a Germonium Celestium dies.").defineInRange("celestium_death_roll_max", 3, 0, Integer.MAX_VALUE);
        CELESTIUM_DEATH_ROLL_ENTITIES = BUILDER.comment("List of entities that can spawn when a Celestium dies. Namespaced IDs like 'minecraft:zombie'. Blacklisted entities will be skipped.").defineList("entityArray", List.of("minecraft:zombie", "minecraft:skeleton", "minecraft:husk", "minecraft:stray", "minecraft:vindicator", "minecraft:ravager", "minecraft:evoker", "minecraft:pillager", "minecraft:witch", "minecraft:enderman", "minecraft:phantom", "minecraft:slime", "minecraft:magma_cube", "minecraft:vex", "minecraft:wither_skeleton", "minecraft:blaze", "minecraft:zombie_villager", "minecraft:guardian", "minecraft:silverfish", "minecraft:endermite", "minecraft:illusioner"), o -> o instanceof String);
        BUILDER.pop();
        BUILDER.push("Germonium XP Multiplier");
        INFERNIUM_XP_MULTIPLIER = BUILDER.comment("The multiplier for Germonium Inferniums XP. If value is 1 it will not mutiply any XP dropped.").defineInRange("infernium_xp_multiplier", 40.0, 1.0, 2.147483647E9);
        CELESTIUM_XP_MULTIPLIER = BUILDER.comment("The multiplier for Germonium Celestiums XP. If value is 1 it will not mutiply any XP dropped.").defineInRange("celestium_xp_multiplier", 80.0, 1.0, 2.147483647E9);
        BUILDER.pop();
        BUILDER.push("Germonium Reflect Damage");
        INFERNIUM_REFLECT_CHANCE = BUILDER.comment("The % for Germonium Inferniums to reflect damage back. If % is 0 it will never reflect any damage back.").defineInRange("infernium_reflect_chance", 15.0, 0.0, 100.0);
        CELESTIUM_REFLECT_CHANCE = BUILDER.comment("The % for Germonium Celestiums to reflect damage back. If % is 0 it will never reflect any damage back.").defineInRange("celestium_reflect_chance", 30.0, 0.0, 100.0);
        INFERNIUM_REFLECT_DAMAGE = BUILDER.comment("The % of damage reflected by Germonium Inferniums. If % is 30 it will only reflect 30% of the damage back.").defineInRange("infernium_reflect_damage", 30.0, 1.0, 2.147483647E9);
        CELESTIUM_REFLECT_DAMAGE = BUILDER.comment("The % of damage reflected by Germonium Celestiums. If % is 50 it will only reflect 50% of the damage back.").defineInRange("celestium_reflect_damage", 50.0, 1.0, 2.147483647E9);
        INFERNIUM_REFLECT_DAMAGE_CAP = BUILDER.comment("The cap of damage a Germonium Infernium can reflect. For example if the value is 25, only a max of 25 damage can be reflected.").defineInRange("infernium_reflect_damage_cap", 25.0, 1.0, 2.147483647E9);
        CELESTIUM_REFLECT_DAMAGE_CAP = BUILDER.comment("The cap of damage a Germonium Celestium can reflect. For example if the value is 50, only a max of 50 damage can be reflected.").defineInRange("celestium_reflect_damage_cap", 50.0, 1.0, 2.147483647E9);
        BUILDER.pop();
        BUILDER.push("Shulker Bullets");
        ENABLE_SHULKER_BULLETS = BUILDER.comment("Wether the Germonium variants should or should not shoot shulker bullets").define("enable_shulker_bullets", true);
        INFERNIUM_BULLET_AMOUNT = BUILDER.comment("The amount of shulker bullets a Germonium Infernium can shoot at the same time. If 0 no bullets are gonna be shot.").defineInRange("infernium_bullets", 1, 0, Integer.MAX_VALUE);
        CELESTIUM_BULLET_AMOUNT = BUILDER.comment("The amount of shulker bullets a Germonium Celestium can shoot at the same time. If 0 no bullets are gonna be shot.").defineInRange("celestium_bullets", 3, 0, Integer.MAX_VALUE);
        SHULKER_MIN_COOLDOWN = BUILDER.comment("Minimum shulker bullet ability cooldown time (in ticks).").defineInRange("shulker_min_cooldown", 200, 0, Integer.MAX_VALUE);
        SHULKER_MAX_COOLDOWN = BUILDER.comment("Maximum shulker bullet ability cooldown time (in ticks).").defineInRange("shulker_max_cooldown", 400, 0, Integer.MAX_VALUE);
        GERMONIUM_BULLET_DAMAGE = BUILDER.comment("The Damage of the shulker bullet shot from Germonium variants. If Damage is 0, the bullet will not deal any damage.").defineInRange("germonium_bullet_damage", 12.0, 0.0, 2.147483647E9);
        INFERNIUM_BULLET_DESTROYS_BLOCKS = BUILDER.comment("If the shulker bullets from Germonium Inferniums should destroy blocks.").define("infernium_shulker_bullets_destroy", false);
        CELESTIUM_BULLET_DESTROYS_BLOCKS = BUILDER.comment("If the shulker bullets from Germonium Celestiums should destroy blocks.").define("celestium_shulker_bullets_destroy", true);
        INFERNIUM_BULLET_NEGATIVE_EFFECTS_CHANCE = BUILDER.comment("The % for a shulker bullet from a Germonium Infernium to apply a negative effect (Wither, Instant Damage, etc).").defineInRange("infernium_bullet_effect_chance", 25.0, 0.0, 100.0);
        CELESTIUM_BULLET_NEGATIVE_EFFECTS_CHANCE = BUILDER.comment("The % for a shulker bullet from a Germonium Celestium to apply a negative effect (Wither, Instant Damage, etc).").defineInRange("celestium_bullet_effect_chance", 50.0, 0.0, 100.0);
        INFERNIUM_BULLET_EFFECTS = BUILDER.comment("List of effects applied by Infernium bullets in format effect:duration:amplifier").defineList("inferniumEffects", List.of("wither:200:2", "instant_damage:1:2", "slowness:200:3", "weakness:200:1", "mining_fatigue:200:3"), o -> o instanceof String);
        CELESTIUM_BULLET_EFFECTS = BUILDER.comment("List of effects applied by Celestium bullets in format effect:duration:amplifier").defineList("celestiumEffects", List.of("wither:300:4", "instant_damage:1:3", "slowness:300:4", "weakness:300:3", "mining_fatigue:300:4"), o -> o instanceof String);
        INFERNIUM_BULLET_EXPLOSION_CHANCE = BUILDER.comment("The % for a shulker bullet from a Germonium Infernium to explode on impact.").defineInRange("infernium_bullet_explosion_chance", 25.0, 0.0, 100.0);
        CELESTIUM_BULLET_EXPLOSION_CHANCE = BUILDER.comment("The % for a shulker bullet from a Germonium Celestium to explode on impact.").defineInRange("celestium_bullet_explosion_chance", 50.0, 0.0, 100.0);
        INFERNIUM_BULLET_EXPLOSION_RADIUS = BUILDER.comment("The value of the explosion from a Germonium Infernium shulker bullet.").defineInRange("infernium_bullet_explosion_radius", 3.0, 0.0, 2.147483647E9);
        CELESTIUM_BULLET_EXPLOSION_RADIUS = BUILDER.comment("The value of the explosion from a Germonium Infernium shulker bullet.").defineInRange("celestium_bullet_explosion_radius", 6.0, 0.0, 2.147483647E9);
        BUILDER.pop();
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

