/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.zgmobs;

import com.mojang.text2speech.Narrator;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.IntFunction;
import net.frozenblock.zgmobs.Config;
import net.frozenblock.zgmobs.GermoniumUtils;
import net.frozenblock.zgmobs.mixin.CreeperMixin;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Slime;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NonnullDefault;

@NonnullDefault
public enum Germonium implements StringRepresentable
{
    NORMAL(0, "normal"),
    INFERNIUM(1, "infernium"),
    CELESTIUM(2, "celestium");

    public static final StringRepresentable.EnumCodec<Germonium> CODEC;
    private static final IntFunction<Germonium> BY_ID;
    private final int id;
    private final String name;

    private Germonium(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public String m_7912_() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public static Germonium byName(String p_28817_) {
        return (Germonium)CODEC.m_262792_(p_28817_, (Enum)NORMAL);
    }

    public static Germonium byId(int p_28813_) {
        return BY_ID.apply(p_28813_);
    }

    public void setAttributes(AttributeMap attributes) {
        HashMap<Attribute, AttributeModifier> map = new HashMap<Attribute, AttributeModifier>();
        map.put(Attributes.f_22276_, Germonium.create(this.forVariant(0.0, (Double)Config.INFERNIUM_ADDITIONAL_HEALTH.get(), (Double)Config.CELESTIUM_ADDITIONAL_HEALTH.get()), AttributeModifier.Operation.ADDITION));
        map.put(Attributes.f_22281_, Germonium.create(this.forVariant(0.0, (Double)Config.INFERNIUM_ADDITIONAL_DAMAGE.get(), (Double)Config.CELESTIUM_ADDITIONAL_DAMAGE.get()), AttributeModifier.Operation.ADDITION));
        map.put(Attributes.f_22279_, Germonium.create(this.forVariant(0.0, (Double)Config.INFERNIUM_ADDITIONAL_SPEED.get(), (Double)Config.CELESTIUM_ADDITIONAL_SPEED.get()), AttributeModifier.Operation.MULTIPLY_BASE));
        map.put(Attributes.f_22278_, Germonium.create(this.forVariant(0.0, (Double)Config.INFERNIUM_ADDITIONAL_KB.get(), (Double)Config.CELESTIUM_ADDITIONAL_KB.get()), AttributeModifier.Operation.ADDITION));
        map.put(Attributes.f_22284_, Germonium.create(this.forVariant(0.0, (Double)Config.INFERNIUM_ADDITIONAL_ARMOR.get(), (Double)Config.CELESTIUM_ADDITIONAL_ARMOR.get()), AttributeModifier.Operation.ADDITION));
        map.put(Attributes.f_22285_, Germonium.create(this.forVariant(0.0, (Double)Config.INFERNIUM_ADDITIONAL_AT.get(), (Double)Config.CELESTIUM_ADDITIONAL_AT.get()), AttributeModifier.Operation.ADDITION));
        for (Map.Entry entry : map.entrySet()) {
            AttributeInstance instance = attributes.m_22146_((Attribute)entry.getKey());
            if (instance == null) continue;
            instance.m_22120_(((AttributeModifier)entry.getValue()).m_22209_());
            instance.m_22125_((AttributeModifier)entry.getValue());
        }
    }

    private double forVariant(double normal, double infernium, double celestium) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case NORMAL -> normal;
            case INFERNIUM -> infernium;
            case CELESTIUM -> celestium;
        };
    }

    private static AttributeModifier create(double amount, AttributeModifier.Operation operation) {
        return new AttributeModifier(UUID.fromString("d543eb83-b8b1-4626-b320-03b68395c448"), "zgmobs.variant.germonium", amount, operation);
    }

    public static void finalizeSpawn(Mob mob, @Nullable Germonium germonium) {
        boolean infernium;
        if (GermoniumUtils.isBlacklisted(mob)) {
            return;
        }
        if (!(mob instanceof Enemy)) {
            return;
        }
        if (((Boolean)Config.DISABLE_GERMONIUM.get()).booleanValue()) {
            return;
        }
        if (germonium == NORMAL) {
            return;
        }
        double roll = Math.random() * 100.0;
        if (roll > (Double)Config.GERMONIUM_BASE_CHANCE.get()) {
            return;
        }
        if (mob instanceof Creeper) {
            Creeper creeper = (Creeper)mob;
            if (((Boolean)Config.GERMONIUM_CHARGED_CREEPER.get()).booleanValue()) {
                creeper.m_20088_().m_135381_(CreeperMixin.accessor$DATA_IS_POWERED(), (Object)true);
            }
        } else if (mob instanceof Slime) {
            Slime slime = (Slime)mob;
            int newSize = slime.m_33632_() + ((Double)Config.GERMONIUM_SLIME_SIZE.get()).intValue();
            slime.m_7839_(newSize, true);
        } else if (mob instanceof MagmaCube) {
            MagmaCube cube = (MagmaCube)mob;
            int newSize = cube.m_33632_() + ((Double)Config.GERMONIUM_MAGMA_SIZE.get()).intValue();
            cube.m_7839_(newSize, true);
        } else if (mob instanceof Phantom) {
            Phantom phantom = (Phantom)mob;
            int newSize = (int)(phantom.m_6134_() + (float)((Double)Config.GERMONIUM_PHANTOM_SIZE.get()).intValue());
            phantom.m_33108_(newSize);
        } else if (mob instanceof Ghast) {
            Ghast ghast = (Ghast)mob;
            try {
                Field explosionPowerField = Ghast.class.getDeclaredField("explosionPower");
                explosionPowerField.setAccessible(true);
                int current = explosionPowerField.getInt(ghast);
                explosionPowerField.setInt(ghast, (int)((double)current + (Double)Config.GERMONIUM_GHAST_EXPLOSION_POWER.get()));
            }
            catch (Exception e) {
                Narrator.LOGGER.error("Failed to modify Ghast explosion power", (Throwable)e);
            }
        }
        boolean bl = germonium == null ? Math.random() * 100.0 > (Double)Config.CELESTIUM_VARIANT.get() : (infernium = germonium == INFERNIUM);
        if (infernium) {
            GermoniumUtils.setupInfernium(mob);
        } else {
            GermoniumUtils.setupCelestium(mob);
        }
        (infernium ? INFERNIUM : CELESTIUM).setAttributes(mob.m_21204_());
        mob.m_21153_(mob.m_21233_());
    }

    static {
        CODEC = StringRepresentable.m_216439_(Germonium::values);
        BY_ID = ByIdMap.m_262839_(Germonium::getId, (Object[])Germonium.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
    }
}

