/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.zgmobs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.frozenblock.zgmobs.Config;
import net.frozenblock.zgmobs.Germonium;
import net.frozenblock.zgmobs.ZGMobs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraftforge.registries.ForgeRegistries;

public class GermoniumUtils {
    public static final Map<String, Pattern> regexCache = new HashMap<String, Pattern>();

    private GermoniumUtils() {
    }

    public static void setVariant(Object entity, Germonium germonium) {
        GermoniumUtils.setVariant((Entity)entity, germonium);
    }

    public static void setVariant(Entity entity, Germonium germonium) {
        entity.m_20088_().m_135381_(ZGMobs.DATA_GERMONIUM, (Object)germonium.getId());
    }

    public static Germonium getVariant(Object entity) {
        if (!(entity instanceof LivingEntity)) {
            return null;
        }
        if (!(entity instanceof Enemy)) {
            return null;
        }
        return GermoniumUtils.getVariant((Entity)entity);
    }

    public static Germonium getVariant(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return null;
        }
        if (!(entity instanceof Enemy)) {
            return null;
        }
        return Germonium.byId((Integer)entity.m_20088_().m_135370_(ZGMobs.DATA_GERMONIUM));
    }

    public static boolean isBlacklisted(Mob mob) {
        List blacklist = (List)Config.ENTITY_BLACKLIST.get();
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
        if (key == null) {
            return false;
        }
        String entityId = key.toString();
        for (String entry : blacklist) {
            String patternStr;
            Pattern pattern;
            if (entry.startsWith("#")) {
                ResourceLocation tagId = new ResourceLocation(entry.substring(1));
                TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)tagId);
                if (!mob.m_6095_().m_204039_(tag)) continue;
                return true;
            }
            if (!(entry.startsWith("/") && entry.endsWith("/") ? (pattern = regexCache.computeIfAbsent(patternStr = entry.substring(1, entry.length() - 1), Pattern::compile)).matcher(entityId).matches() : entityId.equals(entry))) continue;
            return true;
        }
        return false;
    }

    public static void setupInfernium(Mob that) {
        GermoniumUtils.setVariant((Entity)that, Germonium.INFERNIUM);
    }

    public static void setupCelestium(Mob that) {
        GermoniumUtils.setVariant((Entity)that, Germonium.CELESTIUM);
    }
}

