/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.zgmobs;

import java.util.List;
import java.util.regex.Pattern;
import net.frozenblock.zgmobs.Config;
import net.frozenblock.zgmobs.Germonium;
import net.frozenblock.zgmobs.GermoniumUtils;
import net.frozenblock.zgmobs.ZGMobsClient;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

@Mod(value="zgmobs")
public class ZGMobs {
    public static final String MOD_ID = "zgmobs";
    public static EntityDataAccessor<Integer> DATA_GERMONIUM;

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public ZGMobs(FMLJavaModLoadingContext ctx) {
        ctx.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ZGMobsClient::initClient);
    }

    public static List<EntityType<?>> getEntitiesFromTag(ResourceLocation tagId) {
        TagKey entityTag = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)tagId);
        ITagManager nullable = ForgeRegistries.ENTITY_TYPES.tags();
        return nullable == null ? List.of() : nullable.getTag(entityTag).stream().toList();
    }

    @SubscribeEvent
    public void livingDeath(LivingDeathEvent event) {
        int maxRoll;
        LivingEntity that = event.getEntity();
        if (!(that instanceof Enemy) || GermoniumUtils.getVariant((Entity)that) != Germonium.CELESTIUM || that.m_9236_().m_5776_()) {
            return;
        }
        List entityArray = (List)Config.CELESTIUM_DEATH_ROLL_ENTITIES.get();
        if (entityArray.isEmpty()) {
            return;
        }
        List<String> validEntities = entityArray.stream().filter(id -> !ZGMobs.isBlacklisted(id)).toList();
        if (validEntities.isEmpty()) {
            return;
        }
        int minRoll = (Integer)Config.CELESTIUM_DEATH_ROLL_MIN.get();
        if (minRoll > (maxRoll = ((Integer)Config.CELESTIUM_DEATH_ROLL_MAX.get()).intValue())) {
            int temp = minRoll;
            minRoll = maxRoll;
            maxRoll = temp;
        }
        int roll = minRoll + (int)(Math.random() * (double)(maxRoll - minRoll + 1));
        ServerLevel level = (ServerLevel)that.m_9236_();
        for (int i = 0; i < roll; ++i) {
            String chosenId = validEntities.get((int)(Math.random() * (double)validEntities.size()));
            ResourceLocation key = new ResourceLocation(chosenId);
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(key);
            if (entityType == null) continue;
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Germonium", "infernium");
            entityType.m_262455_(level, tag, null, that.m_20097_().m_7494_(), MobSpawnType.NATURAL, false, false);
        }
    }

    private static boolean isBlacklisted(String entityId) {
        List blacklist = (List)Config.ENTITY_BLACKLIST.get();
        for (String entry : blacklist) {
            String patternStr;
            Pattern pattern;
            if (entry.startsWith("#")) {
                ResourceLocation tagId = new ResourceLocation(entry.substring(1));
                TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)tagId);
                EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(entityId));
                if (type == null || !type.m_204039_(tag)) continue;
                return true;
            }
            if (!(entry.startsWith("/") && entry.endsWith("/") ? (pattern = GermoniumUtils.regexCache.computeIfAbsent(patternStr = entry.substring(1, entry.length() - 1), Pattern::compile)).matcher(entityId).matches() : entityId.equals(entry))) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingHurtEvent event) {
        LivingEntity target = event.getEntity();
        DamageSource source = event.getSource();
        Entity attacker = source.m_7639_();
        Germonium variant = GermoniumUtils.getVariant((Entity)target);
        if (variant == null || variant == Germonium.NORMAL) {
            return;
        }
        if (target.m_9236_().m_5776_()) {
            return;
        }
        if (!target.m_6084_()) {
            return;
        }
        if (attacker == null) {
            return;
        }
        if (attacker instanceof Projectile) {
            Projectile projectile = (Projectile)attacker;
            Entity shooter = projectile.m_19749_();
            if (shooter instanceof LivingEntity) {
                attacker = shooter;
            } else {
                return;
            }
        }
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        float damage = event.getAmount();
        if (variant == Germonium.INFERNIUM && Math.floor(Math.random() * 100.0) + 1.0 <= (Double)Config.INFERNIUM_REFLECT_CHANCE.get()) {
            float reflect = (float)Math.min((double)damage * ((Double)Config.INFERNIUM_REFLECT_DAMAGE.get() / 100.0), (Double)Config.INFERNIUM_REFLECT_DAMAGE_CAP.get());
            attacker.m_6469_(target.m_9236_().m_269111_().m_269333_(target), reflect);
        } else if (variant == Germonium.CELESTIUM && Math.floor(Math.random() * 100.0) + 1.0 <= (Double)Config.CELESTIUM_REFLECT_CHANCE.get()) {
            float reflect = (float)Math.min((double)damage * ((Double)Config.CELESTIUM_REFLECT_DAMAGE.get() / 100.0), (Double)Config.CELESTIUM_REFLECT_DAMAGE_CAP.get());
            attacker.m_6469_(target.m_9236_().m_269111_().m_269333_(target), reflect);
        }
    }
}

