/*
 * Decompiled with CFR 0.152.
 */
package zeta.org.zgmobs.germonium;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import zeta.org.zgmobs.germonium.items.ItemRegistry;
import zeta.org.zgmobs.main.Config;

@Mod.EventBusSubscriber(modid="zgmobs", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ChestLootInjector {
    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (!((Boolean)Config.CHEST_LOOT_ENABLED.get()).booleanValue()) {
            return;
        }
        ResourceLocation table = event.getName();
        List<ResourceLocation> targetTables = ((List)Config.CHEST_LOOT_TABLES.get()).stream().map(ResourceLocation::new).toList();
        if (!targetTables.contains(table)) {
            return;
        }
        float chance = ((Double)Config.CHEST_LOOT_CHANCE.get()).floatValue();
        int min = (Integer)Config.CHEST_LOOT_MIN.get();
        int max = (Integer)Config.CHEST_LOOT_MAX.get();
        Item itemToInject = switch ((Config.ChestLootItem)((Object)Config.CHEST_LOOT_ITEM.get())) {
            case Config.ChestLootItem.SHARD -> (Item)ItemRegistry.HEART_CRYSTAL_SHARD.get();
            case Config.ChestLootItem.HEART -> (Item)ItemRegistry.HEART_CRYSTAL.get();
            default -> (Item)ItemRegistry.HEART_CRYSTAL_DUST.get();
        };
        LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)itemToInject).m_79707_(((Integer)Config.CHEST_LOOT_ITEM_WEIGHT.get()).intValue()).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max)));
        LootPool pool = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)entry).m_79080_(LootItemRandomChanceCondition.m_81927_((float)(chance / 100.0f))).name("zgmobs_injected_loot").m_79082_();
        event.getTable().addPool(pool);
    }
}

