/*
 * Decompiled with CFR 0.152.
 */
package zeta.org.zgmobs.germonium;

import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import zeta.org.zgmobs.germonium.capabilities.ExtraHealthProvider;
import zeta.org.zgmobs.main.Config;
import zeta.org.zgmobs.network.ZGNetwork;

@Mod.EventBusSubscriber(modid="zgmobs")
public class PlayerHealthStuff {
    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("zgmobs", "extra_health"), (ICapabilityProvider)new ExtraHealthProvider());
        }
    }

    @SubscribeEvent
    public static void PlayerCloneData(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        event.getOriginal().getCapability(ExtraHealthProvider.EXTRA_HEALTH).ifPresent(oldData -> event.getEntity().getCapability(ExtraHealthProvider.EXTRA_HEALTH).ifPresent(newData -> {
            int newHearts = oldData.getExtraHearts();
            if (!event.isWasDeath()) {
                newData.setExtraHearts(newHearts);
                return;
            }
            if (((Boolean)Config.LOOSE_EXTRA_HEALTH_ON_DEATH.get()).booleanValue()) {
                int loss = ((Double)Config.EXTRA_HEALTH_LOST_PER_DEATH.get()).intValue();
                newHearts = Math.max(0, newHearts - loss);
            }
            newData.setExtraHearts(newHearts);
        }));
    }

    @SubscribeEvent
    public static void PlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        player.getCapability(ExtraHealthProvider.EXTRA_HEALTH).ifPresent(health -> {
            Objects.requireNonNull(player.m_21051_(Attributes.f_22276_)).m_22100_(20.0 + (double)health.getExtraHearts());
            player.m_21153_(player.m_21233_());
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ZGNetwork.sendExtraHealthSync(serverPlayer, health.getExtraHearts());
            }
        });
    }

    @SubscribeEvent
    public static void PlayerRelog(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        player.getCapability(ExtraHealthProvider.EXTRA_HEALTH).ifPresent(health -> {
            Objects.requireNonNull(player.m_21051_(Attributes.f_22276_)).m_22100_(20.0 + (double)health.getExtraHearts());
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ZGNetwork.sendExtraHealthSync(serverPlayer, health.getExtraHearts());
            }
        });
    }
}

