/*
 * Decompiled with CFR 0.152.
 */
package zeta.org.zgmobs.germonium;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import zeta.org.zgmobs.germonium.Germonium;
import zeta.org.zgmobs.germonium.GermoniumUtils;
import zeta.org.zgmobs.main.Config;

public class ShulkerExplosiveBullet
extends ShulkerBullet {
    public ShulkerExplosiveBullet(Level p_37330_, LivingEntity p_37331_, Entity p_37332_, Direction.Axis p_37333_) {
        super(p_37330_, p_37331_, p_37332_, p_37333_);
    }

    private List<MobEffectInstance> parseEffects(List<? extends String> configList) {
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        for (String string : configList) {
            try {
                String[] parts = string.split(":");
                if (parts.length != 3) continue;
                MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(parts[0]));
                int duration = Integer.parseInt(parts[1]);
                int amplifier = Integer.parseInt(parts[2]);
                if (effect == null) continue;
                effects.add(new MobEffectInstance(effect, duration, amplifier));
            }
            catch (Exception exception) {}
        }
        return effects;
    }

    protected void m_5790_(@NotNull EntityHitResult hitResult) {
        Entity entity = hitResult.m_82443_();
        Entity entity1 = this.m_19749_();
        float bulletDamage = ((Double)Config.GERMONIUM_BULLET_DAMAGE.get()).floatValue();
        LivingEntity livingentity = entity1 instanceof LivingEntity ? (LivingEntity)entity1 : null;
        boolean flag = entity.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)livingentity), bulletDamage);
        if (flag) {
            assert (livingentity != null);
            this.m_19970_(livingentity, entity);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity1 = (LivingEntity)entity;
                Germonium variant = GermoniumUtils.getVariant(entity1);
                if (variant == Germonium.NORMAL) {
                    return;
                }
                if (variant == Germonium.INFERNIUM) {
                    List<MobEffectInstance> instances;
                    if (Math.floor(Math.random() * 100.0) + 1.0 <= (Double)Config.INFERNIUM_BULLET_NEGATIVE_EFFECTS_CHANCE.get() && !(instances = this.parseEffects((List)Config.INFERNIUM_BULLET_EFFECTS.get())).isEmpty()) {
                        livingEntity1.m_147207_(instances.get((int)(Math.random() * (double)instances.size())), (Entity)MoreObjects.firstNonNull((Object)entity1, (Object)((Object)this)));
                    }
                    if (Math.floor(Math.random() * 100.0) + 1.0 <= (Double)Config.INFERNIUM_BULLET_EXPLOSION_CHANCE.get()) {
                        float explosion = ((Double)Config.INFERNIUM_BULLET_EXPLOSION_RADIUS.get()).floatValue();
                        Level.ExplosionInteraction mode = (Boolean)Config.INFERNIUM_BULLET_DESTROYS_BLOCKS.get() != false ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE;
                        this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), explosion, mode);
                    }
                } else if (variant == Germonium.CELESTIUM) {
                    List<MobEffectInstance> instances;
                    if (Math.floor(Math.random() * 100.0) + 1.0 <= (Double)Config.CELESTIUM_BULLET_NEGATIVE_EFFECTS_CHANCE.get() && !(instances = this.parseEffects((List)Config.CELESTIUM_BULLET_EFFECTS.get())).isEmpty()) {
                        livingEntity1.m_147207_(instances.get((int)(Math.random() * (double)instances.size())), (Entity)MoreObjects.firstNonNull((Object)entity1, (Object)((Object)this)));
                    }
                    if (Math.floor(Math.random() * 100.0) + 1.0 <= (Double)Config.CELESTIUM_BULLET_EXPLOSION_CHANCE.get()) {
                        float explosion = ((Double)Config.CELESTIUM_BULLET_EXPLOSION_RADIUS.get()).floatValue();
                        Level.ExplosionInteraction mode = (Boolean)Config.CELESTIUM_BULLET_DESTROYS_BLOCKS.get() != false ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE;
                        this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), explosion, mode);
                    }
                }
            }
        }
    }

    public boolean m_6128_() {
        return true;
    }

    protected boolean m_5603_(@NotNull Entity entity) {
        if (entity == this || entity.m_213877_()) {
            return false;
        }
        Entity owner = this.m_19749_();
        if (owner == null || owner.m_213877_()) {
            return false;
        }
        if (entity == owner) {
            return false;
        }
        if (!(entity instanceof Enemy) || !(owner instanceof LivingEntity)) {
            return super.m_5603_(entity);
        }
        Germonium shooterVariant = GermoniumUtils.getVariant(owner);
        Germonium targetVariant = GermoniumUtils.getVariant(entity);
        if (shooterVariant == null || targetVariant == null) {
            return super.m_5603_(entity);
        }
        if (shooterVariant == Germonium.NORMAL) {
            return super.m_5603_(entity);
        }
        if (shooterVariant == Germonium.INFERNIUM && targetVariant == Germonium.INFERNIUM && ((Boolean)Config.INFERNIUM_IMMUNE_TO_INFERNIUM_BULLETS.get()).booleanValue()) {
            return false;
        }
        if (shooterVariant == Germonium.CELESTIUM && targetVariant == Germonium.CELESTIUM && ((Boolean)Config.CELESTIUM_IMMUNE_TO_CELESTIUM_BULLETS.get()).booleanValue()) {
            return false;
        }
        if (shooterVariant == Germonium.INFERNIUM && targetVariant == Germonium.CELESTIUM && ((Boolean)Config.CELESTIUM_IMMUNE_TO_INFERNIUM_BULLETS.get()).booleanValue()) {
            return false;
        }
        if (shooterVariant == Germonium.CELESTIUM && targetVariant == Germonium.INFERNIUM && ((Boolean)Config.INFERNIUM_IMMUNE_TO_CELESTIUM_BULLETS.get()).booleanValue()) {
            return false;
        }
        return super.m_5603_(entity);
    }
}

