/*
 * Decompiled with CFR 0.152.
 */
package zeta.org.zgmobs.germonium.items;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import zeta.org.zgmobs.germonium.capabilities.ExtraHealthProvider;
import zeta.org.zgmobs.main.Config;

public class ItemHeartCrystal
extends Item {
    public ItemHeartCrystal(Item.Properties properties) {
        super(properties);
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return (Integer)Config.HEART_CRYSTAL_USE_DURATION.get();
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.BOW;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Integer minLevelRequired = (Integer)Config.MIN_LEVEL_REQUIRED.get();
        String MaxMessage = Component.m_237115_((String)"zgmobs.texts.extra_hearts_maximum_message").getString();
        if (player.f_36078_ < (Integer)Config.MIN_LEVEL_REQUIRED.get() && !player.m_7500_()) {
            if (level.f_46443_) {
                player.m_5661_((Component)Component.m_237110_((String)"zgmobs.texts.min_level_message", (Object[])new Object[]{minLevelRequired}).m_130940_(ChatFormatting.YELLOW), true);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        boolean atMax = player.getCapability(ExtraHealthProvider.EXTRA_HEALTH).map(health -> (double)health.getExtraHearts() >= (Double)Config.MAX_EXTRA_HEALTH.get()).orElse(false);
        if (atMax) {
            if (level.f_46443_) {
                player.m_5661_((Component)Component.m_237113_((String)MaxMessage).m_130940_(ChatFormatting.RED), true);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity) {
        String MaxMessage = Component.m_237115_((String)"zgmobs.texts.extra_hearts_maximum_message").getString();
        if (!(entity instanceof Player)) {
            return stack;
        }
        Player player = (Player)entity;
        if (player.f_36078_ >= (Integer)Config.MIN_LEVEL_REQUIRED.get() && !player.m_7500_()) {
            player.m_6749_(-((Integer)Config.XP_LEVELS_CONSUMED.get()).intValue());
        }
        player.getCapability(ExtraHealthProvider.EXTRA_HEALTH).ifPresent(health -> {
            int maxExtra = ((Double)Config.MAX_EXTRA_HEALTH.get()).intValue();
            int perCrystal = ((Double)Config.EXTRA_HEALTH_PER_HEART.get()).intValue();
            if (health.getExtraHearts() >= maxExtra) {
                if (level.f_46443_) {
                    player.m_5661_((Component)Component.m_237113_((String)MaxMessage).m_130940_(ChatFormatting.RED), true);
                }
                return;
            }
            health.addExtraHearts(perCrystal);
            Objects.requireNonNull(player.m_21051_(Attributes.f_22276_)).m_22100_(20.0 + (double)health.getExtraHearts());
            if (!level.f_46443_) {
                level.m_6269_(null, (Entity)player, SoundEvents.f_12275_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                for (int i = 0; i < 50; ++i) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123750_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 0.1, 0.1, 0.1);
                }
                if (((Boolean)Config.ALLOW_HEART_CRYSTAL_REGEN.get()).booleanValue()) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, ((Integer)Config.HEART_CRYSTAL_REGEN_DURATION.get()).intValue(), ((Integer)Config.HEART_CRYSTAL_REGEN_AMPLIFIER.get()).intValue()));
                }
            }
            if (level.f_46443_) {
                Minecraft.m_91087_().f_91063_.m_109113_(stack);
            }
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
        });
        return stack;
    }
}

