/*
 * Decompiled with CFR 0.152.
 */
package zeta.org.zgmobs.main;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.BooleanValue DISABLE_GERMONIUM;
    public static final ForgeConfigSpec.BooleanValue LSO_COMPAT;
    public static final ForgeConfigSpec.BooleanValue ALLOW_GERMONIUM_FROM_SPAWNERS;
    public static final ForgeConfigSpec.BooleanValue INFERNIUM_ALT_TEXTURE;
    public static final ForgeConfigSpec.BooleanValue CELESTIUM_ALT_TEXTURE;
    public static final ForgeConfigSpec.BooleanValue INFERNIUM_ALT_TEXTURE2;
    public static final ForgeConfigSpec.BooleanValue CELESTIUM_ALT_TEXTURE2;
    public static final ForgeConfigSpec.BooleanValue INFERNIUM_ALT_TEXTURE3;
    public static final ForgeConfigSpec.BooleanValue CELESTIUM_ALT_TEXTURE3;
    public static final ForgeConfigSpec.BooleanValue LOOSE_EXTRA_HEALTH_ON_DEATH;
    public static final ForgeConfigSpec.DoubleValue EXTRA_HEALTH_LOST_PER_DEATH;
    public static final ForgeConfigSpec.DoubleValue MAX_EXTRA_HEALTH;
    public static final ForgeConfigSpec.DoubleValue EXTRA_HEALTH_PER_HEART;
    public static final ForgeConfigSpec.BooleanValue ALLOW_HEART_CRYSTAL_REGEN;
    public static final ForgeConfigSpec.IntValue HEART_CRYSTAL_REGEN_DURATION;
    public static final ForgeConfigSpec.IntValue HEART_CRYSTAL_REGEN_AMPLIFIER;
    public static final ForgeConfigSpec.IntValue MIN_LEVEL_REQUIRED;
    public static final ForgeConfigSpec.IntValue XP_LEVELS_CONSUMED;
    public static final ForgeConfigSpec.IntValue HEART_CRYSTAL_USE_DURATION;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_DROP_RATE;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_DROP_RATE;
    public static final ForgeConfigSpec.IntValue INFERNIUM_DROP_MIN;
    public static final ForgeConfigSpec.IntValue INFERNIUM_DROP_MAX;
    public static final ForgeConfigSpec.IntValue CELESTIUM_DROP_MIN;
    public static final ForgeConfigSpec.IntValue CELESTIUM_DROP_MAX;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ENTITY_BLACKLIST;
    public static final ForgeConfigSpec.DoubleValue GERMONIUM_BASE_CHANCE;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_VARIANT;
    public static final ForgeConfigSpec.DoubleValue GERMONIUM_SLIME_SIZE_MIN;
    public static final ForgeConfigSpec.DoubleValue GERMONIUM_SLIME_SIZE_MAX;
    public static final ForgeConfigSpec.DoubleValue GERMONIUM_MAGMA_SIZE_MIN;
    public static final ForgeConfigSpec.DoubleValue GERMONIUM_MAGMA_SIZE_MAX;
    public static final ForgeConfigSpec.DoubleValue GERMONIUM_PHANTOM_SIZE_MIN;
    public static final ForgeConfigSpec.DoubleValue GERMONIUM_PHANTOM_SIZE_MAX;
    public static final ForgeConfigSpec.DoubleValue GERMONIUM_GHAST_EXPLOSION_POWER_MIN;
    public static final ForgeConfigSpec.DoubleValue GERMONIUM_GHAST_EXPLOSION_POWER_MAX;
    public static final ForgeConfigSpec.DoubleValue GERMONIUM_CHARGED_CREEPER_CHANCE;
    public static final ForgeConfigSpec.DoubleValue GERMONIUM_CREEPER_EXPLOSION_POWER_MIN;
    public static final ForgeConfigSpec.DoubleValue GERMONIUM_CREEPER_EXPLOSION_POWER_MAX;
    public static final ForgeConfigSpec.BooleanValue GERMONIUM_IMMUNE_TO_SUFFOCATION;
    public static final ForgeConfigSpec.BooleanValue GERMONIUM_IMMUNE_TO_DROWNING;
    public static final ForgeConfigSpec.BooleanValue INFERNIUM_IMMUNE_TO_INFERNIUM_BULLETS;
    public static final ForgeConfigSpec.BooleanValue INFERNIUM_IMMUNE_TO_CELESTIUM_BULLETS;
    public static final ForgeConfigSpec.BooleanValue CELESTIUM_IMMUNE_TO_CELESTIUM_BULLETS;
    public static final ForgeConfigSpec.BooleanValue CELESTIUM_IMMUNE_TO_INFERNIUM_BULLETS;
    public static final ForgeConfigSpec.IntValue CELESTIUM_DEATH_ROLL_MIN;
    public static final ForgeConfigSpec.IntValue CELESTIUM_DEATH_ROLL_MAX;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_XP_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_XP_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_ADDITIONAL_HEALTH;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_ADDITIONAL_HEALTH;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_ADDITIONAL_DAMAGE;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_ADDITIONAL_DAMAGE;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_ADDITIONAL_ARMOR;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_ADDITIONAL_ARMOR;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_ADDITIONAL_AT;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_ADDITIONAL_AT;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_ADDITIONAL_SPEED;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_ADDITIONAL_SPEED;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_ADDITIONAL_KB;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_ADDITIONAL_KB;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_REFLECT_CHANCE;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_REFLECT_CHANCE;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_REFLECT_DAMAGE;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_REFLECT_DAMAGE;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_REFLECT_DAMAGE_CAP;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_REFLECT_DAMAGE_CAP;
    public static final ForgeConfigSpec.BooleanValue ENABLE_SHULKER_BULLETS;
    public static final ForgeConfigSpec.IntValue INFERNIUM_BULLET_AMOUNT;
    public static final ForgeConfigSpec.IntValue CELESTIUM_BULLET_AMOUNT;
    public static final ForgeConfigSpec.DoubleValue GERMONIUM_BULLET_DAMAGE;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_BULLET_NEGATIVE_EFFECTS_CHANCE;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_BULLET_NEGATIVE_EFFECTS_CHANCE;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_BULLET_EXPLOSION_CHANCE;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_BULLET_EXPLOSION_CHANCE;
    public static final ForgeConfigSpec.DoubleValue INFERNIUM_BULLET_EXPLOSION_RADIUS;
    public static final ForgeConfigSpec.DoubleValue CELESTIUM_BULLET_EXPLOSION_RADIUS;
    public static final ForgeConfigSpec.IntValue SHULKER_MIN_COOLDOWN;
    public static final ForgeConfigSpec.IntValue SHULKER_MAX_COOLDOWN;
    public static final ForgeConfigSpec.BooleanValue INFERNIUM_BULLET_DESTROYS_BLOCKS;
    public static final ForgeConfigSpec.BooleanValue CELESTIUM_BULLET_DESTROYS_BLOCKS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> INFERNIUM_BULLET_EFFECTS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> CELESTIUM_BULLET_EFFECTS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> CELESTIUM_DEATH_ROLL_ENTITIES;
    public static final ForgeConfigSpec.EnumValue<DropType> INFERNIUM_DROP_TYPE;
    public static final ForgeConfigSpec.EnumValue<DropType> CELESTIUM_DROP_TYPE;
    public static final ForgeConfigSpec.BooleanValue CHEST_LOOT_ENABLED;
    public static final ForgeConfigSpec.DoubleValue CHEST_LOOT_CHANCE;
    public static final ForgeConfigSpec.IntValue CHEST_LOOT_MIN;
    public static final ForgeConfigSpec.IntValue CHEST_LOOT_MAX;
    public static final ForgeConfigSpec.IntValue CHEST_LOOT_ITEM_WEIGHT;
    public static final ForgeConfigSpec.EnumValue<ChestLootItem> CHEST_LOOT_ITEM;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> CHEST_LOOT_TABLES;
    static final ForgeConfigSpec SPEC;

    static {
        BUILDER.push("Germonium Misc Settings");
        INFERNIUM_ALT_TEXTURE = BUILDER.comment("If true Germonium Infernium variants will have a Purple Fire instead of a Red one (Reference to Scaling Health by SilentChaos512). This requires a Restart.").define("infernium_alt_texture", false);
        INFERNIUM_ALT_TEXTURE2 = BUILDER.comment("If true Germonium Infernium variants will have a Cyan Fire instead of a Red one. This requires a Restart.").define("infernium_alt_texture2", false);
        INFERNIUM_ALT_TEXTURE3 = BUILDER.comment("If true Germonium Infernium variants will have a Rainbow Fire instead of a Red one. This requires a Restart.").define("infernium_alt_texture3", false);
        CELESTIUM_ALT_TEXTURE = BUILDER.comment("If true Germonium Celestium variants will have a Cyan Fire instead of a Rainbow one (Reference to the v1.0.0 textures of ZG Mobs). This requires a Restart.").define("celestium_alt_texture", false);
        CELESTIUM_ALT_TEXTURE2 = BUILDER.comment("If true Germonium Celestium variants will have a Red Fire instead of a Rainbow one. This requires a Restart.").define("celestium_alt_texture2", false);
        CELESTIUM_ALT_TEXTURE3 = BUILDER.comment("If true Germonium Celestium variants will have a Purple Fire instead of a Rainbow one. This requires a Restart.").define("celestium_alt_texture3", false);
        BUILDER.pop();
        BUILDER.push("Heart Crystal Settings");
        LSO_COMPAT = BUILDER.comment("If true most Heart Crystal items will be replaced with their LSO counterparts.").define("lso_compat", false);
        LOOSE_EXTRA_HEALTH_ON_DEATH = BUILDER.comment("If true Extra Health provided by the Heart Crystals will be lost on Death.").define("loose_extra_health_on_death", false);
        EXTRA_HEALTH_LOST_PER_DEATH = BUILDER.comment("The amount of Extra Health provided by the Heart Crystals lost on Death.").defineInRange("extra_health_lost_per_death", 2.0, 1.0, Double.MAX_VALUE);
        MAX_EXTRA_HEALTH = BUILDER.comment("The amount of Maximum Extra Health provided by the Heart Crystals.").defineInRange("max_extra_health", 20.0, 1.0, Double.MAX_VALUE);
        EXTRA_HEALTH_PER_HEART = BUILDER.comment("The amount of Extra Health provided by one Heart Crystal. If value is 0 the Heart Crystal will not add any Extra Health.").defineInRange("extra_health_per_heart", 2.0, 0.0, Double.MAX_VALUE);
        ALLOW_HEART_CRYSTAL_REGEN = BUILDER.comment("If true Heart Crystals will add the Regeneration Effect to the Consumer.").define("allow_heart_regen", true);
        HEART_CRYSTAL_REGEN_DURATION = BUILDER.comment("The duration (in ticks) of the Regeneration Effect provided by the Heart Crystals.").defineInRange("heart_regen_duration", 100, 0, Integer.MAX_VALUE);
        HEART_CRYSTAL_REGEN_AMPLIFIER = BUILDER.comment("The amplifier of the Regeneration Effect provided by the Heart Crystals. Note that amplifier with a value of 0 means level 1, value 1 means level 2 and so on.").defineInRange("heart_regen_amplifier", 1, 0, Integer.MAX_VALUE);
        MIN_LEVEL_REQUIRED = BUILDER.comment("The Minimum XP Level required to use The Heart Crystal item. If value is 0 there will be no XP requirements.").defineInRange("min_level_required", 10, 0, Integer.MAX_VALUE);
        XP_LEVELS_CONSUMED = BUILDER.comment("The amount of XP Levels that will be consumed when using The Heart Crystal item. If value is 0 no XP Levels will be consumed.").defineInRange("xp_levels_consumed", 5, 0, Integer.MAX_VALUE);
        HEART_CRYSTAL_USE_DURATION = BUILDER.comment("The Use Duration (in ticks) of The Heart Crystal item.").defineInRange("heart_use_duration", 30, 1, Integer.MAX_VALUE);
        BUILDER.push("Heart Crystal Drop Settings");
        INFERNIUM_DROP_RATE = BUILDER.comment("The Drop Rate for Germonium Infernium variants. If value is 0 Germonium Infernium will drop no Heart Crystal X items.").defineInRange("infernium_drop_rate", 50.0, 0.0, 100.0);
        INFERNIUM_DROP_MIN = BUILDER.comment("The Minimum amount of Heart Crystal X item drops for Germonium Infernium variants.").defineInRange("infernium_drop_min", 2, 0, Integer.MAX_VALUE);
        INFERNIUM_DROP_MAX = BUILDER.comment("The Maximum amount of Heart Crystal X item drops for Germonium Infernium variants.").defineInRange("infernium_drop_max", 6, 0, Integer.MAX_VALUE);
        INFERNIUM_DROP_TYPE = BUILDER.comment("Which type of heart item Infernium mobs can drop. Options: HEART, SHARD, DUST").defineEnum("infernium_drop_type", (Enum)DropType.SHARD);
        CELESTIUM_DROP_RATE = BUILDER.comment("The Drop Rate for Germonium Infernium variants. If value is 0 Germonium Infernium will drop no Heart Crystal X items.").defineInRange("celestium_drop_rate", 100.0, 0.0, 100.0);
        CELESTIUM_DROP_MIN = BUILDER.comment("The Minimum amount of Heart Crystal X item drops for Germonium Infernium variants.").defineInRange("celestium_drop_min", 1, 0, Integer.MAX_VALUE);
        CELESTIUM_DROP_MAX = BUILDER.comment("The Maximum amount of Heart Crystal X item drops for Germonium Infernium variants.").defineInRange("celestium_drop_max", 3, 0, Integer.MAX_VALUE);
        CELESTIUM_DROP_TYPE = BUILDER.comment("Which type of heart item Celestium mobs can drop. Options: HEART, SHARD, DUST").defineEnum("celestium_drop_type", (Enum)DropType.HEART);
        BUILDER.pop();
        BUILDER.push("Heart Crystal Items Loot Settings");
        CHEST_LOOT_ENABLED = BUILDER.comment("Enable or disable Heart Crystal X items loot in chests (abandoned mineshaft, dungeon, desert pyramid, etc).").define("chestLootEnabled", true);
        CHEST_LOOT_CHANCE = BUILDER.comment("Chance that Heart Crystal X items loot appears in a target chest (0.0 - 100.0).").defineInRange("chestLootChance", 25.0, 0.0, 100.0);
        CHEST_LOOT_ITEM_WEIGHT = BUILDER.comment("The number of weight Heart Crystal X items should have in loot. Higher means it will be really common loot, lower means a more rarer loot depending on the loot table.").defineInRange("heartItemWeight", 3, 1, 100);
        CHEST_LOOT_MIN = BUILDER.comment("Minimum number of Heart Crystal X items to add to loot.").defineInRange("minHeartItems", 0, 0, 64);
        CHEST_LOOT_MAX = BUILDER.comment("Maximum number of Heart Crystal X items to inject.").defineInRange("maxHeartItems", 4, 1, 64);
        CHEST_LOOT_ITEM = BUILDER.comment("Which Heart Crystal X items to inject into chests: DUST, SHARD, or HEART.").defineEnum("heartItem", (Enum)ChestLootItem.DUST);
        CHEST_LOOT_TABLES = BUILDER.comment("    List of chest loot tables that should receive injected loot.\n    Format: \"namespace:path\"\n    Examples:\n      \"minecraft:chests/abandoned_mineshaft\"\n      \"minecraft:chests/simple_dungeon\"\n      \"minecraft:chests/desert_pyramid\"\n").defineListAllowEmpty(List.of("tables"), () -> List.of("minecraft:chests/abandoned_mineshaft", "minecraft:chests/simple_dungeon", "minecraft:chests/desert_pyramid"), o -> {
            String s;
            return o instanceof String && (s = (String)o).contains(":");
        });
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("Germonium Spawning");
        DISABLE_GERMONIUM = BUILDER.comment("If true no Germonium variants will spawn.").define("disableGermonium", false);
        ALLOW_GERMONIUM_FROM_SPAWNERS = BUILDER.comment("If true it will allow Germonium variants to spawn from Monster Spawners. If false no Germonium variants will spawn from Monster Spawners.").define("allowGermoniumFromSpawners", false);
        GERMONIUM_BASE_CHANCE = BUILDER.comment("It determines the general chance for a hostile mob to become a Germonium Variant. If % is 1.0 then thats 1%").defineInRange("germoniumBaseChance", 1.0, 0.0, 100.0);
        CELESTIUM_VARIANT = BUILDER.comment("It determines the chance for Germonium Celestiums to spawn. If for example the % is 50 now there is a 50% chance for both Variants. If % is 0, Germonium Celestiums will not spawn.").defineInRange("germoniumEqualizer", 1.0, 0.0, 100.0);
        ENTITY_BLACKLIST = BUILDER.comment(new String[]{"Blacklist of entities or tags that cannot become Germonium variants.", "Use entries like:", " - 'minecraft:wither' for a specific entity", " - '#forge:bosses' for a tag", " - you can also use regex for example: '/^minecraft:(zombie|creeper|enderman|skeleton|spider)$/' or '/^minecraft:[a-z0-9_]+$/'"}).defineListAllowEmpty(List.of("entityBlacklist"), () -> List.of("minecraft:ender_dragon", "minecraft:wither"), obj -> obj instanceof String);
        BUILDER.pop();
        BUILDER.push("Germonium Mobs Settings");
        GERMONIUM_SLIME_SIZE_MIN = BUILDER.comment("It determines the Minimum added Size for Germonium Slimes.").defineInRange("germoniumSlimeSizeMin", 5.0, 0.0, 50.0);
        GERMONIUM_SLIME_SIZE_MAX = BUILDER.comment("It determines the Maximum added Size for Germonium Slimes.").defineInRange("germoniumSlimeSizeMax", 10.0, 0.0, 50.0);
        GERMONIUM_MAGMA_SIZE_MIN = BUILDER.comment("It determines the Minimum added Size for Germonium Magma Cubes.").defineInRange("germoniumMagmaSizeMin", 5.0, 0.0, 50.0);
        GERMONIUM_MAGMA_SIZE_MAX = BUILDER.comment("It determines the Maximum added Size for Germonium Magma Cubes.").defineInRange("germoniumMagmaSizeMax", 10.0, 0.0, 50.0);
        GERMONIUM_PHANTOM_SIZE_MIN = BUILDER.comment("It determines the Minimum added Size for Germonium Phantoms.").defineInRange("germoniumPhantomSizeMin", 3.0, 0.0, 50.0);
        GERMONIUM_PHANTOM_SIZE_MAX = BUILDER.comment("It determines the Maximum added Size for Germonium Phantoms").defineInRange("germoniumPhantomSizeMax", 6.0, 0.0, 50.0);
        GERMONIUM_GHAST_EXPLOSION_POWER_MIN = BUILDER.comment("It determines the Minimum added Explosion Power for Germonium Ghasts. Vanilla Ghasts have a base Explosion Power of 1").defineInRange("germoniumGhastExplosionPowerMin", 3.0, 0.0, 50.0);
        GERMONIUM_GHAST_EXPLOSION_POWER_MAX = BUILDER.comment("It determines the Maximum added Explosion Power for Germonium Ghasts. Vanilla Ghasts have a base Explosion Power of 1").defineInRange("germoniumGhastExplosionPowerMax", 5.0, 0.0, 50.0);
        GERMONIUM_CHARGED_CREEPER_CHANCE = BUILDER.comment("It determines the % for Germonium Creepers to spawn charged. If value is 0 no Charged Creepers will spawn.").defineInRange("germoniumCreeperChargedChance", 25.0, 0.0, 100.0);
        GERMONIUM_CREEPER_EXPLOSION_POWER_MIN = BUILDER.comment("It determines the Minimum added Explosion Power for Germonium Creepers. If value is 0 the minimum extra explosion power is gonna be 0. Vanilla Creepers have a base Explosion Power of 3, If they are charged their base gets multiplied by 2.").defineInRange("germoniumCreeperExplosionPowerMin", 1.0, 0.0, 50.0);
        GERMONIUM_CREEPER_EXPLOSION_POWER_MAX = BUILDER.comment("It determines the Maximum added Explosion Power for Germonium Creepers. If value is 0 the maximum extra explosion power is gonna be 0. Vanilla Creepers have a base Explosion Power of 3, If they are charged their base gets multiplied by 2.").defineInRange("germoniumCreeperExplosionPowerMax", 4.0, 0.0, 50.0);
        BUILDER.pop();
        BUILDER.push("Germonium Attributes");
        INFERNIUM_ADDITIONAL_HEALTH = BUILDER.comment("The amount of Health added to Germonium Inferniums. If value is 0 it will not add any Health.").defineInRange("infernium_add_health", 50.0, 0.0, Double.MAX_VALUE);
        CELESTIUM_ADDITIONAL_HEALTH = BUILDER.comment("The amount of Health added to Germonium Celestiums. If value is 0 it will not add any Health.").defineInRange("celestium_add_health", 100.0, 0.0, Double.MAX_VALUE);
        INFERNIUM_ADDITIONAL_DAMAGE = BUILDER.comment("The amount of Damage added to Germonium Inferniums. If value is 0 it will not add any Damage.").defineInRange("infernium_add_damage", 10.0, 0.0, Double.MAX_VALUE);
        CELESTIUM_ADDITIONAL_DAMAGE = BUILDER.comment("The amount of Damage added to Germonium Celestiums. If value is 0 it will not add any Damage.").defineInRange("celestium_add_damage", 20.0, 0.0, Double.MAX_VALUE);
        INFERNIUM_ADDITIONAL_ARMOR = BUILDER.comment("The amount of Armor added to Germonium Inferniums. If value is 0 it will not add any Armor.").defineInRange("infernium_add_armor", 20.0, 0.0, Double.MAX_VALUE);
        CELESTIUM_ADDITIONAL_ARMOR = BUILDER.comment("The amount of Armor added to Germonium Celestiums. If value is 0 it will not add any Armor.").defineInRange("celestium_add_armor", 40.0, 0.0, Double.MAX_VALUE);
        INFERNIUM_ADDITIONAL_AT = BUILDER.comment("The amount of Armor Toughness added to Germonium Inferniums. If value is 0 it will not add any Armor Toughness.").defineInRange("infernium_add_armort", 20.0, 0.0, Double.MAX_VALUE);
        CELESTIUM_ADDITIONAL_AT = BUILDER.comment("The amount of Armor Toughness added to Germonium Celestiums. If value is 0 it will not add any Armor Toughness.").defineInRange("celestium_add_armort", 40.0, 0.0, Double.MAX_VALUE);
        INFERNIUM_ADDITIONAL_SPEED = BUILDER.comment("The % of Speed added to Germonium Inferniums. If value is 0 it will not add Speed. If for example % is 0.5, that is +50% more Speed.").defineInRange("infernium_mult_speed", 0.5, 0.0, Double.MAX_VALUE);
        CELESTIUM_ADDITIONAL_SPEED = BUILDER.comment("The % of Speed added to Germonium Celestiums. If value is 0 it will not add Speed. If for example % is 1.0, that is +100% more Speed.").defineInRange("celestium_mult_speed", 1.0, 0.0, Double.MAX_VALUE);
        INFERNIUM_ADDITIONAL_KB = BUILDER.comment("The % of Knockback Resistance added to Germonium Inferniums. If value is 0 it will not add Knockback Resistance. If for example % is 0.5, that is +50% Knockback Resistance.").defineInRange("infernium_add_kb", 0.5, 0.0, 1.0);
        CELESTIUM_ADDITIONAL_KB = BUILDER.comment("The % of Knockback Resistance added to Germonium Celestiums. If value is 0 it will not add Knockback Resistance. If for example % is 1.0, that is +100% Knockback Resistance.").defineInRange("celestium_add_kb", 1.0, 0.0, 1.0);
        BUILDER.pop();
        BUILDER.push("Germonium Abilities");
        BUILDER.push("Germonium Immunities");
        GERMONIUM_IMMUNE_TO_SUFFOCATION = BUILDER.comment("If true Germonium variants will have Damage Immunity against suffocation (in blocks).").define("germonium_immune_to_suffocation", true);
        GERMONIUM_IMMUNE_TO_DROWNING = BUILDER.comment("If true Germonium variants will have Damage Immunity against drowning (underwater).").define("germonium_immune_to_drowning", true);
        INFERNIUM_IMMUNE_TO_INFERNIUM_BULLETS = BUILDER.comment("If true Germonium Infernium variants will receive no damage from shulker bullets from other Germonium Infernium variants. If false it can lead to infighting between Germoniums.").define("infernium_immune_to_infernium_bullets", true);
        INFERNIUM_IMMUNE_TO_CELESTIUM_BULLETS = BUILDER.comment("If true Germonium Infernium variants will receive no damage from shulker bullets from other Germonium Celestium variants. If false it can lead to infighting between Germoniums.").define("infernium_immune_to_celestium_bullets", true);
        CELESTIUM_IMMUNE_TO_CELESTIUM_BULLETS = BUILDER.comment("If true Germonium Celestium variants will receive no damage from shulker bullets from other Germonium Celestium variants. If false it can lead to infighting between Germoniums.").define("celestium_immune_to_celestium_bullets", true);
        CELESTIUM_IMMUNE_TO_INFERNIUM_BULLETS = BUILDER.comment("If true Germonium Celestium variants will receive no damage from shulker bullets from other Germonium Infernium variants. If false it can lead to infighting between Germoniums.").define("celestium_immune_to_infernium_bullets", true);
        BUILDER.pop();
        BUILDER.push("Celestium Death Roll");
        CELESTIUM_DEATH_ROLL_MIN = BUILDER.comment("The minimum amount of Germonium Infernium mobs that will be spawned when a Germonium Celestium dies.").defineInRange("celestium_death_roll_min", 1, 0, Integer.MAX_VALUE);
        CELESTIUM_DEATH_ROLL_MAX = BUILDER.comment("The maximum amount of Germonium Infernium mobs that will be spawned when a Germonium Celestium dies.").defineInRange("celestium_death_roll_max", 3, 0, Integer.MAX_VALUE);
        CELESTIUM_DEATH_ROLL_ENTITIES = BUILDER.comment("List of entities that can spawn when a Celestium dies. Namespaced IDs like 'minecraft:zombie'. Blacklisted entities will be skipped.").defineList("entityArray", List.of("minecraft:zombie", "minecraft:skeleton", "minecraft:husk", "minecraft:stray", "minecraft:vindicator", "minecraft:ravager", "minecraft:evoker", "minecraft:pillager", "minecraft:witch", "minecraft:enderman", "minecraft:phantom", "minecraft:slime", "minecraft:magma_cube", "minecraft:vex", "minecraft:wither_skeleton", "minecraft:blaze", "minecraft:zombie_villager", "minecraft:guardian", "minecraft:silverfish", "minecraft:illusioner"), o -> o instanceof String);
        BUILDER.pop();
        BUILDER.push("Germonium XP Multiplier");
        INFERNIUM_XP_MULTIPLIER = BUILDER.comment("The multiplier for Germonium Inferniums XP. If value is 1 it will not mutiply any XP dropped.").defineInRange("infernium_xp_multiplier", 40.0, 1.0, Double.MAX_VALUE);
        CELESTIUM_XP_MULTIPLIER = BUILDER.comment("The multiplier for Germonium Celestiums XP. If value is 1 it will not mutiply any XP dropped.").defineInRange("celestium_xp_multiplier", 80.0, 1.0, Double.MAX_VALUE);
        BUILDER.pop();
        BUILDER.push("Germonium Reflect Damage");
        INFERNIUM_REFLECT_CHANCE = BUILDER.comment("The % for Germonium Inferniums to reflect damage back. If % is 0 it will never reflect any damage back.").defineInRange("infernium_reflect_chance", 30.0, 0.0, 100.0);
        CELESTIUM_REFLECT_CHANCE = BUILDER.comment("The % for Germonium Celestiums to reflect damage back. If % is 0 it will never reflect any damage back.").defineInRange("celestium_reflect_chance", 50.0, 0.0, 100.0);
        INFERNIUM_REFLECT_DAMAGE = BUILDER.comment("The % of damage reflected by Germonium Inferniums. If % is 30 it will only reflect 30% of the damage back.").defineInRange("infernium_reflect_damage", 30.0, 1.0, Double.MAX_VALUE);
        CELESTIUM_REFLECT_DAMAGE = BUILDER.comment("The % of damage reflected by Germonium Celestiums. If % is 50 it will only reflect 50% of the damage back.").defineInRange("celestium_reflect_damage", 50.0, 1.0, Double.MAX_VALUE);
        INFERNIUM_REFLECT_DAMAGE_CAP = BUILDER.comment("The cap of damage a Germonium Infernium can reflect. For example if the value is 25, only a max of 25 damage can be reflected.").defineInRange("infernium_reflect_damage_cap", 25.0, 1.0, Double.MAX_VALUE);
        CELESTIUM_REFLECT_DAMAGE_CAP = BUILDER.comment("The cap of damage a Germonium Celestium can reflect. For example if the value is 50, only a max of 50 damage can be reflected.").defineInRange("celestium_reflect_damage_cap", 50.0, 1.0, Double.MAX_VALUE);
        BUILDER.pop();
        BUILDER.push("Shulker Bullets");
        ENABLE_SHULKER_BULLETS = BUILDER.comment("Wether the Germonium variants should or should not shoot shulker bullets").define("enable_shulker_bullets", true);
        INFERNIUM_BULLET_AMOUNT = BUILDER.comment("The amount of shulker bullets a Germonium Infernium can shoot at the same time. If 0 no bullets are gonna be shot.").defineInRange("infernium_bullets", 1, 0, Integer.MAX_VALUE);
        CELESTIUM_BULLET_AMOUNT = BUILDER.comment("The amount of shulker bullets a Germonium Celestium can shoot at the same time. If 0 no bullets are gonna be shot.").defineInRange("celestium_bullets", 3, 0, Integer.MAX_VALUE);
        SHULKER_MIN_COOLDOWN = BUILDER.comment("Minimum shulker bullet ability cooldown time (in ticks).").defineInRange("shulker_min_cooldown", 200, 0, Integer.MAX_VALUE);
        SHULKER_MAX_COOLDOWN = BUILDER.comment("Maximum shulker bullet ability cooldown time (in ticks).").defineInRange("shulker_max_cooldown", 400, 0, Integer.MAX_VALUE);
        GERMONIUM_BULLET_DAMAGE = BUILDER.comment("The Damage of the shulker bullet shot from Germonium variants. If Damage is 0, the bullet will not deal any damage.").defineInRange("germonium_bullet_damage", 12.0, 0.0, Double.MAX_VALUE);
        INFERNIUM_BULLET_DESTROYS_BLOCKS = BUILDER.comment("If the shulker bullets from Germonium Inferniums should destroy blocks.").define("infernium_shulker_bullets_destroy", false);
        CELESTIUM_BULLET_DESTROYS_BLOCKS = BUILDER.comment("If the shulker bullets from Germonium Celestiums should destroy blocks.").define("celestium_shulker_bullets_destroy", true);
        INFERNIUM_BULLET_NEGATIVE_EFFECTS_CHANCE = BUILDER.comment("The % for a shulker bullet from a Germonium Infernium to apply a negative effect (Wither, Instant Damage, etc).").defineInRange("infernium_bullet_effect_chance", 25.0, 0.0, 100.0);
        CELESTIUM_BULLET_NEGATIVE_EFFECTS_CHANCE = BUILDER.comment("The % for a shulker bullet from a Germonium Celestium to apply a negative effect (Wither, Instant Damage, etc).").defineInRange("celestium_bullet_effect_chance", 50.0, 0.0, 100.0);
        INFERNIUM_BULLET_EFFECTS = BUILDER.comment("List of effects applied by Infernium bullets in format effect:duration:amplifier").defineList("inferniumEffects", List.of("wither:200:2", "instant_damage:1:2", "slowness:200:3", "weakness:200:1", "mining_fatigue:200:3"), o -> o instanceof String);
        CELESTIUM_BULLET_EFFECTS = BUILDER.comment("List of effects applied by Celestium bullets in format effect:duration:amplifier").defineList("celestiumEffects", List.of("wither:300:4", "instant_damage:1:3", "slowness:300:4", "weakness:300:3", "mining_fatigue:300:4"), o -> o instanceof String);
        INFERNIUM_BULLET_EXPLOSION_CHANCE = BUILDER.comment("The % for a shulker bullet from a Germonium Infernium to explode on impact.").defineInRange("infernium_bullet_explosion_chance", 25.0, 0.0, 100.0);
        CELESTIUM_BULLET_EXPLOSION_CHANCE = BUILDER.comment("The % for a shulker bullet from a Germonium Celestium to explode on impact.").defineInRange("celestium_bullet_explosion_chance", 50.0, 0.0, 100.0);
        INFERNIUM_BULLET_EXPLOSION_RADIUS = BUILDER.comment("The value of the explosion from a Germonium Infernium shulker bullet.").defineInRange("infernium_bullet_explosion_radius", 4.0, 0.0, Double.MAX_VALUE);
        CELESTIUM_BULLET_EXPLOSION_RADIUS = BUILDER.comment("The value of the explosion from a Germonium Infernium shulker bullet.").defineInRange("celestium_bullet_explosion_radius", 6.0, 0.0, Double.MAX_VALUE);
        BUILDER.pop();
        BUILDER.pop();
        SPEC = BUILDER.build();
    }

    public static enum DropType {
        HEART,
        SHARD,
        DUST;

    }

    public static enum ChestLootItem {
        DUST,
        SHARD,
        HEART;

    }
}

