/*
 * Decompiled with CFR 0.152.
 */
package zeta.org.zgmobs.mixin;

import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import zeta.org.zgmobs.germonium.GermoniumUtils;
import zeta.org.zgmobs.main.Config;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Shadow
    @Nullable
    protected Player f_20888_;

    @ModifyVariable(method={"dropExperience"}, at=@At(value="STORE"))
    private int dropExperience(int value) {
        double d;
        double d2 = value;
        if (this instanceof Enemy) {
            switch (GermoniumUtils.getVariant(this)) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case NORMAL: {
                    d = 1.0;
                    break;
                }
                case INFERNIUM: {
                    d = (Double)Config.INFERNIUM_XP_MULTIPLIER.get();
                    break;
                }
                case CELESTIUM: {
                    d = (Double)Config.CELESTIUM_XP_MULTIPLIER.get();
                    break;
                }
            }
        } else {
            d = 1.0;
        }
        return (int)(d2 * d);
    }

    @Inject(method={"dropFromLootTable"}, at={@At(value="TAIL")})
    private void dropFromLootTable(DamageSource damageSource, boolean bl, CallbackInfo ci) {
        if (!(this instanceof Enemy)) {
            return;
        }
        LivingEntity that = (LivingEntity)this;
        ResourceLocation resourcelocation = ResourceLocation.fromNamespaceAndPath((String)"zgmobs", (String)("entities/" + GermoniumUtils.getVariant(this).m_7912_()));
        LootTable loottable = that.m_9236_().m_7654_().m_278653_().m_278676_(resourcelocation);
        LootParams.Builder lootparams$builder = new LootParams.Builder((ServerLevel)that.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)that).m_287286_(LootContextParams.f_81460_, (Object)that.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)damageSource).m_287289_(LootContextParams.f_81458_, (Object)damageSource.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)damageSource.m_7640_());
        if (bl && this.f_20888_ != null) {
            lootparams$builder = lootparams$builder.m_287286_(LootContextParams.f_81456_, (Object)this.f_20888_).m_287239_(this.f_20888_.m_36336_());
        }
        LootParams lootparams = lootparams$builder.m_287235_(LootContextParamSets.f_81415_);
        loottable.m_287276_(lootparams, that.m_287233_(), arg_0 -> ((LivingEntity)that).m_19983_(arg_0));
    }
}

