/*
 * Decompiled with CFR 0.152.
 */
package zeta.org.zgmobs.mixin;

import java.awt.Color;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import zeta.org.zgmobs.germonium.Germonium;
import zeta.org.zgmobs.germonium.GermoniumUtils;
import zeta.org.zgmobs.germonium.ShulkerExplosiveBullet;
import zeta.org.zgmobs.main.Config;
import zeta.org.zgmobs.main.ZGMobs;

@Mixin(value={Mob.class})
public class MobMixin {
    @Unique
    private int zGMobs$attackTime = 0;
    @Unique
    private Germonium zgmobs$variant = Germonium.NORMAL;

    @Inject(method={"<clinit>"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/syncher/SynchedEntityData;defineId(Ljava/lang/Class;Lnet/minecraft/network/syncher/EntityDataSerializer;)Lnet/minecraft/network/syncher/EntityDataAccessor;")})
    private static void clinit(CallbackInfo ci) {
        ZGMobs.DATA_GERMONIUM = SynchedEntityData.m_135353_(Mob.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void defineSynchedData(CallbackInfo ci) {
        if (this instanceof Enemy) {
            ((Mob)this).m_20088_().m_135372_(ZGMobs.DATA_GERMONIUM, (Object)0);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        if (this instanceof Enemy) {
            nbt.m_128359_("Germonium", GermoniumUtils.getVariant(this).m_7912_());
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        if (this instanceof Enemy) {
            GermoniumUtils.setVariant(this, Germonium.byName(nbt.m_128461_("Germonium")));
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    private void aiStep(CallbackInfo ci) {
        int i;
        Mob that = (Mob)this;
        if (!(that instanceof Enemy)) {
            return;
        }
        if (GermoniumUtils.getVariant((Entity)that) == Germonium.NORMAL) {
            return;
        }
        if (that.m_9236_().m_5776_()) {
            double width = that.m_20205_();
            double height = that.m_20206_();
            double halfWidth = width / 2.0;
            for (i = 0; i < 3; ++i) {
                double angle = Math.random() * Math.PI * 2.0;
                double radius = halfWidth * (0.9 + Math.random() * 0.3);
                double px = that.m_20185_() + Math.cos(angle) * radius;
                double pz = that.m_20189_() + Math.sin(angle) * radius;
                double py = that.m_20186_() + Math.random() * height;
                float hue = (float)Math.random();
                float saturation = 0.7f;
                float brightness = 1.0f;
                int rgb = Color.HSBtoRGB(hue, saturation, brightness);
                double r = (double)(rgb >> 16 & 0xFF) / 255.0;
                double g = (double)(rgb >> 8 & 0xFF) / 255.0;
                double b = (double)(rgb & 0xFF) / 255.0;
                that.m_9236_().m_7107_((ParticleOptions)ParticleTypes.f_123811_, px, py, pz, r, g, b);
            }
        }
        if (that.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            return;
        }
        --this.zGMobs$attackTime;
        LivingEntity livingentity = that.m_5448_();
        if (livingentity != null && ((Boolean)Config.ENABLE_SHULKER_BULLETS.get()).booleanValue()) {
            that.m_21563_().m_24960_((Entity)livingentity, 180.0f, 180.0f);
            double d0 = that.m_20280_((Entity)livingentity);
            if (d0 < 400.0) {
                if (this.zGMobs$attackTime <= 0) {
                    int min = (Integer)Config.SHULKER_MIN_COOLDOWN.get();
                    this.zGMobs$attackTime = min + that.m_217043_().m_188503_((Integer)Config.SHULKER_MAX_COOLDOWN.get() - min);
                    Germonium variant = GermoniumUtils.getVariant((Entity)that);
                    if (variant == null || variant == Germonium.NORMAL) {
                        return;
                    }
                    int bulletCount = 0;
                    if (variant == Germonium.INFERNIUM) {
                        bulletCount = (Integer)Config.INFERNIUM_BULLET_AMOUNT.get();
                    } else if (variant == Germonium.CELESTIUM) {
                        bulletCount = (Integer)Config.CELESTIUM_BULLET_AMOUNT.get();
                    }
                    for (i = 0; i < bulletCount; ++i) {
                        that.m_9236_().m_7967_((Entity)new ShulkerExplosiveBullet(that.m_9236_(), (LivingEntity)that, (Entity)livingentity, Direction.Axis.Y));
                    }
                    that.m_5496_(SoundEvents.f_12417_, 2.0f, (that.m_217043_().m_188501_() - that.m_217043_().m_188501_()) * 0.2f + 1.0f);
                }
            } else {
                that.m_6710_(null);
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        Mob that = (Mob)this;
        if (!(that instanceof Enemy)) {
            return;
        }
        if (that.m_9236_().m_5776_()) {
            return;
        }
        Germonium variant = GermoniumUtils.getVariant((Entity)that);
        if (variant != this.zgmobs$variant) {
            this.zgmobs$variant = variant;
            variant.setAttributes(that.m_21204_());
        }
    }
}

