/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.PlaceholderHook;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.expansion.Relational;
import me.clip.placeholderapi.replacer.CharsReplacer;
import me.clip.placeholderapi.replacer.Replacer;
import me.clip.placeholderapi.util.Msg;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class PlaceholderAPI {
    private static final Replacer REPLACER_PERCENT = new CharsReplacer(Replacer.Closure.PERCENT);
    private static final Replacer REPLACER_BRACKET = new CharsReplacer(Replacer.Closure.BRACKET);
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("[%]([^%]+)[%]");
    private static final Pattern BRACKET_PLACEHOLDER_PATTERN = Pattern.compile("[{]([^{}]+)[}]");
    private static final Pattern RELATIONAL_PLACEHOLDER_PATTERN = Pattern.compile("[%](rel_)([^%]+)[%]");

    private PlaceholderAPI() {
    }

    @NotNull
    public static String setPlaceholders(OfflinePlayer player, @NotNull String text) {
        return REPLACER_PERCENT.apply(text, player, PlaceholderAPIPlugin.getInstance().getLocalExpansionManager()::getExpansion);
    }

    @NotNull
    public static List<String> setPlaceholders(OfflinePlayer player, @NotNull List<String> text) {
        return text.stream().map(line -> PlaceholderAPI.setPlaceholders(player, line)).collect(Collectors.toList());
    }

    @NotNull
    public static String setPlaceholders(Player player, @NotNull String text) {
        return PlaceholderAPI.setPlaceholders((OfflinePlayer)player, text);
    }

    @NotNull
    public static List<String> setPlaceholders(Player player, @NotNull @NotNull List<@NotNull String> text) {
        return PlaceholderAPI.setPlaceholders((OfflinePlayer)player, text);
    }

    @NotNull
    public static String setBracketPlaceholders(OfflinePlayer player, @NotNull String text) {
        return REPLACER_BRACKET.apply(text, player, PlaceholderAPIPlugin.getInstance().getLocalExpansionManager()::getExpansion);
    }

    @NotNull
    public static @NotNull List<@NotNull String> setBracketPlaceholders(OfflinePlayer player, @NotNull @NotNull List<@NotNull String> text) {
        return text.stream().map(line -> PlaceholderAPI.setBracketPlaceholders(player, line)).collect(Collectors.toList());
    }

    @NotNull
    public static String setBracketPlaceholders(Player player, @NotNull String text) {
        return PlaceholderAPI.setBracketPlaceholders((OfflinePlayer)player, text);
    }

    @NotNull
    public static List<String> setBracketPlaceholders(Player player, @NotNull List<String> text) {
        return PlaceholderAPI.setBracketPlaceholders((OfflinePlayer)player, text);
    }

    public static String setRelationalPlaceholders(Player one, Player two, String text) {
        Matcher matcher = RELATIONAL_PLACEHOLDER_PATTERN.matcher(text);
        while (matcher.find()) {
            String value;
            String format = matcher.group(2);
            int index = format.indexOf("_");
            if (index <= 0 || index >= format.length()) continue;
            String identifier = format.substring(0, index).toLowerCase(Locale.ROOT);
            String params = format.substring(index + 1);
            PlaceholderExpansion expansion = PlaceholderAPIPlugin.getInstance().getLocalExpansionManager().getExpansion(identifier);
            if (!(expansion instanceof Relational) || (value = ((Relational)((Object)expansion)).onPlaceholderRequest(one, two, params)) == null) continue;
            text = text.replaceAll(Pattern.quote(matcher.group()), Matcher.quoteReplacement(value));
        }
        return text;
    }

    public static List<String> setRelationalPlaceholders(Player one, Player two, List<String> text) {
        return text.stream().map(line -> PlaceholderAPI.setRelationalPlaceholders(one, two, line)).collect(Collectors.toList());
    }

    public static boolean isRegistered(@NotNull String identifier) {
        return PlaceholderAPIPlugin.getInstance().getLocalExpansionManager().findExpansionByIdentifier(identifier).isPresent();
    }

    @NotNull
    public static Set<String> getRegisteredIdentifiers() {
        return ImmutableSet.copyOf(PlaceholderAPIPlugin.getInstance().getLocalExpansionManager().getIdentifiers());
    }

    public static Pattern getPlaceholderPattern() {
        return PLACEHOLDER_PATTERN;
    }

    public static Pattern getBracketPlaceholderPattern() {
        return BRACKET_PLACEHOLDER_PATTERN;
    }

    public static Pattern getRelationalPlaceholderPattern() {
        return RELATIONAL_PLACEHOLDER_PATTERN;
    }

    public static boolean containsPlaceholders(String text) {
        return text != null && PLACEHOLDER_PATTERN.matcher(text).find();
    }

    public static boolean containsBracketPlaceholders(String text) {
        return text != null && BRACKET_PLACEHOLDER_PATTERN.matcher(text).find();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.13.0")
    public static boolean registerExpansion(PlaceholderExpansion expansion) {
        return expansion.register();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.13.0")
    public static boolean unregisterExpansion(PlaceholderExpansion expansion) {
        return expansion.unregister();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.13.0")
    public static Map<String, PlaceholderHook> getPlaceholders() {
        return PlaceholderAPIPlugin.getInstance().getLocalExpansionManager().getExpansions().stream().collect(Collectors.toMap(PlaceholderExpansion::getIdentifier, ex -> ex));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.13.0")
    public static boolean registerPlaceholderHook(Plugin plugin, PlaceholderHook placeholderHook) {
        Msg.warn("Nag author(s) %s of plugin %s about their usage of the deprecated PlaceholderHook class! This class will be removed in v2.13.0!", plugin.getDescription().getAuthors(), plugin.getName());
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.13.0")
    public static boolean registerPlaceholderHook(String identifier, PlaceholderHook placeholderHook) {
        Msg.warn("%s is attempting to register placeholders via deprecated PlaceholderHook class. This class is no longer supported and will be removed in v2.13.0!", identifier);
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.13.0")
    public static boolean unregisterPlaceholderHook(Plugin plugin) {
        Msg.warn("Nag author(s) %s of plugin %s about their usage of the PlaceholderAPI class. This way of unregistering placeholders is no longer supported and will be removed in v2.13.0!", plugin.getDescription().getAuthors(), plugin.getName());
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.13.0")
    public static boolean unregisterPlaceholderHook(String identifier) {
        Msg.warn("%s is attempting to unregister placeholders via PlaceholderAPI class. This way of unregistering placeholders is no longer supported and will be removed in v2.13.0!", identifier);
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.13.0")
    public static Set<String> getRegisteredPlaceholderPlugins() {
        return PlaceholderAPI.getRegisteredIdentifiers();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.13.0")
    public static Set<String> getExternalPlaceholderPlugins() {
        return null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.13.0")
    public static String setPlaceholders(OfflinePlayer player, String text, Pattern pattern, boolean colorize) {
        return PlaceholderAPI.setPlaceholders(player, text);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.13.0")
    public static List<String> setPlaceholders(OfflinePlayer player, List<String> text, Pattern pattern, boolean colorize) {
        return PlaceholderAPI.setPlaceholders(player, text);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.13.0")
    public static List<String> setPlaceholders(OfflinePlayer player, List<String> text, boolean colorize) {
        return PlaceholderAPI.setPlaceholders(player, text);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.13.0")
    public static List<String> setPlaceholders(OfflinePlayer player, List<String> text, Pattern pattern) {
        return PlaceholderAPI.setPlaceholders(player, text);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.13.0")
    public static String setPlaceholders(Player player, String text, boolean colorize) {
        return PlaceholderAPI.setPlaceholders(player, text);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.13.0")
    public static List<String> setPlaceholders(Player player, List<String> text, boolean colorize) {
        return PlaceholderAPI.setPlaceholders(player, text);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.13.0")
    public static String setPlaceholders(OfflinePlayer player, String text, boolean colorize) {
        return PlaceholderAPI.setPlaceholders(player, text);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.13.0")
    public static String setPlaceholders(OfflinePlayer player, String text, Pattern pattern) {
        return PlaceholderAPI.setPlaceholders(player, text);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.13.0")
    public static List<String> setBracketPlaceholders(OfflinePlayer player, List<String> text, boolean colorize) {
        return PlaceholderAPI.setBracketPlaceholders(player, text);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.13.0")
    public static String setBracketPlaceholders(OfflinePlayer player, String text, boolean colorize) {
        return PlaceholderAPI.setBracketPlaceholders(player, text);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.13.0")
    public static String setBracketPlaceholders(Player player, String text, boolean colorize) {
        return PlaceholderAPI.setBracketPlaceholders(player, text);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.13.0")
    public static List<String> setBracketPlaceholders(Player player, List<String> text, boolean colorize) {
        return PlaceholderAPI.setBracketPlaceholders(player, text);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.13.0")
    public static String setRelationalPlaceholders(Player one, Player two, String text, boolean colorize) {
        return PlaceholderAPI.setRelationalPlaceholders(one, two, text);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.13.0")
    public static List<String> setRelationalPlaceholders(Player one, Player two, List<String> text, boolean colorize) {
        return PlaceholderAPI.setRelationalPlaceholders(one, two, text);
    }
}

