/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablevillagers.blocks.trader;

import com.shiftthedev.pickablevillagers.PVRegistry;
import com.shiftthedev.pickablevillagers.mixins.VillagerEntityAccessor;
import com.shiftthedev.pickablevillagers.network.ClientUpdatePacket;
import com.shiftthedev.pickablevillagers.utils.CachedVillagers;
import com.shiftthedev.pickablevillagers.utils.Helper;
import dev.architectury.hooks.block.BlockEntityHooks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1264;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3852;
import net.minecraft.class_7477;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class TraderBlockEntity
extends class_2586 {
    private static int VERSION = 1;
    private class_1646 cachedVillager = null;
    private class_1799 villagerStack = class_1799.field_8037;
    private class_2248 stationsBlock = class_2246.field_10124;

    public TraderBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)PVRegistry.TRADER_BLOCKENTITY.get(), blockPos, blockState);
    }

    public boolean addVillager(class_1646 villager, class_1799 villagerStack) {
        if (this.field_11863 == null) {
            return false;
        }
        if (this.field_11863.field_9236) {
            return false;
        }
        if (this.villagerStack != class_1799.field_8037) {
            return false;
        }
        if (villager.method_6109()) {
            return false;
        }
        villager.method_5814((double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() + 0.5, (double)this.method_11016().method_10260() + 0.5);
        this.villagerStack = villagerStack;
        this.cachedVillager = villager;
        this.updateVillagerProfession();
        this.markUpdated();
        return true;
    }

    public boolean addStation(class_1799 stationStack) {
        if (this.field_11863 == null) {
            return false;
        }
        if (this.field_11863.field_9236) {
            return false;
        }
        if (this.stationsBlock != class_2246.field_10124) {
            return false;
        }
        if (stationStack.method_7960()) {
            return false;
        }
        class_1792 class_17922 = stationStack.method_7909();
        if (!(class_17922 instanceof class_1747)) {
            return false;
        }
        class_1747 blockItem = (class_1747)class_17922;
        if (this.getProfessionForStation(blockItem.method_7711()).equals((Object)class_3852.field_17051)) {
            return false;
        }
        this.stationsBlock = blockItem.method_7711();
        this.updateVillagerProfession();
        this.markUpdated();
        return true;
    }

    public class_1799 removeVillager() {
        if (this.field_11863 == null) {
            return class_1799.field_8037;
        }
        class_1799 copy = this.villagerStack.method_7972();
        class_2487 tag = copy.method_7911("villager_info");
        tag = this.cachedVillager.method_5647(tag);
        if (!this.field_11863.field_9236) {
            CachedVillagers.updateCache(this.cachedVillager);
        }
        this.cachedVillager = null;
        this.villagerStack = class_1799.field_8037;
        this.markUpdated();
        return copy;
    }

    public class_1799 removeStation() {
        if (this.field_11863 == null) {
            return class_1799.field_8037;
        }
        class_1799 copy = new class_1799((class_1935)this.stationsBlock, 1);
        this.stationsBlock = class_2246.field_10124;
        this.markUpdated();
        return copy;
    }

    public void dropContents(class_1937 level, class_2338 blockPos) {
        if (!this.villagerStack.method_7960()) {
            if (this.cachedVillager != null && this.cachedVillager.method_18009()) {
                ((VillagerEntityAccessor)this.cachedVillager).invokeStopTrading();
            }
            class_1264.method_5449((class_1937)level, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), (class_1799)this.villagerStack);
        }
        if (this.stationsBlock != class_2246.field_10124) {
            class_1264.method_5449((class_1937)level, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), (class_1799)new class_1799((class_1935)this.stationsBlock, 1));
        }
    }

    private void updateVillagerProfession() {
        if (this.cachedVillager == null || this.cachedVillager.method_19269() > 0 || this.cachedVillager.method_7231().method_16924().equals((Object)class_3852.field_17062)) {
            return;
        }
        if (this.stationsBlock == class_2246.field_10124) {
            this.cachedVillager.method_7195(this.cachedVillager.method_7231().method_16921(class_3852.field_17051));
        } else {
            this.cachedVillager.method_7195(this.cachedVillager.method_7231().method_16921(this.getProfessionForStation(this.stationsBlock)));
        }
        this.cachedVillager.method_5647(this.villagerStack.method_7911("villager_info"));
        this.markUpdated();
        if (!this.field_11863.field_9236) {
            this.field_11863.method_18456().forEach(player -> ClientUpdatePacket.sendToPlayer(this.cachedVillager.method_5667(), this.cachedVillager.method_5647(new class_2487()), (class_3222)player));
        }
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, TraderBlockEntity traderBlockEntity) {
        if (traderBlockEntity.cachedVillager == null) {
            return;
        }
        int oldLevel = traderBlockEntity.cachedVillager.method_7231().method_16925();
        Helper.VillagerTick(traderBlockEntity.cachedVillager, level, traderBlockEntity.cachedVillager.method_7231().method_16924().equals((Object)traderBlockEntity.getProfessionForStation(traderBlockEntity.stationsBlock)));
        if (!level.field_9236 && oldLevel != traderBlockEntity.cachedVillager.method_7231().method_16925()) {
            traderBlockEntity.markUpdated();
            level.method_18456().forEach(player -> ClientUpdatePacket.sendToPlayer(traderBlockEntity.cachedVillager.method_5667(), traderBlockEntity.cachedVillager.method_5647(new class_2487()), (class_3222)player));
        }
    }

    private class_3852 getProfessionForStation(class_2248 block) {
        return class_7477.method_43989((class_2680)block.method_9564()).flatMap(poiType -> class_7923.field_41195.method_10220().filter(villagerProfession -> villagerProfession.comp_819().test(poiType)).findFirst()).orElse(class_3852.field_17051);
    }

    public void openMenu(class_1937 level, class_1657 player) {
        if (level.field_9236) {
            return;
        }
        if (this.cachedVillager == null) {
            this.cachedVillager = CachedVillagers.getCached(this.villagerStack, this.field_11863);
            if (this.cachedVillager == null) {
                return;
            }
        }
        if (this.cachedVillager.method_8264().isEmpty()) {
            return;
        }
        if (this.cachedVillager.method_18009()) {
            return;
        }
        ((VillagerEntityAccessor)this.cachedVillager).invokeStartTrading(player);
    }

    public boolean hasVillager() {
        return !this.villagerStack.method_7960();
    }

    @Environment(value=EnvType.CLIENT)
    public class_1646 getVillagerRenderer() {
        if (this.cachedVillager != null) {
            return this.cachedVillager;
        }
        if (this.field_11863 == null) {
            return null;
        }
        class_1646 villager = CachedVillagers.getCached(this.villagerStack, this.field_11863);
        if (villager == null) {
            class_2487 tag = this.villagerStack.method_7911("villager_info");
            if (tag.method_25928("UUID")) {
                ClientUpdatePacket.requestUpdate(tag.method_25926("UUID"));
            }
            return null;
        }
        this.cachedVillager = villager;
        return this.cachedVillager;
    }

    public boolean hasStation() {
        return this.stationsBlock != class_2246.field_10124;
    }

    @Environment(value=EnvType.CLIENT)
    public class_2248 getStationRenderer() {
        return this.stationsBlock;
    }

    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        if (compoundTag == null) {
            return;
        }
        this.villagerStack = class_1799.field_8037;
        this.cachedVillager = null;
        if (compoundTag.method_10545("villager_stack")) {
            this.villagerStack = class_1799.method_7915((class_2487)compoundTag.method_10562("villager_stack"));
            this.cachedVillager = CachedVillagers.getCached(this.villagerStack, this.field_11863);
        }
        this.stationsBlock = class_2246.field_10124;
        if (compoundTag.method_10545("station_block")) {
            this.stationsBlock = ((class_1747)class_1799.method_7915((class_2487)compoundTag.method_10562("station_block")).method_7909()).method_7711();
        }
    }

    protected void method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);
        if (!this.villagerStack.method_7960()) {
            class_2487 stackTag = new class_2487();
            this.villagerStack.method_7953(stackTag);
            compoundTag.method_10566("villager_stack", (class_2520)stackTag);
        }
        if (this.stationsBlock != class_2246.field_10124) {
            class_1799 stack = new class_1799((class_1935)this.stationsBlock, 1);
            class_2487 blockTag = new class_2487();
            stack.method_7953(blockTag);
            compoundTag.method_10566("station_block", (class_2520)blockTag);
        }
        compoundTag.method_10569("version", VERSION);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        this.method_11007(tag);
        return tag;
    }

    private void markUpdated() {
        this.method_5431();
        assert (this.field_11863 != null);
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        if (this.field_11863.field_9236) {
            return;
        }
        BlockEntityHooks.syncData((class_2586)this);
        this.field_11863.method_16107().method_15407();
    }
}

