/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablevillagers.blocks.trader;

import com.shiftthedev.pickablevillagers.blocks.trader.TraderBlock;
import com.shiftthedev.pickablevillagers.blocks.trader.TraderBlockEntity;
import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1646;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2189;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3713;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_824;
import net.minecraft.class_827;
import net.minecraft.class_898;
import net.minecraft.class_918;

@Environment(value=EnvType.CLIENT)
public class TraderRenderer
implements class_827<TraderBlockEntity> {
    private class_898 entityRender;
    private class_824 blockRenderDispatcher;
    private class_776 blockRenderer;
    private class_918 itemRenderer;
    private static final class_1799 INVALID_STACK = new class_1799((class_1935)class_1802.field_8077);
    private static HashMap<class_2248, class_2680> cachedBlocks = new HashMap();

    public void render(TraderBlockEntity blockEntity, float f, class_4587 poseStack, class_4597 multiBufferSource, int i, int j) {
        if (this.entityRender == null) {
            this.entityRender = class_310.method_1551().method_1561();
        }
        if (this.blockRenderDispatcher == null) {
            this.blockRenderDispatcher = class_310.method_1551().method_31975();
        }
        if (this.blockRenderer == null) {
            this.blockRenderer = class_310.method_1551().method_1541();
        }
        if (this.itemRenderer == null) {
            this.itemRenderer = class_310.method_1551().method_1480();
        }
        class_2350 blockDirection = (class_2350)blockEntity.method_11010().method_11654((class_2769)TraderBlock.FACING);
        if (blockEntity.hasVillager()) {
            class_1646 villager = blockEntity.getVillagerRenderer();
            this.renderVillager(villager, blockDirection, poseStack, multiBufferSource, i);
        }
        if (blockEntity.hasStation()) {
            class_2248 block = blockEntity.getStationRenderer();
            this.renderBlock(block, blockDirection, poseStack, multiBufferSource, i, j, f);
        }
    }

    private void renderVillager(class_1646 villager, class_2350 blockDirection, class_4587 poseStack, class_4597 multiBufferSource, int i) {
        if (villager == null) {
            poseStack.method_22903();
            this.translateVillager(poseStack, blockDirection);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(this.getVillagerRotation(blockDirection)));
            poseStack.method_22903();
            poseStack.method_22905(0.2f, 0.2f, 0.2f);
            this.renderBorked(poseStack, i, multiBufferSource);
            poseStack.method_22909();
            poseStack.method_22909();
            return;
        }
        poseStack.method_22903();
        float s = 0.5f / villager.method_17682();
        this.translateVillager(poseStack, blockDirection);
        poseStack.method_22907(class_7833.field_40715.rotationDegrees(this.getVillagerRotation(blockDirection)));
        poseStack.method_22903();
        poseStack.method_22905(s, s, s);
        this.entityRender.method_3948(false);
        this.entityRender.method_3954((class_1297)villager, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, multiBufferSource, i);
        this.entityRender.method_3948(true);
        poseStack.method_22909();
        poseStack.method_22909();
    }

    private void renderBlock(class_2248 block, class_2350 blockDirection, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float partialTicks) {
        if (block == null || block instanceof class_2189) {
            poseStack.method_22903();
            this.translateStation(poseStack, blockDirection);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(this.getStationRotation(blockDirection)));
            poseStack.method_22903();
            poseStack.method_22905(0.2f, 0.2f, 0.2f);
            this.renderBorked(poseStack, i, multiBufferSource);
            poseStack.method_22909();
            poseStack.method_22909();
            return;
        }
        class_2680 blockState = this.getCachedState(block);
        poseStack.method_22903();
        this.translateStation(poseStack, blockDirection);
        poseStack.method_22907(class_7833.field_40715.rotationDegrees(this.getStationRotation(blockDirection)));
        poseStack.method_22903();
        poseStack.method_22905(0.2f, 0.2f, 0.2f);
        if (block.method_9604(blockState) == class_2464.field_11458) {
            class_1921 type = class_4696.method_23683((class_2680)blockState, (boolean)false);
            int color = class_310.method_1551().method_1505().method_1697(blockState, null, null, 0);
            this.blockRenderer.method_3350().method_3367(poseStack.method_23760(), multiBufferSource.getBuffer(type), blockState, this.blockRenderer.method_3349(blockState), (float)(color >> 16 & 0xFF), (float)(color >> 8 & 0xFF), (float)(color & 0xFF), i, j);
        } else {
            class_2343 entityBlock;
            class_2586 blockEntity;
            class_2248 color = blockState.method_26204();
            if (color instanceof class_2343 && (blockEntity = (entityBlock = (class_2343)color).method_10123(class_2338.field_10980, blockState)) != null) {
                this.blockRenderDispatcher.method_3550(blockEntity).method_3569(blockEntity, partialTicks, poseStack, multiBufferSource, i, class_4608.field_21444);
            }
        }
        poseStack.method_22909();
        poseStack.method_22909();
    }

    private void renderBorked(class_4587 poseStack, int light, class_4597 multiBufferSource) {
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.5, 0.0);
        this.itemRenderer.method_23178(INVALID_STACK, class_811.field_4317, light, 0, poseStack, multiBufferSource, null, light);
        poseStack.method_22909();
    }

    private float getVillagerRotation(class_2350 blockDirection) {
        switch (blockDirection) {
            case field_11043: {
                return 180.0f;
            }
            case field_11039: {
                return 90.0f;
            }
            case field_11034: {
                return -90.0f;
            }
        }
        return 0.0f;
    }

    private float getStationRotation(class_2350 blockDirection) {
        switch (blockDirection) {
            case field_11035: {
                return 180.0f;
            }
            case field_11039: {
                return -90.0f;
            }
            case field_11034: {
                return 90.0f;
            }
        }
        return 0.0f;
    }

    private void translateVillager(class_4587 poseStack, class_2350 blockDirection) {
        switch (blockDirection) {
            case field_11043: {
                poseStack.method_22904(0.35, 0.0, 0.3);
                break;
            }
            case field_11035: {
                poseStack.method_22904(0.65, 0.0, 0.7);
                break;
            }
            case field_11034: {
                poseStack.method_22904(0.7, 0.0, 0.35);
                break;
            }
            case field_11039: {
                poseStack.method_22904(0.3, 0.0, 0.65);
            }
        }
    }

    private void translateStation(class_4587 poseStack, class_2350 blockDirection) {
        switch (blockDirection) {
            case field_11043: {
                poseStack.method_22904(0.575, 0.0, 0.35);
                break;
            }
            case field_11035: {
                poseStack.method_22904(0.425, 0.0, 0.65);
                break;
            }
            case field_11034: {
                poseStack.method_22904(0.65, 0.0, 0.575);
                break;
            }
            case field_11039: {
                poseStack.method_22904(0.35, 0.0, 0.425);
            }
        }
    }

    private class_2680 getCachedState(class_2248 block) {
        if (cachedBlocks.containsKey(block)) {
            return cachedBlocks.get(block);
        }
        class_2680 blockState = block.method_9564();
        if (block == class_2246.field_16337) {
            blockState = (class_2680)blockState.method_11657((class_2769)class_3713.field_11007, (Comparable)class_2738.field_12475);
        }
        cachedBlocks.put(block, blockState);
        return blockState;
    }
}

