/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablevillagers.items;

import com.shiftthedev.pickablevillagers.PickableVillagers;
import com.shiftthedev.pickablevillagers.blocks.IVillagerContainer;
import com.shiftthedev.pickablevillagers.mixins.EntityAccessor;
import com.shiftthedev.pickablevillagers.mixins.VillagerEntityAccessor;
import com.shiftthedev.pickablevillagers.network.ClientUpdatePacket;
import com.shiftthedev.pickablevillagers.utils.CachedVillagers;
import com.shiftthedev.pickablevillagers.utils.Helper;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_4140;
import net.minecraft.class_4208;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class VillagerItem
extends class_1792 {
    public static final int VERSION = 1;

    public VillagerItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public void method_7888(class_1799 itemStack, class_1937 level, class_1297 entity, int i, boolean bl) {
        super.method_7888(itemStack, level, entity, i, bl);
        if (level.field_9236) {
            return;
        }
        class_1646 cached = CachedVillagers.getCached(itemStack, level);
        if (cached != null) {
            int oldLevel = cached.method_7231().method_16925();
            Helper.VillagerTick(cached, level, false);
            if (Platform.getEnvironment() == Env.SERVER && oldLevel != cached.method_7231().method_16925()) {
                level.method_18456().forEach(player -> ClientUpdatePacket.sendToPlayer(cached.method_5667(), cached.method_5647(new class_2487()), (class_3222)player));
            }
        }
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 interactionHand) {
        class_1799 stack = player.method_5998(interactionHand);
        if (level.field_9236) {
            return class_1271.method_22430((Object)stack);
        }
        if (!PickableVillagers.CONFIG.InventoryTrade) {
            return super.method_7836(level, player, interactionHand);
        }
        if (interactionHand != class_1268.field_5808) {
            return class_1271.method_22431((Object)stack);
        }
        class_1646 cachedVillager = CachedVillagers.getCached(stack, level);
        if (cachedVillager == null) {
            return class_1271.method_22431((Object)stack);
        }
        if (cachedVillager.method_8264().isEmpty()) {
            return class_1271.method_22431((Object)stack);
        }
        if (cachedVillager.method_18009()) {
            return class_1271.method_22431((Object)stack);
        }
        ((VillagerEntityAccessor)cachedVillager).invokeStartTrading(player);
        return class_1271.method_22430((Object)player.method_5998(interactionHand));
    }

    public class_1269 method_7884(class_1838 ctx) {
        class_3218 level;
        class_1657 class_16572 = ctx.method_8036();
        if (!(class_16572 instanceof class_3222)) {
            return class_1269.field_5812;
        }
        class_3222 player = (class_3222)class_16572;
        if (ctx.method_20287() != class_1268.field_5808) {
            return class_1269.field_5814;
        }
        class_1799 stack = ctx.method_8041();
        class_1646 villager = CachedVillagers.getCached(stack, (class_1937)(level = player.method_51469()));
        if (villager == null) {
            return class_1269.field_5814;
        }
        class_2338 blockPos = ctx.method_8037();
        class_2680 blockState = level.method_8320(blockPos);
        class_2350 direction = ctx.method_8038();
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof IVillagerContainer) {
            IVillagerContainer villagerContainer = (IVillagerContainer)class_22482;
            return this.addToContainer(villagerContainer, level, blockPos, player, villager, stack);
        }
        return this.place(player, level, blockState, blockPos, direction, stack, villager);
    }

    private class_1269 place(class_3222 player, class_3218 level, class_2680 blockState, class_2338 blockPos, class_2350 direction, class_1799 stack, class_1646 villager) {
        class_4208 globalPos;
        if (villager == null) {
            return class_1269.field_5814;
        }
        if (!blockState.method_26220((class_1922)level, blockPos).method_1110()) {
            blockPos = direction == class_2350.field_11033 ? blockPos.method_10079(direction, 2) : blockPos.method_10093(direction);
        }
        villager.method_33574(class_243.method_24953((class_2382)blockPos));
        ((EntityAccessor)villager).setLevel((class_1937)level);
        ((EntityAccessor)villager).setRemovalReason(null);
        if (villager.method_18868().method_18904(class_4140.field_18439).isPresent() && !(globalPos = (class_4208)villager.method_18868().method_18904(class_4140.field_18439).get()).method_19446().method_19769((class_2374)villager.method_19538(), 1.73)) {
            villager.method_18868().method_18875(class_4140.field_18439);
            if (villager.method_18868().method_18904(class_4140.field_18873).isPresent()) {
                villager.method_18868().method_18875(class_4140.field_18873);
            }
            if (villager.method_18868().method_18904(class_4140.field_25160).isPresent()) {
                villager.method_18868().method_18875(class_4140.field_25160);
            }
        }
        villager.method_18868().method_19542(level, (class_1309)villager);
        if (!level.method_8649((class_1297)villager)) {
            return class_1269.field_5814;
        }
        player.method_31548().method_7378(stack);
        CachedVillagers.uncache(villager.method_5667(), (class_1937)level);
        level.method_16107().method_15407();
        return class_1269.field_5812;
    }

    private class_1269 addToContainer(IVillagerContainer villagerContainer, class_3218 level, class_2338 blockPos, class_3222 player, class_1646 villager, class_1799 stack) {
        if (!villagerContainer.addVillager((class_1937)level, blockPos, villager, stack)) {
            return class_1269.field_5814;
        }
        player.method_31548().method_7378(stack);
        level.method_16107().method_15407();
        return class_1269.field_5812;
    }

    public void method_33261(class_1542 itemEntity) {
        super.method_33261(itemEntity);
        if (itemEntity.method_37908().field_9236) {
            return;
        }
        class_2487 tag = itemEntity.method_6983().method_7911("villager_info");
        if (tag.method_25928("UUID")) {
            CachedVillagers.uncache(tag.method_25926("UUID"), null);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 itemStack, @Nullable class_1937 level, List<class_2561> list, class_1836 tooltipFlag) {
        super.method_7851(itemStack, level, list, tooltipFlag);
        class_2487 tag = itemStack.method_7911("villager_info");
        if (!tag.method_25928("UUID")) {
            list.add((class_2561)class_2561.method_43471((String)"tooltip.pickablevillagers.empty"));
            list.add((class_2561)class_2561.method_43471((String)"tooltip.pickablevillagers.report"));
            return;
        }
        if (!CachedVillagers.hasVillager(tag.method_25926("UUID"))) {
            list.add((class_2561)class_2561.method_43471((String)"tooltip.pickablevillagers.borked"));
            list.add((class_2561)class_2561.method_43471((String)"tooltip.pickablevillagers.report"));
            return;
        }
        class_1646 villager = CachedVillagers.getCached(itemStack, level);
        if (villager == null) {
            return;
        }
        if (villager.method_7231().method_16924() == class_3852.field_17051) {
            return;
        }
        this.addTrades(villager, list);
    }

    @Environment(value=EnvType.CLIENT)
    private void addTrades(class_1646 villager, List<class_2561> list) {
        list.add((class_2561)class_2561.method_43470((String)" "));
        class_3850 data = villager.method_7231();
        list.add((class_2561)class_2561.method_43469((String)"tooltip.pickablevillagers.profession", (Object[])new Object[]{this.getVillagerProfession(data.method_16925(), data.method_16924().comp_818())}));
        list.add((class_2561)class_2561.method_43471((String)"tooltip.pickablevillagers.offers"));
        this.getVillagerOffers(villager.method_8264(), list);
    }

    @Environment(value=EnvType.CLIENT)
    private String getVillagerProfession(int level, String profession) {
        Object professionLevel = "";
        professionLevel = (String)professionLevel + (switch (level) {
            case 1 -> "Novice";
            case 2 -> "Apprentice";
            case 3 -> "Journeyman";
            case 4 -> "Expert";
            case 5 -> "Master";
            default -> "ERROR";
        });
        professionLevel = (String)professionLevel + " ";
        professionLevel = (String)professionLevel + this.getFormattedString(profession, true);
        return professionLevel;
    }

    @Environment(value=EnvType.CLIENT)
    private void getVillagerOffers(class_1916 offers, List<class_2561> list) {
        if (offers == null || offers.isEmpty()) {
            return;
        }
        String firstItem = "";
        String secondItem = "";
        String sellItem = "";
        for (class_1914 offer : offers) {
            firstItem = class_2561.method_43471((String)offer.method_8246().method_7922()).getString();
            if (offer.method_8250().method_7909() instanceof class_1772) {
                Map map = class_1890.method_22445((class_2499)class_1772.method_7806((class_1799)offer.method_8250()));
                for (class_1887 enchantment : map.keySet()) {
                    sellItem = enchantment.method_8179(((Integer)map.get(enchantment)).intValue()).getString();
                }
            } else {
                sellItem = class_2561.method_43471((String)offer.method_8250().method_7922()).getString();
            }
            if (offer.method_8247().method_7960()) {
                if (offer.method_8255()) {
                    list.add((class_2561)class_2561.method_43470((String)(firstItem + " -> " + sellItem)).method_27692(class_124.field_1061).method_27692(class_124.field_1055));
                    continue;
                }
                list.add((class_2561)class_2561.method_43470((String)(firstItem + " -> " + sellItem)));
                continue;
            }
            secondItem = class_2561.method_43471((String)offer.method_8247().method_7922()).getString();
            if (offer.method_8255()) {
                list.add((class_2561)class_2561.method_43470((String)(firstItem + " + " + secondItem + " -> " + sellItem)).method_27692(class_124.field_1061).method_27692(class_124.field_1055));
                continue;
            }
            list.add((class_2561)class_2561.method_43470((String)(firstItem + " + " + secondItem + " -> " + sellItem)));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private String getFormattedString(String text, boolean isProfession) {
        Object key = "";
        class_2960 resourceLocation = new class_2960(text);
        if (isProfession) {
            key = ((class_3852)class_7923.field_41195.method_10223(resourceLocation)).comp_818();
            key = ((String)key).substring(0, 1).toUpperCase() + ((String)key).substring(1);
            return key;
        }
        key = class_7923.field_41178.method_10250(resourceLocation) ? ((class_1792)class_7923.field_41178.method_10223(resourceLocation)).method_7876() : ((class_2248)class_7923.field_41175.method_10223(resourceLocation)).method_9539();
        return class_2561.method_43471((String)key).getString();
    }
}

