/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablevillagers.network;

import com.shiftthedev.pickablevillagers.utils.CachedVillagers;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class ClientUpdatePacket {
    private static final class_2960 PACKET_ID = new class_2960("pickablevillagers", "update");

    public static void sendToPlayer(UUID villagerUUID, @Nullable class_2487 villagerTag, class_3222 player) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.method_10797(villagerUUID);
        if (villagerTag != null) {
            buffer.method_10794(villagerTag);
        }
        NetworkManager.sendToPlayer((class_3222)player, (class_2960)PACKET_ID, (class_2540)buffer);
    }

    @Environment(value=EnvType.CLIENT)
    public static void requestUpdate(UUID villagerUUID) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.method_10797(villagerUUID);
        NetworkManager.sendToServer((class_2960)PACKET_ID, (class_2540)buffer);
    }

    public static class Server {
        public static void register() {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (class_2960)PACKET_ID, Server::receive);
        }

        public static void receive(class_2540 buffer, NetworkManager.PacketContext context) {
            if (context.getPlayer().method_7340()) {
                return;
            }
            class_3222 player = (class_3222)context.getPlayer();
            CachedVillagers.sendCachedVillager(player, buffer.method_10790());
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Client {
        public static void register() {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (class_2960)PACKET_ID, Client::receive);
        }

        public static void receive(class_2540 buffer, NetworkManager.PacketContext context) {
            class_2487 tag;
            if (!context.getPlayer().method_7340()) {
                return;
            }
            UUID uuid = buffer.method_10790();
            try {
                tag = buffer.method_10798();
            }
            catch (Exception e) {
                CachedVillagers.receiveRemoveVillager(uuid);
                return;
            }
            CachedVillagers.receiveCachedVillager(uuid, tag, (class_1937)class_310.method_1551().field_1687);
        }
    }
}

