/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.pickablevillagers.utils;

import com.shiftthedev.pickablevillagers.network.ClientUpdatePacket;
import com.shiftthedev.pickablevillagers.network.ConvertPacket;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1646;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3544;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class CachedVillagers {
    private static final TreeMap<UUID, class_1646> cachedVillagers = new TreeMap();
    private static class_1937 overworldLevel;

    public static void cache(class_1646 villager) {
        UUID vilagerUUID = villager.method_5667();
        villager.field_6283 = 0.0f;
        villager.field_6220 = 0.0f;
        villager.field_5982 = 0.0f;
        villager.field_6004 = 0.0f;
        villager.method_36456(0.0f);
        villager.method_36457(0.0f);
        villager.field_6241 = 0.0f;
        villager.field_6259 = 0.0f;
        villager.field_6213 = 0;
        villager.method_6125(0.0f);
        villager.field_6014 = 0.0;
        villager.field_5969 = 0.0;
        villager.field_6251 = 0.0f;
        cachedVillagers.put(vilagerUUID, villager);
    }

    public static void uncache(UUID uuid, @Nullable class_1937 level) {
        if (!cachedVillagers.containsKey(uuid)) {
            return;
        }
        cachedVillagers.remove(uuid);
        CachedVillagers.sendRemoveVillager(level, uuid);
    }

    public static void updateCache(class_1646 updatedVillager) {
        if (!cachedVillagers.containsKey(updatedVillager.method_5667())) {
            return;
        }
        cachedVillagers.put(updatedVillager.method_5667(), updatedVillager);
    }

    public static void updateVillagerName(UUID uuid, String displayName) {
        if (!cachedVillagers.containsKey(uuid)) {
            return;
        }
        if (class_3544.method_15438((String)displayName)) {
            cachedVillagers.get(uuid).method_5665(null);
            return;
        }
        cachedVillagers.get(uuid).method_5665((class_2561)class_2561.method_43470((String)displayName));
    }

    public static class_1646 getCached(class_1799 stack, class_1937 level) {
        if (stack.method_7960()) {
            return null;
        }
        class_2487 tag = stack.method_7911("villager_info");
        if (!tag.method_10545("VERSION") || tag.method_10550("VERSION") != 1) {
            ConvertPacket.requestConvert(stack);
        }
        if (!tag.method_25928("UUID")) {
            return null;
        }
        UUID uuid = tag.method_25926("UUID");
        if (!cachedVillagers.containsKey(uuid)) {
            return CachedVillagers.get(stack, tag, uuid, level);
        }
        return cachedVillagers.get(uuid);
    }

    public static class_1646 get(class_1799 stack, class_2487 tag, UUID uuid, class_1937 level) {
        if (level == null) {
            if (overworldLevel == null) {
                return null;
            }
            level = overworldLevel;
        }
        if (!(level instanceof class_3218)) {
            ClientUpdatePacket.requestUpdate(uuid);
            return null;
        }
        class_1646 villager = CachedVillagers.createVillager(uuid, tag, level);
        if (villager == null) {
            return null;
        }
        if (stack.method_7938()) {
            villager.method_5665(stack.method_7964());
        }
        CachedVillagers.cache(villager);
        return villager;
    }

    private static class_1646 createVillager(UUID uuid, class_2487 tag, class_1937 level) {
        class_1646 villager;
        if (level == null) {
            if (overworldLevel == null) {
                return null;
            }
            level = overworldLevel;
        }
        if ((villager = (class_1646)class_1299.field_6077.method_5883(level)) == null) {
            return null;
        }
        villager.method_5651(tag);
        villager.method_5826(uuid);
        level.method_16107().method_15407();
        return villager;
    }

    public static void updateOldVillager(@Nullable class_2487 oldTag) {
        if (overworldLevel == null) {
            return;
        }
        if (oldTag.method_10545("removing")) {
            return;
        }
        if (!oldTag.method_10545("VillagerData")) {
            return;
        }
        class_1646 villager = (class_1646)class_1299.field_6077.method_5883(overworldLevel);
        if (villager == null) {
            return;
        }
        villager.method_5651(oldTag);
        if (!oldTag.method_10545("VERSION")) {
            villager.method_5749(oldTag);
            oldTag.method_25927("UUID", villager.method_5667());
        }
        oldTag.method_10569("VERSION", 1);
        UUID uuid = villager.method_5667();
        CachedVillagers.cache(villager);
        overworldLevel.method_18456().forEach(player -> CachedVillagers.sendCachedVillager((class_3222)player, uuid));
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean hasVillager(UUID uuid) {
        return cachedVillagers.containsKey(uuid);
    }

    public static void sendCachedVillager(class_3222 player, UUID requestedUUID) {
        if (!cachedVillagers.containsKey(requestedUUID)) {
            return;
        }
        ClientUpdatePacket.sendToPlayer(requestedUUID, cachedVillagers.get(requestedUUID).method_5647(new class_2487()), player);
    }

    public static void sendRemoveVillager(@Nullable class_1937 level, UUID uuid) {
        if (level == null) {
            if (overworldLevel == null) {
                return;
            }
            level = overworldLevel;
        }
        if (level.field_9236) {
            return;
        }
        level.method_18456().forEach(player -> ClientUpdatePacket.sendToPlayer(uuid, null, (class_3222)player));
    }

    @Environment(value=EnvType.CLIENT)
    public static void receiveCachedVillager(UUID uuid, class_2487 tag, class_1937 level) {
        if (tag == null) {
            cachedVillagers.remove(uuid);
            return;
        }
        class_1646 villager = CachedVillagers.createVillager(uuid, tag, level);
        if (villager == null) {
            cachedVillagers.remove(uuid);
            return;
        }
        cachedVillagers.put(uuid, villager);
    }

    @Environment(value=EnvType.CLIENT)
    public static void receiveRemoveVillager(UUID uuid) {
        cachedVillagers.remove(uuid);
    }

    public static void save(Path path) {
        class_2499 listTag = new class_2499();
        for (Map.Entry<UUID, class_1646> villagerEntry : cachedVillagers.entrySet()) {
            class_2487 entryTag = new class_2487();
            entryTag.method_25927("Key", villagerEntry.getKey());
            class_2487 tag = new class_2487();
            villagerEntry.getValue().method_5647(tag);
            entryTag.method_10566("Value", (class_2520)tag);
            listTag.add((Object)entryTag);
        }
        class_2487 tagToSave = new class_2487();
        tagToSave.method_10566("villagers", (class_2520)listTag);
        if (!path.toFile().exists()) {
            path.toFile().mkdirs();
        }
        File file = new File(path.toFile(), "villagers.shift");
        try {
            class_2507.method_30614((class_2487)tagToSave, (File)file);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    public static void load(Path path, MinecraftServer server) {
        class_2487 tag;
        cachedVillagers.clear();
        overworldLevel = server.method_30002();
        File file = new File(path.toFile(), "villagers.shift");
        if (!file.exists()) {
            return;
        }
        try {
            tag = class_2507.method_30613((File)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (tag == null) {
            return;
        }
        if (!tag.method_10545("villagers")) {
            return;
        }
        class_2499 listTag = tag.method_10554("villagers", 10);
        for (class_2520 entry : listTag) {
            if (!(entry instanceof class_2487)) continue;
            class_2487 entryTag = (class_2487)entry;
            class_2487 value = entryTag.method_10562("Value");
            UUID uuid = entryTag.method_25926("Key");
            class_1646 villager = CachedVillagers.createVillager(uuid, value, overworldLevel);
            cachedVillagers.put(uuid, villager);
        }
    }
}

