/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.eisi05.npc.plugin.NpcPlugin;
import de.eisi05.npc.plugin.utils.Prefix;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateChecker {
    private static final String VERSION = Bukkit.getBukkitVersion().split("-")[0];
    private static final String PROJECT_ID = "lMVQTkWl";
    private static final String LOADER = "paper";
    private static final String API_URL = "https://api.modrinth.com/v2/project/lMVQTkWl/version";
    private static final String PROJECT_LINK = "https://modrinth.com/plugin/npc-plugin?version=" + VERSION + "&loader=paper#download";
    private static String LATEST = null;
    private static long lastCheck = 0L;

    public static void checkForUpdates(@Nullable Player player, boolean withFeedback) {
        if (player != null && LATEST != null && lastCheck >= System.currentTimeMillis() - 86400000L) {
            if (lastCheck >= player.getLastPlayed()) {
                UpdateChecker.sendMessage(player, LATEST);
            }
            return;
        }
        lastCheck = System.currentTimeMillis();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)NpcPlugin.plugin, () -> {
            block6: {
                try {
                    URL url = URI.create(API_URL).toURL();
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestProperty("User-Agent", NpcPlugin.plugin.getName());
                    BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    String json = reader.lines().collect(Collectors.joining());
                    reader.close();
                    JsonArray versions = JsonParser.parseString((String)json).getAsJsonArray();
                    for (JsonElement element : versions) {
                        String current;
                        JsonObject version = element.getAsJsonObject();
                        JsonArray loaders = version.getAsJsonArray("loaders");
                        if (!loaders.toString().contains(LOADER)) continue;
                        String latest = version.get("version_number").getAsString();
                        if (!latest.equalsIgnoreCase(current = NpcPlugin.plugin.getPluginMeta().getVersion())) {
                            Bukkit.getConsoleSender().sendMessage(Prefix.PREFIX.append(((TextComponent)Component.text((String)"New version available: ").color((TextColor)NamedTextColor.GRAY)).append(((TextComponent)Component.text((String)latest).color((TextColor)NamedTextColor.GREEN)).append(((TextComponent)Component.text((String)" \u2192 ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)PROJECT_LINK).color((TextColor)NamedTextColor.BLUE))))));
                            Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> {
                                LATEST = latest;
                                UpdateChecker.sendMessage(player, LATEST);
                            });
                        } else if (player != null && withFeedback) {
                            Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> player.sendMessage(Prefix.PREFIX.append(Component.text((String)"You are on the latest version!").color((TextColor)NamedTextColor.GRAY))));
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    NpcPlugin.plugin.getLogger().warning("Failed to check for updates");
                    if (player == null || !withFeedback) break block6;
                    Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> player.sendMessage(Prefix.PREFIX.append(Component.text((String)"Failed to check for updates!").color((TextColor)NamedTextColor.RED))));
                }
            }
        });
    }

    public static void sendMessage(@Nullable Player player, @NotNull String latest) {
        if (player != null) {
            Component component = Prefix.PREFIX.append(((TextComponent)Component.text((String)"New version available: ").color((TextColor)NamedTextColor.GRAY)).append(((TextComponent)Component.text((String)latest).color((TextColor)NamedTextColor.GREEN)).append(((TextComponent)Component.text((String)" \u2192 ").color((TextColor)NamedTextColor.GRAY)).append(((TextComponent)Component.text((String)"[Update]").color((TextColor)NamedTextColor.AQUA)).clickEvent(ClickEvent.openUrl((String)PROJECT_LINK))))));
            player.sendMessage(component);
        }
    }
}

