/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.scheduler;

import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.api.manager.NpcManager;
import de.eisi05.npc.api.objects.NPC;
import de.eisi05.npc.api.objects.NpcOption;
import de.eisi05.npc.api.objects.NpcSkin;
import de.eisi05.npc.api.utils.Reflections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Tasks {
    private static final Map<UUID, String> placeholderCache = new HashMap<UUID, String>();
    private static BukkitTask lookAtTask;
    private static BukkitTask placeholderTask;

    public static void start() {
        Tasks.lookAtTask();
        Tasks.placeholderTask();
    }

    public static void stop() {
        if (lookAtTask != null && !lookAtTask.isCancelled()) {
            lookAtTask.cancel();
        }
        if (placeholderTask != null && !placeholderTask.isCancelled()) {
            placeholderTask.cancel();
        }
    }

    private static void lookAtTask() {
        lookAtTask = new BukkitRunnable(){

            public void run() {
                NpcManager.getList().forEach(npc -> {
                    double range = npc.getOption(NpcOption.LOOK_AT_PLAYER);
                    if (range <= 0.0) {
                        return;
                    }
                    ((ServerPlayer)npc.getServerPlayer()).getBukkitEntity().getNearbyEntities(range, range, range).stream().filter(entity -> entity instanceof Player).forEach(entity -> npc.lookAtPlayer((Player)entity));
                });
            }
        }.runTaskTimer(NpcApi.plugin, 0L, NpcApi.config.lookAtTimer());
    }

    private static void placeholderTask() {
        placeholderTask = new BukkitRunnable(){

            public void run() {
                NpcManager.getList().stream().filter(npc -> !npc.getNpcName().isStatic()).forEach(NPC::updateNameForAll);
                if (!Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
                    return;
                }
                NpcManager.getList().forEach(npc -> {
                    NpcSkin npcSkin = npc.getOption(NpcOption.SKIN);
                    if (npcSkin == null || npcSkin.isStatic() || npcSkin.getSkin() == null) {
                        return;
                    }
                    npc.updateSkin(player -> {
                        String newPlaceholder = (String)Reflections.invokeStaticMethod("me.clip.placeholderapi.PlaceholderAPI", "setPlaceholders", player, npcSkin.getSkin().name()).get();
                        String old = placeholderCache.getOrDefault(player.getUniqueId(), "");
                        if (!old.equals(newPlaceholder)) {
                            placeholderCache.put(player.getUniqueId(), newPlaceholder);
                            return true;
                        }
                        return false;
                    });
                });
            }
        }.runTaskTimer(NpcApi.plugin, NpcApi.config.placeholderTimer(), NpcApi.config.placeholderTimer());
    }
}

