/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.utils.builder;

import de.eisi05.npc.api.utils.PacketReader;
import de.eisi05.npc.plugin.NpcPlugin;
import de.eisi05.npc.plugin.events.SignInputEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundOpenSignEditorPacket;
import net.minecraft.network.protocol.game.ServerboundSignUpdatePacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class SignBuilder
implements Listener {
    private static final Map<UUID, Consumer<SignInputEvent>> events = new HashMap<UUID, Consumer<SignInputEvent>>();

    public SignBuilder() {
        PacketReader.addReader((player, o) -> {
            if (!(o instanceof ServerboundSignUpdatePacket)) {
                return;
            }
            ServerboundSignUpdatePacket packet = (ServerboundSignUpdatePacket)o;
            Location location = new Location(player.getWorld(), (double)packet.getPos().getX(), (double)packet.getPos().getY(), (double)packet.getPos().getZ());
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)NpcPlugin.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new SignInputEvent((Player)player, location, packet.getLines())), 0L);
        });
    }

    public static void open(@NotNull Player player, @NotNull Consumer<SignInputEvent> event, String ... text) {
        Location location = new Location(player.getWorld(), (double)player.getLocation().getBlockX(), (double)player.getLocation().getBlockY(), (double)player.getLocation().getBlockZ());
        while (!location.getBlock().getType().isAir()) {
            location.setY(location.getY() + 1.0);
        }
        BlockPos pos = new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        SignBlockEntity sign = new SignBlockEntity(pos, Blocks.OAK_SIGN.defaultBlockState());
        sign.setAllowedPlayerEditor(player.getUniqueId());
        SignText signText = sign.getText(true);
        for (int i = 0; i < text.length; ++i) {
            signText = signText.setMessage(i, (Component)Component.literal((String)text[i]));
        }
        sign.setText(signText, true);
        sign.setLevel((Level)((CraftWorld)player.getWorld()).getHandle());
        player.sendBlockChange(location, Material.OAK_SIGN.createBlockData());
        ((CraftPlayer)player).getHandle().connection.send((Packet)sign.getUpdatePacket());
        ((CraftPlayer)player).getHandle().connection.send((Packet)new ClientboundOpenSignEditorPacket(pos, true));
        events.put(player.getUniqueId(), event);
    }

    @EventHandler
    public void onSign(SignInputEvent event) {
        events.getOrDefault(event.getPlayer().getUniqueId(), event1 -> {}).accept(event);
        Location location = event.getLocation();
        location.setWorld(event.getPlayer().getWorld());
        event.getPlayer().sendBlockChange(location, location.getBlock().getBlockData());
        events.remove(event.getPlayer().getUniqueId());
    }
}

