/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.objects;

import de.eisi05.npc.api.objects.NPC;
import de.eisi05.npc.api.objects.Skin;
import de.eisi05.npc.api.objects.SkinData;
import de.eisi05.npc.api.utils.SerializableBiFunction;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpcSkin
implements SkinData {
    private static final long serialVersionUID = 1L;
    private final Skin skin;
    private final SerializableBiFunction<Player, NPC, Skin> skinFunction;

    private NpcSkin(@NotNull SerializableBiFunction<Player, NPC, Skin> skinFunction, @NotNull Skin fallback) {
        this.skin = fallback;
        this.skinFunction = skinFunction;
    }

    private NpcSkin(@NotNull Skin skin) {
        this.skin = skin;
        this.skinFunction = null;
    }

    @NotNull
    public static NpcSkin of(@NotNull Skin skin) {
        return new NpcSkin(skin);
    }

    @NotNull
    public static NpcSkin of(@NotNull SerializableBiFunction<Player, NPC, Skin> skinFunction, @NotNull Skin fallback) {
        return new NpcSkin(skinFunction, fallback);
    }

    @Nullable
    public Skin getSkin() {
        return this.skin.value() == null || this.skin.value().isEmpty() ? null : this.skin;
    }

    @Nullable
    public Skin getSkin(@NotNull Player player, @NotNull NPC npc) {
        return this.skinFunction != null ? (Skin)this.skinFunction.apply(player, npc) : this.getSkin();
    }

    public boolean isStatic() {
        return this.skinFunction == null;
    }

    @NotNull
    public NpcSkin copy() {
        return this.isStatic() ? new NpcSkin(this.skin) : new NpcSkin(this.skinFunction, this.skin);
    }

    public String toString() {
        return "{" + (this.isStatic() ? "static" : "dynamic") + " -> " + String.valueOf(this.skin) + "}";
    }
}

