/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.objects;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.api.interfaces.NpcClickAction;
import de.eisi05.npc.api.utils.Reflections;
import de.eisi05.npc.api.utils.Var;
import de.eisi05.npc.api.utils.Versions;
import de.eisi05.npc.plugin.NpcPlugin;
import de.eisi05.npc.plugin.gui.NpcGUI;
import de.eisi05.npc.plugin.manager.CommandManager;
import de.eisi05.npc.plugin.manager.ConversationManager;
import de.eisi05.npc.plugin.manager.LocalizationManager;
import de.eisi05.npc.plugin.objects.AbstractPluginActionOption;
import de.eisi05.npc.plugin.objects.NpcClickActionImpl;
import de.eisi05.npc.plugin.utils.LocalizedMessage;
import de.eisi05.npc.plugin.utils.Prefix;
import de.eisi05.npc.plugin.utils.builder.ItemBuilder;
import java.io.Serializable;
import net.kyori.adventure.text.Component;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.permissions.PermissionSet;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class CommandActionOption
extends AbstractPluginActionOption<String> {
    private static final long serialVersionUID = 1L;

    private CommandActionOption() {
    }

    @NotNull
    static NpcClickActionImpl.PluginActionOptions<String> getCommandAction() {
        return CommandActionOption.getOption(CommandActionOption.class, CommandActionOption::new);
    }

    @Override
    String getName() {
        return "command";
    }

    @Override
    String getDefaultValue() {
        return null;
    }

    @Override
    NpcClickAction getAction(String s) {
        return event -> {
            block15: {
                if (s == null || s.isBlank()) {
                    return;
                }
                String commandToExecute = s.startsWith("/") ? s.substring(1) : s;
                try {
                    CommandSourceStack commandSourceStack = ((CraftPlayer)event.getPlayer()).getHandle().createCommandSourceStack().withSuppressedOutput();
                    commandSourceStack = Versions.isCurrentVersionSmallerThan(Versions.V1_21_11) ? (CommandSourceStack)Reflections.invokeMethod(commandSourceStack, "withMaximumPermission", 4).get() : commandSourceStack.withPermission(PermissionSet.ALL_PERMISSIONS);
                    CommandManager.DISPATCHER.execute(commandToExecute, (Object)commandSourceStack);
                }
                catch (CommandSyntaxException e) {
                    boolean isOp = event.getPlayer().isOp();
                    PermissionAttachment attachment = null;
                    try {
                        String[] split = commandToExecute.split(" ");
                        PluginCommand command = Bukkit.getPluginCommand((String)split[0]);
                        if (command != null && command.getPermission() != null && !isOp) {
                            boolean hasPermission = event.getPlayer().hasPermission(command.getPermission());
                            if (!hasPermission) {
                                attachment = event.getPlayer().addAttachment((Plugin)NpcPlugin.plugin, command.getPermission(), true);
                                Bukkit.dispatchCommand((CommandSender)event.getPlayer(), (String)commandToExecute);
                                event.getPlayer().removeAttachment(attachment);
                            } else {
                                Bukkit.dispatchCommand((CommandSender)event.getPlayer(), (String)commandToExecute);
                            }
                        } else {
                            event.getPlayer().setOp(true);
                            Bukkit.dispatchCommand((CommandSender)event.getPlayer(), (String)commandToExecute);
                        }
                    }
                    catch (CommandException ex) {
                        if (event.getPlayer().hasPermission("npc.admin")) {
                            LocalizedMessage.sendMessage(event.getPlayer(), "actions.command.error.known", true, e.getMessage());
                        }
                    }
                    finally {
                        event.getPlayer().setOp(isOp);
                        if (attachment != null) {
                            event.getPlayer().removeAttachment(attachment);
                        }
                    }
                }
                catch (Exception e) {
                    NpcPlugin.plugin.getLogger().warning("Error executing NPC command: " + s + " for player " + event.getPlayer().getName() + " - " + e.getMessage());
                    if (!event.getPlayer().hasPermission("npc.admin")) break block15;
                    LocalizedMessage.sendMessage(event.getPlayer(), "actions.command.error.unknown", true, new Object[0]);
                }
            }
        };
    }

    @Override
    ItemBuilder getIcon(String s, Player player) {
        return new ItemBuilder(Material.COMMAND_BLOCK).setLore(s == null || s.isEmpty() ? LocalizationManager.get(player, "actions.command.value.short", LocalizationManager.get(player, "misc.not-set", new Object[0])) : LocalizationManager.get(player, "actions.command.value." + (s.length() > 23 ? "long" : "short"), s.length() > 23 ? s.substring(0, 20) : s));
    }

    @Override
    String getClickAction(String currentCommand, final NpcClickActionImpl.PluginActionOptions.PluginActionData data) {
        Player player = (Player)data.event().getWhoClicked();
        player.playSound(player.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.2f);
        data.event().getWhoClicked().closeInventory();
        ConversationManager conversation = new ConversationManager((Plugin)NpcPlugin.plugin).withEscapeSequence(LocalizationManager.getAsString(player, "actions.command.input.abort-sequence", new Object[0])).withTimeout(NpcApi.config.inputTime()).addConversationAbandonedListener(event -> {
            Player p = event.player();
            if (!event.gracefulExit()) {
                p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                if ("timeout".equals(event.reason())) {
                    LocalizedMessage.sendMessage(p, "actions.command.input.timeout", true, NpcApi.config.inputTime());
                } else {
                    LocalizedMessage.sendMessage(p, "actions.command.input.cancelled", true, new Object[0]);
                }
            }
            Bukkit.getScheduler().runTask((Plugin)NpcPlugin.plugin, () -> p.openInventory(NpcGUI.getActionInventory(data.clickActionType(), data.npc(), p, data.withTeleport())));
        });
        ConversationManager.Prompt commandPrompt = new ConversationManager.Prompt(){

            @Override
            public Component getPromptText(Player p) {
                return Prefix.PREFIX.append(LocalizationManager.get(p, "actions.command.input.prompt", new Object[0]));
            }

            @Override
            public ConversationManager.Prompt onInput(Player p, String input) {
                CommandSourceStack commandSourceStack;
                if (input == null || input.trim().isEmpty()) {
                    p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    LocalizedMessage.sendMessage(p, "actions.command.input.empty", true, new Object[0]);
                    return this;
                }
                String processedInput = input.startsWith("/") ? input.substring(1) : input;
                ParseResults results = CommandManager.DISPATCHER.parse(processedInput, (Object)(commandSourceStack = ((CraftPlayer)p).getHandle().createCommandSourceStack()));
                if (!results.getExceptions().isEmpty()) {
                    for (CommandSyntaxException e : results.getExceptions().values()) {
                        LocalizedMessage.sendMessage(p, "actions.command.error.syntax", true, e.getMessage());
                    }
                    p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    return this;
                }
                if (results.getReader().canRead() && !NpcApi.config.avoidCommandCheck()) {
                    LocalizedMessage.sendMessage(p, "actions.command.error.arguments", true, results.getReader().getRemaining());
                    p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    return this;
                }
                data.actionInstance().param = (Serializable)Var.unsafeCast("/" + processedInput);
                data.npc().markChange();
                p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
                LocalizedMessage.sendMessage(p, "actions.command.set", true, "/" + processedInput);
                return null;
            }
        };
        conversation.startConversation(player, commandPrompt);
        return currentCommand;
    }
}

