/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import org.bukkit.craftbukkit.scoreboard.CraftScoreboard;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class TeamManager {
    private static final Map<UUID, Map<String, PlayerTeam>> teams = new HashMap<UUID, Map<String, PlayerTeam>>();

    @NotNull
    public static Object create(@NotNull Player player, @NotNull String name) {
        if (TeamManager.exists(player, name)) {
            return teams.get(player.getUniqueId()).get(name);
        }
        Scoreboard scoreboard = ((CraftScoreboard)player.getScoreboard()).getHandle();
        PlayerTeam team = new PlayerTeam(scoreboard, name);
        Map map = teams.getOrDefault(player.getUniqueId(), new HashMap());
        map.put(name, team);
        teams.put(player.getUniqueId(), map);
        return team;
    }

    public static boolean exists(@NotNull Player player, @NotNull String name) {
        return ((Map)teams.getOrDefault(player.getUniqueId(), new HashMap())).containsKey(name);
    }

    public static void clear() {
        teams.clear();
    }

    public static void clear(@NotNull UUID uuid) {
        teams.remove(uuid);
    }

    public static void clear(String name) {
        for (Map.Entry<UUID, Map<String, PlayerTeam>> entry : teams.entrySet()) {
            entry.getValue().keySet().removeIf(s -> s.equals(name));
        }
    }
}

