/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.objects;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.api.enums.WalkingResult;
import de.eisi05.npc.api.events.NpcStartWalkingEvent;
import de.eisi05.npc.api.interfaces.NpcClickAction;
import de.eisi05.npc.api.manager.NpcManager;
import de.eisi05.npc.api.manager.TeamManager;
import de.eisi05.npc.api.objects.CustomNameTag;
import de.eisi05.npc.api.objects.NpcHolder;
import de.eisi05.npc.api.objects.NpcName;
import de.eisi05.npc.api.objects.NpcOption;
import de.eisi05.npc.api.scheduler.PathTask;
import de.eisi05.npc.api.utils.ObjectSaver;
import de.eisi05.npc.api.utils.Reflections;
import de.eisi05.npc.api.utils.Var;
import de.eisi05.npc.api.utils.Versions;
import de.eisi05.npc.api.wrapper.packets.AnimatePacket;
import de.eisi05.npc.api.wrapper.packets.SetEntityDataPacket;
import de.eisi05.npc.api.wrapper.packets.SetPlayerTeamPacket;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.json.JSONComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NPC
extends NpcHolder {
    private final transient Map<UUID, String> nameCache = new HashMap<UUID, String>();
    ServerPlayer serverPlayer;
    private final List<UUID> viewers = new ArrayList<UUID>();
    private final Map<NpcOption<?, ?>, Object> options;
    private final CustomNameTag nameTag;
    private NpcName name;
    private Location location;
    private NpcClickAction clickEvent;
    private Instant createdAt = Instant.now();
    private Path npcPath;
    private PathTask pathTask;

    public NPC(@NotNull Location location) {
        this(location, UUID.randomUUID());
    }

    public NPC(@NotNull Location location, @NotNull NpcName name) {
        this(location, UUID.randomUUID(), name);
    }

    public NPC(@NotNull Location location, @NotNull UUID uuid) {
        this(location, uuid, NpcName.empty());
    }

    public NPC(@NotNull Location location, @NotNull UUID uuid, @NotNull NpcName name) {
        this.name = name;
        this.location = location;
        DedicatedServer server = ((CraftServer)Bukkit.getServer()).getServer();
        ServerLevel level = ((CraftWorld)location.getWorld()).getHandle();
        GameProfile profile = new GameProfile(uuid, "NPC" + uuid.toString().substring(0, 13));
        this.serverPlayer = new ServerPlayer((MinecraftServer)server, level, profile, ClientInformation.createDefault());
        Var.moveEntity((Entity)this.serverPlayer, location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        this.npcPath = NpcApi.plugin.getDataFolder().toPath().resolve("NPC").resolve(String.valueOf(uuid) + ".npc");
        this.serverPlayer.connection = new ServerGamePacketListenerImpl((MinecraftServer)server, new Connection(PacketFlow.SERVERBOUND), this.serverPlayer, CommonListenerCookie.createInitial((GameProfile)profile, (boolean)true));
        this.options = new HashMap();
        for (NpcOption<?, ?> value : NpcOption.values()) {
            this.setOption(value, Var.unsafeCast(value.getDefaultValue()));
        }
        Display.TextDisplay display = new Display.TextDisplay(EntityType.TEXT_DISPLAY, (Level)((CraftWorld)location.getWorld()).getHandle());
        Var.moveEntity((Entity)display, location.getX(), location.getY() + 2.0, location.getZ(), 0.0f, 0.0f);
        this.nameTag = new CustomNameTag(display);
        this.serverPlayer.listName = CraftChatMessage.fromJSON((String)((String)JSONComponentSerializer.json().serialize(name.getName())));
        this.serverPlayer.passengers = ImmutableList.of((Object)((Display.TextDisplay)this.nameTag.getDisplay()));
        NpcManager.addNPC(this);
    }

    private NPC(@NotNull Location location, @NotNull NpcName name, @NotNull Map<NpcOption<?, ?>, Object> options, @Nullable NpcClickAction clickEvent) {
        this(location, UUID.randomUUID(), name);
        this.options.putAll(options);
        this.clickEvent = clickEvent;
    }

    @NotNull
    public NPC copy(@NotNull Location newLocation) {
        return new NPC(newLocation, this.name.copy(), new HashMap(this.options), this.clickEvent == null ? null : this.clickEvent.copy());
    }

    public boolean isSaved() {
        return Files.exists(this.npcPath, new LinkOption[0]);
    }

    @Override
    public void save() throws IOException {
        this.npcPath.toFile().getParentFile().mkdirs();
        new ObjectSaver(this.npcPath.toFile()).write(SerializedNPC.serializedNPC(this), false);
        super.save();
    }

    @NotNull
    public Object getServerPlayer() {
        return this.serverPlayer;
    }

    @Nullable
    public NpcClickAction getClickEvent() {
        return this.clickEvent;
    }

    @NotNull
    public NPC setClickEvent(@Nullable NpcClickAction event) {
        this.clickEvent = event;
        return this;
    }

    public boolean isEnabled() {
        return this.getOption(NpcOption.ENABLED);
    }

    public void setEnabled(boolean enabled) {
        this.setOption(NpcOption.ENABLED, enabled);
        this.reload();
    }

    public boolean isEditable() {
        return this.getOption(NpcOption.EDITABLE);
    }

    public void setEditable(boolean editable) {
        this.setOption(NpcOption.EDITABLE, editable);
    }

    public <T> void setOption(@NotNull NpcOption<T, ?> option, @Nullable T value) {
        if (value == null) {
            this.options.remove(option);
        } else {
            this.options.put(option, value);
        }
        if (NpcApi.config.autoUpdate()) {
            this.viewers.forEach(uuid -> {
                Player player = Bukkit.getPlayer((UUID)uuid);
                if (player == null) {
                    return;
                }
                option.getPacket(value, this, player).ifPresent(packetWrapper -> ((CraftPlayer)player).getHandle().connection.send((Packet)packetWrapper));
            });
        }
    }

    @Nullable
    public <T> T getOption(@NotNull NpcOption<T, ?> option) {
        return (T)this.options.getOrDefault(option, option.getDefaultValue());
    }

    public void playAnimation(@NotNull Player player, @NotNull AnimatePacket.Animation animation) {
        ((CraftPlayer)player).getHandle().connection.send((Packet)AnimatePacket.create(this.serverPlayer, animation));
    }

    public void reload() {
        ArrayList<UUID> viewers = new ArrayList<UUID>(this.viewers);
        this.hideNpcFromAllPlayers();
        TeamManager.clear(this.getGameProfileName());
        viewers.stream().filter(uuid -> Bukkit.getPlayer((UUID)uuid) != null).forEach(uuid -> this.showNPCToPlayer(Bukkit.getPlayer((UUID)uuid)));
    }

    @NotNull
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(@NotNull Location location) {
        this.location = location;
        if (this.serverPlayer != null) {
            Var.moveEntity((Entity)this.serverPlayer, location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        }
    }

    @Nullable
    public UUID getUUID() {
        if (this.serverPlayer != null) {
            return this.serverPlayer.getUUID();
        }
        return null;
    }

    @NotNull
    public NpcName getNpcName() {
        return this.name;
    }

    @NotNull
    public Component getName(@NotNull Player player) {
        return this.name.getName(player);
    }

    @NotNull
    public Component getName() {
        return this.name.getName();
    }

    @NotNull
    public String getGameProfileName() {
        if (Versions.isCurrentVersionSmallerThan(Versions.V1_21_9)) {
            return (String)Reflections.invokeMethod(this.serverPlayer.getGameProfile(), "getName", new Object[0]).get();
        }
        return this.serverPlayer.getGameProfile().name();
    }

    public void setName(@NotNull NpcName name) {
        this.name = name;
        this.serverPlayer.listName = CraftChatMessage.fromJSON((String)((String)JSONComponentSerializer.json().serialize(name.getName())));
        this.viewers.stream().filter(uuid -> Bukkit.getPlayer((UUID)uuid) != null).forEach(uuid -> this.updateName(Bukkit.getPlayer((UUID)uuid)));
    }

    public void updateName(@NotNull Player player) {
        ((CraftPlayer)player).getHandle().connection.send((Packet)SetEntityDataPacket.create(((Display.TextDisplay)this.nameTag.getDisplay()).getId(), (SynchedEntityData)this.nameTag.applyData(this.isEnabled() ? this.name.getName(player) : NpcApi.DISABLED_MESSAGE_PROVIDER.apply(player).appendNewline().append(this.name.getName(player)))));
    }

    public void updateNameForAll() {
        for (UUID uuid : this.viewers) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) continue;
            String name = PlainTextComponentSerializer.plainText().serialize(this.getName(Bukkit.getPlayer((UUID)uuid)));
            if (this.nameCache.getOrDefault(uuid, "").equals(name)) continue;
            this.updateName(player);
            this.nameCache.put(uuid, name);
        }
    }

    public void updateSkin(@NotNull Predicate<Player> predicate) {
        for (UUID uuid : this.viewers) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null || !predicate.test(player)) continue;
            this.hideNpcFromPlayer(player);
            this.showNPCToPlayer(player);
        }
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public void showNpcToAllPlayers() {
        Bukkit.getOnlinePlayers().forEach(this::showNPCToPlayer);
    }

    public void showNPCToPlayer(@NotNull Player player) {
        if (!(this.getOption(NpcOption.ENABLED).booleanValue() || player.isPermissionSet("npc.admin") || player.isOp())) {
            return;
        }
        if (!player.getWorld().getName().equals(this.serverPlayer.getBukkitEntity().getWorld().getName())) {
            this.hideNpcFromPlayer(player);
            return;
        }
        if (!this.viewers.contains(player.getUniqueId())) {
            this.viewers.add(player.getUniqueId());
        }
        if (!this.name.isStatic() && this.getOption(NpcOption.SHOW_TAB_LIST).booleanValue()) {
            this.setOption(NpcOption.SHOW_TAB_LIST, false);
        }
        ArrayList<Object> packets = new ArrayList<Object>();
        Arrays.stream(NpcOption.values()).filter(NpcOption::loadBefore).forEach(npcOption -> npcOption.getPacket(this.getOption((NpcOption)npcOption), this, player).ifPresent(o -> packets.add((Packet)o)));
        packets.add(ClientboundPlayerInfoUpdatePacket.createSinglePlayerInitializing((ServerPlayer)this.serverPlayer, (boolean)true));
        packets.add(this.serverPlayer.getAddEntityPacket(Var.getServerEntity((Entity)this.serverPlayer, Var.getServerLevel(this.serverPlayer))));
        boolean modified = TeamManager.exists(player, this.getGameProfileName());
        PlayerTeam wrappedPlayerTeam = (PlayerTeam)TeamManager.create(player, this.getGameProfileName());
        wrappedPlayerTeam.setNameTagVisibility(Team.Visibility.NEVER);
        packets.add((Packet)SetPlayerTeamPacket.createAddOrModifyPacket(wrappedPlayerTeam, !modified));
        packets.add((Packet)SetPlayerTeamPacket.createPlayerPacket(wrappedPlayerTeam, this.getGameProfileName(), ClientboundSetPlayerTeamPacket.Action.ADD));
        packets.add(new ClientboundRotateHeadPacket((Entity)this.serverPlayer, (byte)(this.location.getYaw() % 360.0f * 256.0f / 360.0f)));
        packets.add(new ClientboundMoveEntityPacket.Rot(this.serverPlayer.getId(), (byte)this.location.getYaw(), (byte)this.location.getPitch(), this.serverPlayer.onGround));
        if (!this.getOption(NpcOption.HIDE_NAMETAG).booleanValue()) {
            packets.add(((Display.TextDisplay)this.nameTag.getDisplay()).getAddEntityPacket(Var.getServerEntity((Entity)((Display.TextDisplay)this.nameTag.getDisplay()), Var.getServerLevel(this.serverPlayer))));
            packets.add((Packet)SetEntityDataPacket.create(((Display.TextDisplay)this.nameTag.getDisplay()).getId(), (SynchedEntityData)this.nameTag.applyData(this.isEnabled() ? this.name.getName(player) : NpcApi.DISABLED_MESSAGE_PROVIDER.apply(player).appendNewline().append(this.name.getName(player)))));
            packets.add(new ClientboundSetPassengersPacket((Entity)this.serverPlayer));
        }
        Arrays.stream(NpcOption.values()).filter(npcOption -> !npcOption.equals(NpcOption.ENABLED)).forEach(npcOption -> npcOption.getPacket(this.getOption((NpcOption)npcOption), this, player).map(o -> (Packet)o).ifPresent(packets::add));
        NpcOption.ENABLED.getPacket(this.isEnabled(), this, player).map(o -> (Packet)o).ifPresent(packets::add);
        ServerGamePacketListenerImpl connection = ((CraftPlayer)player).getHandle().connection;
        packets.forEach(arg_0 -> ((ServerGamePacketListenerImpl)connection).send(arg_0));
    }

    public void hideNpcFromAllPlayers() {
        Bukkit.getOnlinePlayers().forEach(this::hideNpcFromPlayer);
    }

    public void hideNpcFromPlayer(@NotNull Player player) {
        ServerGamePacketListenerImpl connection = ((CraftPlayer)player).getHandle().connection;
        connection.send((Packet)new ClientboundRemoveEntitiesPacket(new int[]{this.serverPlayer.getId(), ((Display.TextDisplay)this.nameTag.getDisplay()).getId()}));
        if (TeamManager.exists(player, this.getGameProfileName())) {
            PlayerTeam team = (PlayerTeam)TeamManager.create(player, this.getGameProfileName());
            connection.send((Packet)SetPlayerTeamPacket.createPlayerPacket(team, this.getGameProfileName(), ClientboundSetPlayerTeamPacket.Action.REMOVE));
            connection.send((Packet)SetPlayerTeamPacket.createRemovePacket(team));
        }
        connection.send((Packet)new ClientboundPlayerInfoRemovePacket(List.of(this.getUUID())));
        this.viewers.remove(player.getUniqueId());
    }

    public void delete() throws IOException {
        if (this.serverPlayer == null) {
            return;
        }
        this.hideNpcFromAllPlayers();
        NpcManager.removeNPC(this);
        this.serverPlayer.remove(Entity.RemovalReason.DISCARDED);
        this.serverPlayer = null;
        this.npcPath.toFile().getParentFile().mkdirs();
        Files.deleteIfExists(this.npcPath);
    }

    public void lookAtPlayer(@NotNull Player viewer) {
        Location npcLoc = this.serverPlayer.getBukkitEntity().getLocation();
        Location playerLoc = viewer.getLocation();
        if (npcLoc.getWorld() != playerLoc.getWorld()) {
            return;
        }
        double dx = playerLoc.getX() - npcLoc.getX();
        double dy = playerLoc.getY() + viewer.getEyeHeight() - (npcLoc.getY() + this.serverPlayer.getBukkitEntity().getEyeHeight() * this.getOption(NpcOption.SCALE));
        double dz = playerLoc.getZ() - npcLoc.getZ();
        double distanceXZ = Math.sqrt(dx * dx + dz * dz);
        float yaw = (float)Math.toDegrees(Math.atan2(-dx, dz));
        float pitch = (float)Math.toDegrees(-Math.atan2(dy, distanceXZ));
        byte yawByte = (byte)(yaw * 256.0f / 360.0f);
        byte pitchByte = (byte)(pitch * 256.0f / 360.0f);
        ServerGamePacketListenerImpl connection = ((CraftPlayer)viewer).getHandle().connection;
        connection.send((Packet)new ClientboundRotateHeadPacket((Entity)this.serverPlayer, yawByte));
        connection.send((Packet)new ClientboundMoveEntityPacket.Rot(this.serverPlayer.getId(), yawByte, pitchByte, this.serverPlayer.onGround()));
    }

    @NotNull
    public BukkitTask walkTo(@NotNull de.eisi05.npc.api.pathfinding.Path path, double walkSpeed, boolean changeRealLocation) {
        return this.walkTo(path, walkSpeed, changeRealLocation, null, null);
    }

    @NotNull
    public BukkitTask walkTo(@NotNull de.eisi05.npc.api.pathfinding.Path path, double walkSpeed, boolean changeRealLocation, @Nullable Consumer<WalkingResult> onEnd, Player ... viewers) {
        if (this.isWalking()) {
            this.cancelWalking();
        }
        double speed = Math.max(Math.min(walkSpeed, 1.0), 0.1);
        NpcStartWalkingEvent event = new NpcStartWalkingEvent(this, path, speed, changeRealLocation);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        this.pathTask = new PathTask.Builder(this, path).speed(event.getWalkSpeed()).viewers(viewers).updateRealLocation(event.isChangeRealLocation()).callback(onEnd).build();
        return this.pathTask.runTaskTimer(NpcApi.plugin, 1L, 1L);
    }

    public boolean isWalking() {
        return this.pathTask != null && !this.pathTask.isFinished();
    }

    public void cancelWalking() {
        if (this.pathTask != null) {
            this.pathTask.cancel();
            this.pathTask = null;
        }
    }

    public void sendNpcBodyPackets(@Nullable ClientboundMoveEntityPacket moveEntityPacket, Player ... players) {
        if (players != null) {
            for (Player player : players) {
                ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
                if (moveEntityPacket == null) continue;
                serverPlayer.connection.send((Packet)moveEntityPacket);
            }
        } else {
            for (UUID uuid : this.viewers) {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
                if (!offlinePlayer.isOnline()) continue;
                ServerPlayer serverPlayer = ((CraftPlayer)offlinePlayer.getPlayer()).getHandle();
                if (moveEntityPacket == null) continue;
                serverPlayer.connection.send((Packet)moveEntityPacket);
            }
        }
    }

    public void sendNpcMovePackets(@Nullable ClientboundTeleportEntityPacket teleportEntityPacket, @Nullable ClientboundRotateHeadPacket rotateHeadPacket, Player ... players) {
        if (players != null) {
            for (Player player : players) {
                ServerPlayer serverPlayer1 = ((CraftPlayer)player).getHandle();
                if (teleportEntityPacket != null) {
                    serverPlayer1.connection.send((Packet)teleportEntityPacket);
                }
                if (rotateHeadPacket == null) continue;
                serverPlayer1.connection.send((Packet)rotateHeadPacket);
            }
        } else {
            for (UUID uuid : this.viewers) {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
                if (!offlinePlayer.isOnline()) continue;
                ServerPlayer serverPlayer1 = ((CraftPlayer)offlinePlayer.getPlayer()).getHandle();
                if (teleportEntityPacket != null) {
                    serverPlayer1.connection.send((Packet)teleportEntityPacket);
                }
                if (rotateHeadPacket == null) continue;
                serverPlayer1.connection.send((Packet)rotateHeadPacket);
            }
        }
    }

    public void changeRealLocation(Location location, Player ... excludedPlayers) {
        if (this.serverPlayer == null) {
            return;
        }
        this.setLocation(location);
        Set excluded = excludedPlayers == null ? Collections.emptySet() : Arrays.stream(excludedPlayers).filter(Objects::nonNull).map(OfflinePlayer::getUniqueId).collect(Collectors.toSet());
        ClientboundTeleportEntityPacket teleport = new ClientboundTeleportEntityPacket(this.serverPlayer.getId(), new PositionMoveRotation(new Vec3(location.getX(), location.getY(), location.getZ()), new Vec3(0.0, 0.0, 0.0), location.getYaw(), location.getPitch()), Set.of(), true);
        for (UUID uuid : this.viewers) {
            Player viewer = Bukkit.getPlayer((UUID)uuid);
            if (viewer == null || excluded.contains(viewer.getUniqueId())) continue;
            ((CraftPlayer)viewer).getHandle().connection.send((Packet)teleport);
        }
    }

    void changeUUID(@NotNull UUID newUUID) {
        try {
            boolean isSaved = this.isSaved();
            Files.deleteIfExists(this.npcPath);
            this.npcPath = NpcApi.plugin.getDataFolder().toPath().resolve("NPC").resolve(String.valueOf(newUUID) + ".npc");
            if (isSaved) {
                this.save();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CustomNameTag getNameTag() {
        return this.nameTag;
    }

    public record SerializedNPC(@NotNull UUID world, double x, double y, double z, float yaw, float pitch, @NotNull UUID id, @NotNull Serializable name, @NotNull Map<String, ? extends Serializable> options, @Nullable NpcClickAction clickEvent, @NotNull Instant createdAt) implements Serializable
    {
        private static final long serialVersionUID = 1L;

        @NotNull
        public static SerializedNPC serializedNPC(@NotNull NPC npc) {
            HashMap options = new HashMap();
            npc.options.forEach((key, value) -> options.put(key.getPath(), (Serializable)Var.unsafeCast(key.serialize(npc.getOption(key)))));
            return new SerializedNPC(npc.getLocation().getWorld().getUID(), npc.getLocation().getX(), npc.getLocation().getY(), npc.getLocation().getZ(), npc.getLocation().getYaw(), npc.getLocation().getPitch(), npc.getUUID(), npc.getNpcName(), options, npc.clickEvent, npc.createdAt);
        }

        private Object readResolve() throws ObjectStreamException {
            NpcName fixedName;
            Serializable serializable = this.name;
            if (serializable instanceof NpcName) {
                NpcName sn;
                fixedName = sn = (NpcName)serializable;
            } else {
                serializable = this.name;
                if (serializable instanceof String) {
                    String oldName = (String)((Object)serializable);
                    fixedName = NpcName.of(JSONComponentSerializer.json().deserialize((Object)oldName));
                } else {
                    throw new IllegalStateException("Unexpected type for name field: " + String.valueOf(this.name.getClass()));
                }
            }
            return new SerializedNPC(this.world, this.x, this.y, this.z, this.yaw, this.pitch, this.id, fixedName, this.options, this.clickEvent, this.createdAt);
        }

        @NotNull
        public <T, S extends Serializable> NPC deserializedNPC() {
            World world1 = Bukkit.getWorld((UUID)this.world);
            NPC npc = new NPC(new Location(world1 == null ? Bukkit.getWorld((String)"world") : world1, this.x, this.y, this.z, this.yaw, this.pitch), this.id, (NpcName)this.name).setClickEvent(this.clickEvent == null ? this.clickEvent : this.clickEvent.initialize());
            this.options.forEach((string, serializable) -> NpcOption.getOption(string).ifPresent(npcOption -> npc.setOption(npcOption, npcOption.deserialize((Serializable)Var.unsafeCast(serializable)))));
            npc.createdAt = this.createdAt == null ? Instant.now() : this.createdAt;
            return npc;
        }
    }
}

