/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.pathfinding;

import de.eisi05.npc.api.pathfinding.AStarPathfinder;
import de.eisi05.npc.api.pathfinding.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathfindingUtils {
    @NotNull
    public static CompletableFuture<Path> findPathAsync(@NotNull List<Location> waypoints, int maxIterations, boolean allowDiagonalMovement, @Nullable BiConsumer<Integer, Integer> progressListener) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return PathfindingUtils.findPath(waypoints, maxIterations, allowDiagonalMovement, progressListener);
            }
            catch (PathfindingException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @NotNull
    public static Path findPath(@NotNull List<Location> waypoints, int maxIterations, boolean allowDiagonalMovement, @Nullable BiConsumer<Integer, Integer> progressListener) throws PathfindingException {
        if (waypoints.size() < 2) {
            throw new IllegalArgumentException("Waypoints list must contain at least 2 locations.");
        }
        ArrayList<Location> fullPathPoints = new ArrayList<Location>();
        AStarPathfinder aStar = new AStarPathfinder(maxIterations, allowDiagonalMovement);
        for (int i = 0; i < waypoints.size() - 1; ++i) {
            Location end;
            Location start = waypoints.get(i);
            List<Location> segment = aStar.getPath(start, end = waypoints.get(i + 1));
            if (segment == null) {
                throw new PathfindingException("Could not find path between waypoint " + i + " and " + (i + 1));
            }
            if (!fullPathPoints.isEmpty() && !segment.isEmpty() && PathfindingUtils.isAbove(segment.getFirst(), (Location)fullPathPoints.getLast())) {
                segment.removeFirst();
            } else if (!segment.isEmpty()) {
                segment.set(0, segment.getFirst().subtract(0.0, 1.0, 0.0));
            }
            fullPathPoints.addAll(segment);
            if (progressListener == null) continue;
            progressListener.accept(i + 1, waypoints.size() - 1);
        }
        return new Path(fullPathPoints, waypoints);
    }

    private static boolean isAbove(@NotNull Location l1, @NotNull Location l2) {
        return l1.getX() == l2.getX() && l1.getY() - 1.0 == l2.getY() && l1.getZ() == l2.getZ();
    }

    public static class PathfindingException
    extends Exception {
        public PathfindingException(String message) {
            super(message);
        }
    }
}

