/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.scheduler;

import de.eisi05.npc.api.enums.WalkingResult;
import de.eisi05.npc.api.events.NpcStopWalkingEvent;
import de.eisi05.npc.api.objects.NPC;
import de.eisi05.npc.api.pathfinding.Path;
import de.eisi05.npc.api.utils.Var;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Openable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathTask
extends BukkitRunnable {
    private static final double gravity = -0.08;
    private static final double jumpVelocity = 0.5;
    private static final double terminalVelocity = -0.5;
    private static final double stepHeight = -0.5;
    private final NPC npc;
    private final Path path;
    private final List<Location> pathPoints;
    private final Player[] viewers;
    private final ServerPlayer serverEntity;
    private final Consumer<WalkingResult> callback;
    private final double speed;
    private final boolean updateRealLocation;
    private boolean finished = false;
    private int index = 0;
    private Vector currentPos;
    private Vector previousMoveDir;
    private float previousYaw;
    private double verticalVelocity = 0.0;
    private final Set<Block> openedDoors = new HashSet<Block>();

    private PathTask(@NotNull Builder builder) {
        this.npc = builder.npc;
        this.path = builder.path;
        this.pathPoints = new ArrayList<Location>(builder.path.asLocations());
        this.viewers = builder.viewers;
        this.callback = builder.callback;
        this.speed = builder.speed;
        this.updateRealLocation = builder.updateRealLocation;
        this.currentPos = this.npc.getLocation().toVector();
        this.previousYaw = this.npc.getLocation().getYaw();
        this.previousMoveDir = this.npc.getLocation().getDirection();
        this.serverEntity = (ServerPlayer)this.npc.getServerPlayer();
    }

    public void run() {
        if (this.index >= this.pathPoints.size() && this.finishPath()) {
            return;
        }
        Vector target = this.pathPoints.get(this.index).toVector();
        Vector toTarget = target.clone().subtract(this.currentPos);
        if (this.hasReachedWaypoint(toTarget)) {
            ++this.index;
            return;
        }
        this.processDoors();
        this.cleanupDoors();
        Vector movement = this.calculateHorizontalMovement(toTarget, target);
        if (movement.lengthSquared() < 1.0E-6 && this.index < this.pathPoints.size() && this.currentPos.equals((Object)target)) {
            return;
        }
        PhysicsResult physics = this.applyPhysics(movement, toTarget);
        movement.setY(physics.yChange);
        this.currentPos.add(movement);
        float[] rotation = this.calculateSmoothRotation();
        float yaw = rotation[0];
        float pitch = rotation[1];
        this.sendMovePackets(movement, yaw, pitch, physics.isGrounded);
    }

    private void processDoors() {
        Location next;
        World world = this.npc.getLocation().getWorld();
        if (world == null) {
            return;
        }
        this.checkAndOpenDoor(this.currentPos.toLocation(world).getBlock());
        this.checkAndOpenDoor(this.currentPos.toLocation(world).getBlock().getRelative(BlockFace.UP));
        if (this.index < this.pathPoints.size() && this.currentPos.distanceSquared((next = this.pathPoints.get(this.index)).toVector()) < 4.0) {
            this.checkAndOpenDoor(next.getBlock());
            this.checkAndOpenDoor(next.getBlock().getRelative(BlockFace.UP));
        }
    }

    private void checkAndOpenDoor(@NotNull Block block) {
        Openable openable;
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Openable && !(openable = (Openable)blockData).isOpen()) {
            openable.setOpen(true);
            block.setBlockData((BlockData)openable);
            block.getWorld().playSound(block.getLocation(), Sound.BLOCK_WOODEN_DOOR_OPEN, 1.0f, 1.0f);
            this.openedDoors.add(block);
        }
    }

    private void cleanupDoors() {
        if (this.openedDoors.isEmpty()) {
            return;
        }
        Iterator<Block> iterator = this.openedDoors.iterator();
        while (iterator.hasNext()) {
            Block door = iterator.next();
            BlockData blockData = door.getBlockData();
            if (!(blockData instanceof Openable)) {
                iterator.remove();
                continue;
            }
            Openable openable = (Openable)blockData;
            double distSq = Math.pow((double)door.getX() + 0.5 - this.currentPos.getX(), 2.0) + Math.pow((double)door.getZ() + 0.5 - this.currentPos.getZ(), 2.0);
            if (!(distSq > 1.69)) continue;
            if (openable.isOpen()) {
                openable.setOpen(false);
                door.setBlockData((BlockData)openable);
                door.getWorld().playSound(door.getLocation(), Sound.BLOCK_WOODEN_DOOR_CLOSE, 1.0f, 1.0f);
            }
            iterator.remove();
        }
    }

    private void forceCloseAllDoors() {
        for (Block door : this.openedDoors) {
            Openable openable;
            BlockData blockData = door.getBlockData();
            if (!(blockData instanceof Openable) || !(openable = (Openable)blockData).isOpen()) continue;
            openable.setOpen(false);
            door.setBlockData((BlockData)openable);
            door.getWorld().playSound(door.getLocation(), Sound.BLOCK_WOODEN_DOOR_CLOSE, 1.0f, 1.0f);
        }
        this.openedDoors.clear();
    }

    private boolean finishPath() {
        Location last;
        Location location = last = this.path.getWaypoints().isEmpty() ? null : this.path.getWaypoints().getLast();
        if (last != null) {
            if (this.currentPos.distanceSquared(last.toVector()) > 0.04) {
                this.pathPoints.add(last);
                return false;
            }
            this.smoothEndRotation(last);
        }
        this.finished = true;
        this.forceCloseAllDoors();
        if (this.callback != null) {
            this.callback.accept(WalkingResult.SUCCESS);
        }
        NpcStopWalkingEvent event = new NpcStopWalkingEvent(this.npc, WalkingResult.SUCCESS, this.updateRealLocation);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.changeRealLocation()) {
            Location loc = this.path.getWaypoints().isEmpty() ? this.pathPoints.getLast() : this.path.getWaypoints().getLast();
            this.npc.changeRealLocation(loc, this.viewers);
        }
        this.cancel();
        return true;
    }

    private void smoothEndRotation(Location loc) {
        if (this.serverEntity == null) {
            return;
        }
        ClientboundRotateHeadPacket head = new ClientboundRotateHeadPacket((Entity)this.serverEntity, (byte)(loc.getYaw() * 256.0f / 360.0f));
        ClientboundMoveEntityPacket.Rot body = new ClientboundMoveEntityPacket.Rot(this.serverEntity.getId(), (byte)(loc.getYaw() * 256.0f / 360.0f), (byte)(loc.getPitch() * 256.0f / 360.0f), true);
        ClientboundTeleportEntityPacket teleport = new ClientboundTeleportEntityPacket(this.serverEntity.getId(), new PositionMoveRotation(new Vec3(loc.toVector().toVector3f()), new Vec3(loc.toVector().toVector3f()), loc.getYaw(), loc.getPitch()), Set.of(), true);
        this.npc.sendNpcMovePackets(teleport, head, this.viewers);
        this.npc.sendNpcBodyPackets((ClientboundMoveEntityPacket)body, this.viewers);
    }

    private boolean hasReachedWaypoint(@NotNull Vector toTarget) {
        return toTarget.lengthSquared() < 0.04 && Math.abs(toTarget.getY()) < 0.2;
    }

    @NotNull
    private Vector calculateHorizontalMovement(@NotNull Vector toTarget, @NotNull Vector targetPoint) {
        Vector horizontal = new Vector(toTarget.getX(), 0.0, toTarget.getZ());
        double distSq = horizontal.lengthSquared();
        if (distSq < 1.0E-6) {
            return new Vector(0, 0, 0);
        }
        double dist = Math.sqrt(distSq);
        double moveDistance = Math.min(this.speed, dist);
        Vector moveStep = horizontal.clone().normalize().multiply(moveDistance);
        if (Math.abs(moveDistance - dist) < 1.0E-6) {
            this.currentPos = targetPoint.clone();
            ++this.index;
            return new Vector(0, 0, 0);
        }
        return moveStep;
    }

    @NotNull
    private PhysicsResult applyPhysics(Vector movement, Vector toTarget) {
        World world = this.npc.getLocation().getWorld();
        if (world == null) {
            return new PhysicsResult(0.0, false);
        }
        double groundY = this.getGroundY(world, this.currentPos);
        boolean onGround = this.currentPos.getY() <= groundY + 1.0E-5;
        double yChange = 0.0;
        if (onGround) {
            if (toTarget.getY() > 0.0 && toTarget.getY() <= -0.5 && movement.lengthSquared() > 1.0E-6) {
                yChange = Math.min(toTarget.getY(), -0.5);
                this.verticalVelocity = 0.0;
                return new PhysicsResult(yChange, true);
            }
            if (toTarget.getY() > 0.5) {
                this.verticalVelocity = 0.5;
                onGround = false;
            } else {
                this.verticalVelocity = 0.0;
                if (Math.abs(this.currentPos.getY() - groundY) > 1.0E-6) {
                    this.currentPos.setY(groundY);
                }
                return new PhysicsResult(0.0, true);
            }
        }
        if (!onGround) {
            this.verticalVelocity += -0.08;
            if (this.verticalVelocity < -0.5) {
                this.verticalVelocity = -0.5;
            }
            yChange = this.verticalVelocity;
            if (this.currentPos.getY() + yChange <= groundY) {
                yChange = groundY - this.currentPos.getY();
                this.verticalVelocity = 0.0;
                onGround = true;
            }
        }
        return new PhysicsResult(yChange, onGround);
    }

    private double getGroundY(@NotNull World world, @NotNull Vector pos) {
        int startY;
        int bx = pos.getBlockX();
        int bz = pos.getBlockZ();
        for (int y = startY = pos.getBlockY(); y >= startY - 3; --y) {
            Block block = world.getBlockAt(bx, y, bz);
            if (block.getBlockData() instanceof Openable) continue;
            if (Var.isCarpet(block.getType()) && Var.isCarpet(block.getRelative(BlockFace.UP).getType())) {
                return ++y;
            }
            if (!block.getType().isSolid() || block.isPassable()) {
                return y;
            }
            OptionalDouble maxY = block.getCollisionShape().getBoundingBoxes().stream().mapToDouble(BoundingBox::getMaxY).max();
            OptionalDouble minY = block.getCollisionShape().getBoundingBoxes().stream().mapToDouble(BoundingBox::getMinY).min();
            if (!minY.isPresent() || !maxY.isPresent()) continue;
            return (double)y + minY.getAsDouble() + (maxY.getAsDouble() - minY.getAsDouble());
        }
        return world.getHighestBlockYAt(bx, bz);
    }

    private float @NotNull [] calculateSmoothRotation() {
        float yaw;
        Vector lookDir;
        if (this.index + 1 < this.pathPoints.size()) {
            Vector p1 = this.pathPoints.get(this.index).toVector();
            Vector p2 = this.pathPoints.get(this.index + 1).toVector();
            lookDir = p1.add(p2).multiply(0.5).subtract(this.currentPos);
        } else {
            lookDir = this.pathPoints.get(Math.min(this.index, this.pathPoints.size() - 1)).toVector().subtract(this.currentPos);
        }
        Vector horizontalLook = new Vector(lookDir.getX(), 0.0, lookDir.getZ());
        if (horizontalLook.lengthSquared() < 1.0E-6) {
            horizontalLook = this.previousMoveDir.clone();
        }
        float targetYaw = (float)(Math.toDegrees(Math.atan2(horizontalLook.getZ(), horizontalLook.getX())) - 90.0);
        targetYaw = this.normalizeAngle(targetYaw);
        float diff = this.normalizeAngle(targetYaw - this.previousYaw);
        diff = Math.max(-15.0f, Math.min(15.0f, diff));
        this.previousYaw = yaw = this.previousYaw + diff;
        this.previousMoveDir = horizontalLook;
        Vector targetVec = this.pathPoints.get(Math.min(this.index + 1, this.pathPoints.size() - 1)).toVector().subtract(this.currentPos);
        double hLen = Math.sqrt(targetVec.getX() * targetVec.getX() + targetVec.getZ() * targetVec.getZ());
        float pitch = (float)(-Math.toDegrees(Math.atan2(targetVec.getY(), hLen))) / 1.5f;
        return new float[]{yaw, pitch};
    }

    private float normalizeAngle(float angle) {
        while (angle > 180.0f) {
            angle -= 360.0f;
        }
        while (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    private void sendMovePackets(Vector movement, float yaw, float pitch, boolean onGround) {
        if (this.serverEntity == null) {
            return;
        }
        ClientboundRotateHeadPacket head = new ClientboundRotateHeadPacket((Entity)this.serverEntity, (byte)(yaw * 256.0f / 360.0f));
        ClientboundTeleportEntityPacket teleport = new ClientboundTeleportEntityPacket(this.serverEntity.getId(), new PositionMoveRotation(new Vec3(this.currentPos.toVector3f()), new Vec3(movement.toVector3f()), yaw, pitch), Set.of(), onGround);
        this.npc.sendNpcMovePackets(teleport, head, this.viewers);
    }

    public synchronized void cancel() throws IllegalStateException {
        if (this.finished) {
            super.cancel();
            return;
        }
        this.finished = true;
        this.forceCloseAllDoors();
        super.cancel();
        if (this.callback != null) {
            this.callback.accept(WalkingResult.CANCELLED);
        }
        NpcStopWalkingEvent event = new NpcStopWalkingEvent(this.npc, WalkingResult.CANCELLED, this.updateRealLocation);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.changeRealLocation()) {
            World world = this.path.getWaypoints().isEmpty() ? this.pathPoints.getLast().getWorld() : this.path.getWaypoints().getLast().getWorld();
            Location loc = new Location(world, this.currentPos.getX(), this.currentPos.getY(), this.currentPos.getZ());
            this.npc.changeRealLocation(loc, this.viewers);
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public static class Builder {
        private final NPC npc;
        private final Path path;
        private Player[] viewers = null;
        private Consumer<WalkingResult> callback = null;
        private double speed = 1.0;
        private boolean updateRealLocation = false;

        public Builder(@NotNull NPC npc, @NotNull Path path) {
            this.npc = npc;
            this.path = path;
        }

        @NotNull
        public Builder viewers(Player ... viewers) {
            this.viewers = viewers;
            return this;
        }

        @NotNull
        public Builder speed(double speed) {
            this.speed = speed;
            return this;
        }

        @NotNull
        public Builder updateRealLocation(boolean update) {
            this.updateRealLocation = update;
            return this;
        }

        @NotNull
        public Builder callback(@Nullable Consumer<WalkingResult> callback) {
            this.callback = callback;
            return this;
        }

        @NotNull
        public PathTask build() {
            return new PathTask(this);
        }
    }

    private record PhysicsResult(double yChange, boolean isGrounded) {
    }
}

