/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin;

import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.api.objects.NpcConfig;
import de.eisi05.npc.plugin.commands.NpcCommand;
import de.eisi05.npc.plugin.listeners.ConnectionListener;
import de.eisi05.npc.plugin.listeners.InventoryListener;
import de.eisi05.npc.plugin.listeners.NpcInteractListener;
import de.eisi05.npc.plugin.listeners.ServerReadyListener;
import de.eisi05.npc.plugin.manager.CommandManager;
import de.eisi05.npc.plugin.manager.ConversationManager;
import de.eisi05.npc.plugin.manager.LocalizationManager;
import de.eisi05.npc.plugin.manager.PathManager;
import de.eisi05.npc.plugin.utils.ItemList;
import de.eisi05.npc.plugin.utils.builder.ItemBuilder;
import de.eisi05.npc.plugin.utils.builder.SignBuilder;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class NpcPlugin
extends JavaPlugin {
    public static JavaPlugin plugin;

    public static void reload() {
        NpcApi.disable();
        LocalizationManager.loadLanguages(plugin);
        NpcApi.createInstance(plugin, NpcPlugin.loadConfig((Plugin)plugin)).setDisabledMessageProvider(player -> LegacyComponentSerializer.legacyAmpersand().deserialize(LocalizationManager.getAsString(player, "misc.disabled", new Object[0]).toUpperCase()));
    }

    public static NpcConfig loadConfig(@NotNull Plugin plugin) {
        File configFile = new File(plugin.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            plugin.saveResource("config.yml", false);
            plugin.reloadConfig();
        }
        Configuration config = plugin.getConfig().getDefaults();
        YamlConfiguration pluginConfig = YamlConfiguration.loadConfiguration((File)configFile);
        for (String key : config.getKeys(true)) {
            if (pluginConfig.contains(key)) continue;
            pluginConfig.set(key, config.get(key));
        }
        try {
            pluginConfig.save(configFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        NpcConfig npcConfig = new NpcConfig();
        long lookAtInterval = pluginConfig.getLong("lookAtTimer", npcConfig.lookAtTimer());
        boolean avoidCommandCheck = pluginConfig.getBoolean("avoid-command-check", npcConfig.avoidCommandCheck());
        boolean debug = pluginConfig.getBoolean("debug", npcConfig.debug());
        int inputTime = pluginConfig.getInt("inputTime", npcConfig.inputTime());
        boolean autoUpdate = pluginConfig.getBoolean("auto-update", npcConfig.autoUpdate());
        long placeholderInterval = pluginConfig.getLong("placeholderTimer", npcConfig.placeholderTimer());
        return npcConfig.lookAtTimer(lookAtInterval).avoidCommandCheck(avoidCommandCheck).debug(debug).inputTime(inputTime).autoUpdate(autoUpdate).placeholderTimer(placeholderInterval);
    }

    public static void saveConfig(NpcConfig config) {
        if (plugin == null) {
            return;
        }
        File configFile = new File(plugin.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            plugin.saveResource("config.yml", false);
            plugin.reloadConfig();
        }
        YamlConfiguration pluginConfig = YamlConfiguration.loadConfiguration((File)configFile);
        pluginConfig.set("lookAtTimer", (Object)config.lookAtTimer());
        pluginConfig.set("avoid-command-check", (Object)config.avoidCommandCheck());
        pluginConfig.set("debug", (Object)config.debug());
        pluginConfig.set("inputTime", (Object)config.inputTime());
        pluginConfig.set("auto-update", (Object)config.autoUpdate());
        pluginConfig.set("placeholderTimer", (Object)config.placeholderTimer());
        try {
            pluginConfig.save(configFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void onDisable() {
        PathManager.savePaths();
        ConversationManager.activeConversations.forEach((uuid, activeConversation) -> activeConversation.abandon(Bukkit.getPlayer((UUID)uuid)));
        NpcApi.disable();
        try {
            CommandManager.unregister();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public void onLoad() {
        try {
            Class.forName("io.papermc.paper.configuration.PaperConfigurations");
        }
        catch (ClassNotFoundException e) {
            String msg = "This plugin does not support Spigot servers! Please download the Spigot version here: https://modrinth.com/plugin/npc-plugin#download";
            this.getLogger().severe(msg);
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onEnable() {
        plugin = this;
        this.getLogger().info("Registering commands...");
        NpcCommand.register();
        this.getLogger().info("Registering listeners...");
        Bukkit.getPluginManager().registerEvents((Listener)new ServerReadyListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ItemBuilder.ItemListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new InventoryListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new NpcInteractListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ConnectionListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new SignBuilder(), (Plugin)this);
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            if (plugin.equals((Object)this) || !plugin.getName().toLowerCase().contains("npc") || !plugin.getPluginMeta().getAuthors().contains("Eisi05")) continue;
            Bukkit.getPluginManager().disablePlugin(plugin);
            plugin.getLogger().warning("Please delete NPC.jar from your plugins folder, as it is not needed anymore!");
        }
        this.getLogger().info("Loading items...");
        ItemList.load();
        this.getLogger().info("Loading language files...");
        LocalizationManager.loadLanguages(this);
    }
}

