/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.commands;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.api.manager.NpcManager;
import de.eisi05.npc.api.objects.NPC;
import de.eisi05.npc.api.objects.NpcName;
import de.eisi05.npc.api.scheduler.Tasks;
import de.eisi05.npc.api.utils.Var;
import de.eisi05.npc.api.utils.Versions;
import de.eisi05.npc.plugin.NpcPlugin;
import de.eisi05.npc.plugin.commands.PathCommand;
import de.eisi05.npc.plugin.gui.NpcGUI;
import de.eisi05.npc.plugin.manager.CommandManager;
import de.eisi05.npc.plugin.manager.EditManager;
import de.eisi05.npc.plugin.manager.LocalizationManager;
import de.eisi05.npc.plugin.utils.LocalizedMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.UuidArgument;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class NpcCommand {
    public static void register() {
        CommandManager.register((LiteralArgumentBuilder<Object>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"npc").requires(o -> ((CommandSourceStack)o).getBukkitSender().hasPermission("npc.admin"))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"create").requires(o -> ((CommandSourceStack)o).getBukkitSender() instanceof Player)).executes(ctx -> {
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getBukkitSender();
            NPC npc = new NPC(player.getLocation(), NpcName.empty());
            npc.setEditable(true);
            try {
                npc.save();
            }
            catch (IOException e) {
                LocalizedMessage.sendMessage(player, "command.create.fail", true, e.getMessage());
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                NpcPlugin.plugin.getLogger().severe("Failed to save NPC on creation: " + e.getMessage());
                return 0;
            }
            npc.showNpcToAllPlayers();
            LocalizedMessage.sendMessage(player, "command.create.success", true, new Object[0]);
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.2f);
            return 1;
        }))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"copy").requires(o -> ((CommandSourceStack)o).getBukkitSender() instanceof Player)).then(RequiredArgumentBuilder.argument((String)"uuid", (ArgumentType)UuidArgument.uuid()).suggests(NpcCommand::uuidSuggestions).executes(ctx -> {
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getBukkitSender();
            UUID uuid = UuidArgument.getUuid((CommandContext)((CommandContext)Var.unsafeCast(ctx)), (String)"uuid");
            NPC npc = NpcManager.fromUUID(uuid).orElseThrow(() -> {
                player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 0.5f);
                return new SimpleCommandExceptionType((Message)new LiteralMessage("No NPC found with that UUID")).create();
            });
            NPC copy = npc.copy(player.getLocation());
            try {
                copy.save();
            }
            catch (IOException e) {
                LocalizedMessage.sendMessage(player, "command.copy.save.fail", true, e.getMessage());
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                NpcPlugin.plugin.getLogger().severe("Failed to save copied NPC: " + e.getMessage());
                return 0;
            }
            copy.showNpcToAllPlayers();
            LocalizedMessage.sendMessage(player, "command.copy.success", true, new Object[0]);
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.5f);
            return 1;
        })))).then(LiteralArgumentBuilder.literal((String)"reload").executes(ctx -> {
            NpcPlugin.reload();
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getBukkitSender();
            LocalizedMessage.sendMessage(player, "command.reload.success", true, new Object[0]);
            player.playSound(player.getLocation(), Sound.ITEM_ARMOR_EQUIP_IRON, 1.0f, 1.0f);
            return 1;
        }))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"edit").requires(o -> ((CommandSourceStack)o).getBukkitSender() instanceof Player)).executes(ctx -> {
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getBukkitSender();
            if (EditManager.isEditing(player)) {
                EditManager.removeEditingPlayer(player);
                LocalizedMessage.sendMessage(player, "command.edit.disabled", true, new Object[0]);
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_HAT, 1.0f, 0.8f);
            } else {
                EditManager.addEditingPlayer(player);
                LocalizedMessage.sendMessage(player, "command.edit.enabled", true, new Object[0]);
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.2f);
            }
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"tp").then(RequiredArgumentBuilder.argument((String)"id", (ArgumentType)UuidArgument.uuid()).suggests(NpcCommand::uuidSuggestions).executes(ctx -> {
            UUID id = UuidArgument.getUuid((CommandContext)((CommandContext)Var.unsafeCast(ctx)), (String)"id");
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getBukkitSender();
            NpcManager.fromUUID(id).ifPresentOrElse(npc -> {
                player.teleport(npc.getLocation());
                player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.2f);
                LocalizedMessage.sendMessage(player, "command.tp.success", true, npc.getName());
            }, () -> {
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                LocalizedMessage.sendMessage(player, "command.tp.fail", true, id);
            });
            return 1;
        })))).then(LiteralArgumentBuilder.literal((String)"tphere").then(RequiredArgumentBuilder.argument((String)"id", (ArgumentType)UuidArgument.uuid()).suggests(NpcCommand::uuidSuggestions).executes(ctx -> {
            UUID id = UuidArgument.getUuid((CommandContext)((CommandContext)Var.unsafeCast(ctx)), (String)"id");
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getBukkitSender();
            NpcManager.fromUUID(id).ifPresentOrElse(npc -> {
                try {
                    NPC copy = npc.copy(player.getLocation());
                    copy.showNpcToAllPlayers();
                    copy.save();
                    npc.delete();
                }
                catch (Exception e) {
                    player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    LocalizedMessage.sendMessage(player, "command.tphere.fail", true, npc.getName());
                    return;
                }
                player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.2f);
                LocalizedMessage.sendMessage(player, "command.tphere.success", true, npc.getName());
            }, () -> {
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                LocalizedMessage.sendMessage(player, "command.tphere.no-npc", true, id);
            });
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"config").then(LiteralArgumentBuilder.literal((String)"reload").executes(ctx -> {
            NpcApi.config = NpcPlugin.loadConfig((Plugin)NpcPlugin.plugin);
            Tasks.stop();
            Tasks.start();
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getBukkitSender();
            LocalizedMessage.sendMessage(player, "command.config.reload", true, new Object[0]);
            return 1;
        }))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"debug").executes(ctx -> {
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getBukkitSender();
            LocalizedMessage.sendMessage(player, "command.config.debug.get", true, NpcApi.config.debug());
            return 1;
        })).then(RequiredArgumentBuilder.argument((String)"debug", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            boolean debug = BoolArgumentType.getBool((CommandContext)ctx, (String)"debug");
            NpcApi.config = NpcApi.config.debug(debug);
            NpcPlugin.saveConfig(NpcApi.config);
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getBukkitSender();
            LocalizedMessage.sendMessage(player, "command.config.debug.set", true, debug);
            return 1;
        })))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"avoid-command-check").executes(ctx -> {
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getBukkitSender();
            LocalizedMessage.sendMessage(player, "command.config.avoid-command-check.get", true, NpcApi.config.avoidCommandCheck());
            return 1;
        })).then(RequiredArgumentBuilder.argument((String)"avoid-command-check", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            boolean avoidCommandCheck = BoolArgumentType.getBool((CommandContext)ctx, (String)"avoid-command-check");
            NpcApi.config = NpcApi.config.avoidCommandCheck(avoidCommandCheck);
            NpcPlugin.saveConfig(NpcApi.config);
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getBukkitSender();
            LocalizedMessage.sendMessage(player, "command.config.avoid-command-check.set", true, avoidCommandCheck);
            return 1;
        })))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"look-at-update-interval").executes(ctx -> {
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getBukkitSender();
            LocalizedMessage.sendMessage(player, "command.config.look-at-update-interval.get", true, NpcApi.config.lookAtTimer());
            return 1;
        })).then(RequiredArgumentBuilder.argument((String)"look-at-update-interval", (ArgumentType)LongArgumentType.longArg((long)0L)).executes(ctx -> {
            long lookAtInterval = LongArgumentType.getLong((CommandContext)ctx, (String)"look-at-update-interval");
            NpcApi.config = NpcApi.config.lookAtTimer(lookAtInterval);
            NpcPlugin.saveConfig(NpcApi.config);
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getBukkitSender();
            LocalizedMessage.sendMessage(player, "command.config.look-at-update-interval.set", true, lookAtInterval);
            return 1;
        })))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"input-time").executes(ctx -> {
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getBukkitSender();
            LocalizedMessage.sendMessage(player, "command.config.input-time.get", true, NpcApi.config.inputTime());
            return 1;
        })).then(RequiredArgumentBuilder.argument((String)"input-time", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            int inputTime = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"input-time");
            NpcApi.config = NpcApi.config.inputTime(inputTime);
            NpcPlugin.saveConfig(NpcApi.config);
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getBukkitSender();
            LocalizedMessage.sendMessage(player, "command.config.input-time.set", true, inputTime);
            return 1;
        })))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"auto-update").executes(ctx -> {
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getBukkitSender();
            LocalizedMessage.sendMessage(player, "command.config.auto-update.get", true, NpcApi.config.autoUpdate());
            return 1;
        })).then(RequiredArgumentBuilder.argument((String)"auto-update", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            boolean autoUpdate = BoolArgumentType.getBool((CommandContext)ctx, (String)"auto-update");
            NpcApi.config = NpcApi.config.autoUpdate(autoUpdate);
            NpcPlugin.saveConfig(NpcApi.config);
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getBukkitSender();
            LocalizedMessage.sendMessage(player, "command.config.auto-update.set", true, autoUpdate);
            return 1;
        })))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"placeholder-timer").executes(ctx -> {
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getBukkitSender();
            LocalizedMessage.sendMessage(player, "command.config.placeholder-timer.get", true, NpcApi.config.placeholderTimer());
            return 1;
        })).then(RequiredArgumentBuilder.argument((String)"placeholder-timer", (ArgumentType)LongArgumentType.longArg((long)0L)).executes(ctx -> {
            long placeholderTimer = LongArgumentType.getLong((CommandContext)ctx, (String)"placeholder-timer");
            NpcApi.config = NpcApi.config.placeholderTimer(placeholderTimer);
            NpcPlugin.saveConfig(NpcApi.config);
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getBukkitSender();
            LocalizedMessage.sendMessage(player, "command.config.placeholder-timer.set", true, placeholderTimer);
            return 1;
        })))).then(LiteralArgumentBuilder.literal((String)"list").executes(ctx -> {
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getBukkitSender();
            LocalizedMessage.sendMessage(player, "command.config.list.title", true, new Object[0]);
            LocalizedMessage.sendMessage(player, "command.config.list.look-at-time", false, new Object[0]);
            LocalizedMessage.sendMessage(player, "command.config.list.avoid-command-check", false, new Object[0]);
            LocalizedMessage.sendMessage(player, "command.config.list.debug", false, new Object[0]);
            LocalizedMessage.sendMessage(player, "command.config.list.input-time", false, new Object[0]);
            LocalizedMessage.sendMessage(player, "command.config.list.auto-update", false, new Object[0]);
            return 1;
        })))).then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"list").requires(o -> ((CommandSourceStack)o).getBukkitSender() instanceof Player)).executes(ctx -> {
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getBukkitSender();
            LocalizedMessage.sendMessage(player, "command.list.loading", true, new Object[0]);
            if (player.openInventory(NpcGUI.getListInventory(player)) != null) {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }
            return 1;
        }))).then(LiteralArgumentBuilder.literal((String)"version").executes(ctx -> {
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getBukkitSender();
            LocalizedMessage.sendMessage(player, "command.version", true, NpcPlugin.plugin.getPluginMeta().getVersion(), Versions.getVersion().getName());
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.8f, 1.0f);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"exceptions").then(RequiredArgumentBuilder.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getBukkitSender();
            int page = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page");
            int perPage = 10;
            ArrayList<String> keys = new ArrayList<String>(NpcManager.loadExceptions.keySet());
            if (keys.isEmpty()) {
                LocalizedMessage.sendMessage(player, "command.exceptions.none", true, new Object[0]);
                return 1;
            }
            int totalPages = (int)Math.ceil((double)keys.size() / (double)perPage);
            page = Math.max(1, Math.min(page, totalPages));
            int start = (page - 1) * perPage;
            int end = Math.min(start + perPage, keys.size());
            List subList = keys.subList(start, end);
            player.sendMessage(LocalizationManager.get(player, "command.exceptions.list", page, totalPages));
            for (String s : subList) {
                TextComponent text = Component.text((String)s, (TextColor)NamedTextColor.GRAY);
                Component showBtn = LocalizationManager.get(player, "command.exceptions.button.show", new Object[0]).clickEvent(ClickEvent.runCommand((String)("/npc exceptions show " + s)));
                Component delBtn = LocalizationManager.get(player, "command.exceptions.button.delete", new Object[0]).clickEvent(ClickEvent.runCommand((String)("/npc exceptions delete " + s)));
                Component line = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append((Component)text)).append((Component)Component.space())).append(showBtn)).append((Component)Component.space())).append(delBtn);
                player.sendMessage(line);
            }
            TextComponent nav = Component.empty();
            if (page > 1) {
                Component prev = Component.text((String)"[Prev]", (TextColor)NamedTextColor.AQUA).clickEvent(ClickEvent.runCommand((String)("/npc exceptions " + (page - 1))));
                nav = nav.append(prev);
            }
            if (page < totalPages) {
                if (!nav.equals((Object)Component.empty())) {
                    nav = nav.append((Component)Component.space());
                }
                Component next = Component.text((String)"[Next]", (TextColor)NamedTextColor.AQUA).clickEvent(ClickEvent.runCommand((String)("/npc exceptions " + (page + 1))));
                nav = nav.append(next);
            }
            if (!nav.equals((Object)Component.empty())) {
                player.sendMessage((Component)nav);
            }
            return 1;
        }))).executes(ctx -> {
            ((Player)((CommandSourceStack)ctx.getSource()).getBukkitSender()).performCommand("npc exceptions 1");
            return 1;
        })).then(LiteralArgumentBuilder.literal((String)"show").then(RequiredArgumentBuilder.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getBukkitSender();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            Exception exception = NpcManager.loadExceptions.get(name);
            if (exception == null) {
                LocalizedMessage.sendMessage(player, "command.exceptions.not-found", true, new Object[0]);
            } else {
                exception.printStackTrace();
                LocalizedMessage.sendMessage(player, "command.exceptions.show", true, new Object[0]);
            }
            return 1;
        })))).then(LiteralArgumentBuilder.literal((String)"delete").then(RequiredArgumentBuilder.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            Player player = (Player)((CommandSourceStack)ctx.getSource()).getBukkitSender();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            if (NpcManager.loadExceptions.remove(name) != null) {
                NpcPlugin.plugin.getDataFolder().toPath().resolve("NPC").resolve(name).toFile().delete();
                LocalizedMessage.sendMessage(player, "command.exceptions.deleted", true, new Object[0]);
            } else {
                LocalizedMessage.sendMessage(player, "command.exceptions.not-found", true, new Object[0]);
            }
            return 1;
        }))))).then(PathCommand.pathCommand())));
    }

    @NotNull
    private static CompletableFuture<Suggestions> uuidSuggestions(@NotNull CommandContext<?> context, @NotNull SuggestionsBuilder builder) {
        for (NPC npc : NpcManager.getList()) {
            if (!npc.getUUID().toString().toLowerCase().startsWith(builder.getRemainingLowerCase())) continue;
            builder.suggest(npc.getUUID().toString(), (Message)new LiteralMessage(PlainTextComponentSerializer.plainText().serialize(npc.getName())));
        }
        return builder.buildFuture();
    }
}

