/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.manager;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConversationManager
implements Listener {
    public static final Map<UUID, ActiveConversation> activeConversations = new HashMap<UUID, ActiveConversation>();
    private static Plugin plugin;
    private final List<Consumer<AbandonedEvent>> abandonedListeners = new ArrayList<Consumer<AbandonedEvent>>();
    private String escapeSequence = "cancel";
    private int timeoutSeconds = -1;

    public ConversationManager(@NotNull Plugin plugin) {
        if (ConversationManager.plugin == null) {
            ConversationManager.plugin = plugin;
            plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
        }
    }

    public ConversationManager withEscapeSequence(@NotNull String sequence) {
        this.escapeSequence = sequence;
        return this;
    }

    public ConversationManager withTimeout(int seconds) {
        this.timeoutSeconds = seconds;
        return this;
    }

    public ConversationManager addConversationAbandonedListener(Consumer<AbandonedEvent> listener) {
        this.abandonedListeners.add(listener);
        return this;
    }

    public void startConversation(Player player, Prompt firstPrompt) {
        this.endConversation(player, false, null);
        ActiveConversation convo = new ActiveConversation(firstPrompt, this, Instant.now());
        activeConversations.put(player.getUniqueId(), convo);
        this.sendPrompt(player, firstPrompt);
        if (this.timeoutSeconds > 0) {
            Bukkit.getScheduler().runTaskLater(plugin, () -> {
                ActiveConversation c = activeConversations.get(player.getUniqueId());
                if (c != null && !c.isExpired()) {
                    this.endConversation(player, false, "timeout");
                }
            }, (long)this.timeoutSeconds * 20L);
        }
    }

    private void sendPrompt(Player player, Prompt prompt) {
        Component text = prompt.getPromptText(player);
        if (text != null) {
            player.sendMessage(text);
        }
    }

    public void endConversation(Player player, boolean graceful, @Nullable String reason) {
        ActiveConversation convo = activeConversations.remove(player.getUniqueId());
        if (convo == null) {
            return;
        }
        AbandonedEvent event = new AbandonedEvent(player, graceful, reason);
        for (Consumer<AbandonedEvent> listener : this.abandonedListeners) {
            listener.accept(event);
        }
    }

    @EventHandler
    public void onAsyncChat(AsyncChatEvent event) {
        Player player = event.getPlayer();
        ActiveConversation convo = activeConversations.get(player.getUniqueId());
        if (convo == null) {
            return;
        }
        event.setCancelled(true);
        String input = LegacyComponentSerializer.legacySection().serialize(event.message());
        convo.lastInput = Instant.now();
        if (input.equalsIgnoreCase(convo.escapeSequence)) {
            this.endConversation(player, false, "escape");
            return;
        }
        Bukkit.getScheduler().runTask(plugin, () -> {
            Prompt next = convo.currentPrompt.onInput(player, input);
            if (next == null) {
                this.endConversation(player, true, null);
            } else {
                convo.currentPrompt = next;
                this.sendPrompt(player, next);
            }
        });
    }

    public static class ActiveConversation {
        final String escapeSequence;
        final int timeoutSeconds;
        Prompt currentPrompt;
        Instant lastInput;
        ConversationManager manager;

        ActiveConversation(Prompt firstPrompt, ConversationManager conversationManager, Instant lastInput) {
            this.currentPrompt = firstPrompt;
            this.manager = conversationManager;
            this.escapeSequence = conversationManager.escapeSequence;
            this.timeoutSeconds = conversationManager.timeoutSeconds;
            this.lastInput = lastInput;
        }

        boolean isExpired() {
            return this.timeoutSeconds > 0 && Instant.now().isAfter(this.lastInput.plusSeconds(this.timeoutSeconds));
        }

        public void abandon(Player player) {
            this.manager.endConversation(player, false, "abandoned");
        }
    }

    public static interface Prompt {
        public Component getPromptText(Player var1);

        @Nullable
        public Prompt onInput(Player var1, String var2);
    }

    public record AbandonedEvent(Player player, boolean gracefulExit, String reason) {
    }
}

