/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.utils;

import java.awt.Color;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;

public class StringHelper {
    public static Component generateGradientComponent(String text, String startHex, String endHex) {
        Color startColor = Color.decode(startHex);
        Color endColor = Color.decode(endHex);
        TextComponent.Builder builder = Component.text();
        for (int i = 0; i < text.length(); ++i) {
            double ratio = (double)i / (double)(text.length() - 1);
            int r = (int)((double)startColor.getRed() * (1.0 - ratio) + (double)endColor.getRed() * ratio);
            int g = (int)((double)startColor.getGreen() * (1.0 - ratio) + (double)endColor.getGreen() * ratio);
            int b = (int)((double)startColor.getBlue() * (1.0 - ratio) + (double)endColor.getBlue() * ratio);
            builder.append(Component.text((String)String.valueOf(text.charAt(i))).color(TextColor.color((int)r, (int)g, (int)b)));
        }
        return builder.build();
    }

    public static String toTitleCase(String s) {
        return Arrays.stream(s.toLowerCase().split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1)).collect(Collectors.joining(" "));
    }

    public static boolean hasColor(Component component) {
        TextColor color = component.color();
        if (color != null && !color.equals((Object)NamedTextColor.WHITE)) {
            return true;
        }
        return component.children().stream().anyMatch(StringHelper::hasColor);
    }

    public static Component stripColors(Component input) {
        return input.style(Style.empty()).children(input.children().stream().map(StringHelper::stripColors).toList());
    }
}

