/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.utils.builder;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import de.eisi05.npc.plugin.utils.ItemConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class ItemBuilder
implements Cloneable {
    private static final Map<String, Consumer<InventoryClickEvent>> clickEvents = new HashMap<String, Consumer<InventoryClickEvent>>();
    public static final ItemBuilder PLACEHOLDER = new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE).setName("").hideFlags(true);
    protected final ItemStack item;
    private final String id = UUID.randomUUID().toString();
    protected ItemMeta meta;

    public ItemBuilder(ItemStack item) {
        this.item = ItemConfiguration.setData(item, "id", this.id);
        this.meta = item.getItemMeta();
    }

    public ItemBuilder(Material material) {
        this(new ItemStack(material));
    }

    public ItemBuilder(Material material, int amount) {
        this(new ItemStack(material, amount));
    }

    public ItemBuilder(ItemBuilder itemBuilder) {
        this.item = itemBuilder.item.clone();
        this.item.setItemMeta(itemBuilder.meta.clone());
        this.meta = ItemConfiguration.setData(this.item, "id", this.id).getItemMeta();
    }

    public ItemBuilder setName(String name) {
        this.meta.setDisplayName(name);
        return this;
    }

    public ItemBuilder setLore(List<String> lore) {
        this.meta.setLore(lore);
        return this;
    }

    public ItemBuilder setLore(String ... lore) {
        return this.setLore(Arrays.asList(lore));
    }

    public ItemBuilder addLore(String lore) {
        List<String> currentLore = this.meta.getLore() == null ? new ArrayList() : this.meta.getLore();
        currentLore.addAll(Arrays.stream(lore.split("\n")).toList());
        return this.setLore(currentLore);
    }

    public ItemBuilder hideFlags(boolean hide) {
        if (hide) {
            this.meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_UNBREAKABLE, ItemFlag.HIDE_DESTROYS, ItemFlag.HIDE_PLACED_ON, ItemFlag.HIDE_POTION_EFFECTS, ItemFlag.HIDE_DYE});
        } else {
            this.meta.removeItemFlags(ItemFlag.values());
        }
        return this;
    }

    public ItemBuilder addEnchantment(Enchantment enchantment, int level) {
        this.meta.addEnchant(enchantment, level, true);
        return this;
    }

    public ItemBuilder hideAttributes() {
        this.meta.setAttributeModifiers((Multimap)Multimaps.forMap(Map.of()));
        return this;
    }

    public ItemBuilder setClickHandler(Consumer<InventoryClickEvent> clickHandler) {
        clickEvents.put(this.id, clickHandler);
        return this;
    }

    @NotNull
    public Consumer<InventoryClickEvent> getClickEvent() {
        return clickEvents.getOrDefault(this.id, inventoryClickEvent -> {});
    }

    public ItemStack build() {
        this.item.setItemMeta(this.meta);
        return this.item;
    }

    public ItemBuilder clone() {
        return new ItemBuilder(this);
    }

    public static class ItemListener
    implements Listener {
        @EventHandler
        public void onClick(InventoryClickEvent event) {
            if (event.getSlot() < 0) {
                return;
            }
            if (event.getClick() == ClickType.DOUBLE_CLICK) {
                return;
            }
            if (event.getClickedInventory() != event.getView().getTopInventory()) {
                return;
            }
            if (event.getCurrentItem() == null) {
                return;
            }
            if (!event.getCurrentItem().hasItemMeta()) {
                return;
            }
            if (!ItemConfiguration.hasData(event.getCurrentItem(), "id")) {
                return;
            }
            clickEvents.getOrDefault(ItemConfiguration.getData(event.getCurrentItem(), "id"), inventoryClickEvent -> {}).accept(event);
        }
    }
}

