/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.utils.builder;

import com.google.common.collect.Multimaps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import de.eisi05.npc.api.utils.Reflections;
import de.eisi05.npc.api.utils.Versions;
import de.eisi05.npc.api.wrapper.Mapping;
import de.eisi05.npc.api.wrapper.Wrapper;
import de.eisi05.npc.api.wrapper.objects.WrappedServerPlayer;
import de.eisi05.npc.plugin.utils.builder.ItemBuilder;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.ItemMeta;

public class SkullBuilder
extends ItemBuilder {
    public static final SkullBuilder CHECKMARK = SkullBuilder.skullFromId("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTkyZTMxZmZiNTljOTBhYjA4ZmM5ZGMxZmUyNjgwMjAzNWEzYTQ3YzQyZmVlNjM0MjNiY2RiNDI2MmVjYjliNiJ9fX0=");
    public static final SkullBuilder RED_X = SkullBuilder.skullFromId("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYmViNTg4YjIxYTZmOThhZDFmZjRlMDg1YzU1MmRjYjA1MGVmYzljYWI0MjdmNDYwNDhmMThmYzgwMzQ3NWY3In19fQ==");
    public static final SkullBuilder PLUS = SkullBuilder.skullFromId("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvM2VkZDIwYmU5MzUyMDk0OWU2Y2U3ODlkYzRmNDNlZmFlYjI4YzcxN2VlNmJmY2JiZTAyNzgwMTQyZjcxNiJ9fX0");

    public SkullBuilder() {
        super(Material.PLAYER_HEAD);
    }

    public static SkullBuilder skullFromId(String id) {
        return SkullBuilder.skullFromId(id, UUID.randomUUID(), "Eisi05");
    }

    public static SkullBuilder skullFromId(String id, UUID uuid, String name) {
        if (!Versions.isCurrentVersionSmallerThan(Versions.V1_21_9)) {
            Optional<PropertyMap> propertyMap = Reflections.getInstance(PropertyMap.class, Multimaps.forMap(Map.of("textures", new Property("textures", id))));
            if (propertyMap.isEmpty()) {
                return new SkullBuilder();
            }
            Optional<GameProfile> profile = Reflections.getInstance(GameProfile.class, uuid, name, propertyMap.get());
            return profile.map(SkullBuilder::skullFromGameProfile).orElseGet(SkullBuilder::new);
        }
        GameProfile profile = new GameProfile(uuid, name);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", id));
        return SkullBuilder.skullFromGameProfile(profile);
    }

    public static SkullBuilder skullFromGameProfile(GameProfile gameProfile) {
        SkullBuilder skullBuilder = new SkullBuilder();
        ItemMeta skullMeta = skullBuilder.meta;
        try {
            if (Versions.isCurrentVersionSmallerThan(Versions.V1_21_2)) {
                Method profileMethod = skullMeta.getClass().getDeclaredMethod("setProfile", GameProfile.class);
                profileMethod.setAccessible(true);
                profileMethod.invoke((Object)skullMeta, gameProfile);
            } else {
                Object resolvableProfile = Versions.isCurrentVersionSmallerThan(Versions.V1_21_9) ? new ResolvableProfile(gameProfile).getHandle() : ResolvableProfile.create(gameProfile).getHandle();
                Method profileMethod = skullMeta.getClass().getDeclaredMethod("setProfile", Wrapper.getWrappedClass(ResolvableProfile.class));
                profileMethod.setAccessible(true);
                profileMethod.invoke((Object)skullMeta, resolvableProfile);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        skullBuilder.meta = skullMeta;
        return skullBuilder;
    }

    public static SkullBuilder fromPlayer(Player player) {
        return SkullBuilder.skullFromGameProfile(WrappedServerPlayer.fromPlayer(player).getGameProfile());
    }

    @Mapping(range=@Mapping.Range(from=Versions.V1_21_2, to=Versions.V1_21_9), path="net.minecraft.world.item.component.ResolvableProfile")
    private static class ResolvableProfile
    extends Wrapper {
        @Mapping(range=@Mapping.Range(from=Versions.V1_21_2, to=Versions.V1_21_6), path="")
        private @Mapping(range=@Mapping.Range(from=Versions.V1_21_2, to=Versions.V1_21_6), path="") ResolvableProfile(GameProfile gameProfile) {
            super(ResolvableProfile.createInstance(ResolvableProfile.class, gameProfile));
        }

        @Mapping(range=@Mapping.Range(from=Versions.V1_21_9, to=Versions.V1_21_9), path="")
        private @Mapping(range=@Mapping.Range(from=Versions.V1_21_9, to=Versions.V1_21_9), path="") ResolvableProfile(Object handle) {
            super(handle);
        }

        @Mapping(range=@Mapping.Range(from=Versions.V1_21_9, to=Versions.V1_21_9), path="a")
        public static @Mapping(range=@Mapping.Range(from=Versions.V1_21_9, to=Versions.V1_21_9), path="a") ResolvableProfile create(GameProfile gameProfile) {
            return new ResolvableProfile(Wrapper.invokeStaticWrappedMethod(gameProfile));
        }
    }
}

