/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.utils;

import java.util.Arrays;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public enum Versions {
    NONE(""),
    V1_17("v1_17_R1"),
    V1_18("v1_18_R1"),
    V1_18_2("v1_18_R2"),
    V1_19("v1_19_R1"),
    V1_19_1("v1_19_R1"),
    V1_19_3("v1_19_R2"),
    V1_19_4("v1_19_R3"),
    V1_20("v1_20_R1"),
    V1_20_2("v1_20_R2"),
    V1_20_4("v1_20_R3"),
    V1_20_6("v1_20_R4"),
    V1_21("v1_21_R1"),
    V1_21_2("v1_21_R2"),
    V1_21_4("v1_21_R3"),
    V1_21_5("v1_21_R4"),
    V1_21_6("v1_21_R5"),
    V1_21_7("v1_21_R5"),
    V1_21_9("v1_21_R6");

    private static Versions VERSION;
    private final String path;

    private Versions(String path) {
        this.path = path;
    }

    @NotNull
    public static Versions getVersion() {
        if (VERSION != null) {
            return VERSION;
        }
        Versions versions = switch (Bukkit.getMinecraftVersion()) {
            case "1.17.1", "1.17.2" -> V1_17;
            case "1.18", "1.18.1" -> V1_18;
            case "1.18.2" -> V1_18_2;
            case "1.19" -> V1_19;
            case "1.19.1", "1.19.2" -> V1_19_1;
            case "1.19.3" -> V1_19_3;
            case "1.19.4", "1.19.5" -> V1_19_4;
            case "1.20", "1.20.1" -> V1_20;
            case "1.20.2", "1.20.3" -> V1_20_2;
            case "1.20.4", "1.20.5" -> V1_20_4;
            case "1.20.6" -> V1_20_6;
            case "1.21", "1.21.1" -> V1_21;
            case "1.21.2", "1.21.3" -> V1_21_2;
            case "1.21.4" -> V1_21_4;
            case "1.21.5" -> V1_21_5;
            case "1.21.6" -> V1_21_6;
            case "1.21.7", "1.21.8" -> V1_21_7;
            case "1.21.9", "1.21.10" -> V1_21_9;
            default -> NONE;
        };
        VERSION = versions;
        return versions;
    }

    @NotNull
    private static Versions[] getVersionBetween(@NotNull Versions versions1, @NotNull Versions versions2) {
        return (Versions[])Arrays.stream(Versions.values()).filter(v -> v != NONE).filter(v -> v.ordinal() >= versions1.ordinal() && v.ordinal() <= versions2.ordinal()).toArray(Versions[]::new);
    }

    public static boolean isCurrentVersionSmallerThan(@NotNull Versions versions) {
        return Versions.getVersion().ordinal() < versions.ordinal();
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @NotNull
    public String getName() {
        return this.name().replace("_", ".");
    }
}

