/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.plugin.utils.builder;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import de.eisi05.npc.api.utils.Reflections;
import de.eisi05.npc.api.utils.Versions;
import de.eisi05.npc.plugin.utils.builder.ItemBuilder;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.item.component.ResolvableProfile;
import org.bukkit.Material;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.ItemMeta;

public class SkullBuilder
extends ItemBuilder {
    public static final SkullBuilder CHECKMARK = SkullBuilder.skullFromId("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTkyZTMxZmZiNTljOTBhYjA4ZmM5ZGMxZmUyNjgwMjAzNWEzYTQ3YzQyZmVlNjM0MjNiY2RiNDI2MmVjYjliNiJ9fX0=");
    public static final SkullBuilder RED_X = SkullBuilder.skullFromId("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYmViNTg4YjIxYTZmOThhZDFmZjRlMDg1YzU1MmRjYjA1MGVmYzljYWI0MjdmNDYwNDhmMThmYzgwMzQ3NWY3In19fQ==");
    public static final SkullBuilder PLUS = SkullBuilder.skullFromId("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvM2VkZDIwYmU5MzUyMDk0OWU2Y2U3ODlkYzRmNDNlZmFlYjI4YzcxN2VlNmJmY2JiZTAyNzgwMTQyZjcxNiJ9fX0");

    public SkullBuilder() {
        super(Material.PLAYER_HEAD);
    }

    public static SkullBuilder skullFromId(String id) {
        return SkullBuilder.skullFromId(id, UUID.randomUUID(), "Eisi05");
    }

    public static SkullBuilder skullFromId(String id, UUID uuid, String name) {
        GameProfile profile;
        if (Versions.isCurrentVersionSmallerThan(Versions.V1_21_9)) {
            profile = new GameProfile(uuid, name);
            Reflections.invokeMethod(profile, "getProperties", new Object[0]).thanInvoke("put", "textures", new Property("textures", id));
        } else {
            profile = new GameProfile(uuid, name, new PropertyMap((Multimap)Multimaps.forMap(Map.of("textures", new Property("textures", id)))));
        }
        return SkullBuilder.skullFromGameProfile(profile);
    }

    public static SkullBuilder skullFromGameProfile(GameProfile gameProfile) {
        SkullBuilder skullBuilder = new SkullBuilder();
        ItemMeta skullMeta = skullBuilder.meta;
        try {
            ResolvableProfile resolvableProfile;
            if (Versions.isCurrentVersionSmallerThan(Versions.V1_21_9)) {
                Optional<ResolvableProfile> optional = Reflections.getInstance(ResolvableProfile.class, gameProfile);
                if (optional.isEmpty()) {
                    throw new RuntimeException();
                }
                resolvableProfile = optional.get();
            } else {
                resolvableProfile = ResolvableProfile.createResolved((GameProfile)gameProfile);
            }
            Method profileMethod = skullMeta.getClass().getDeclaredMethod("setProfile", ResolvableProfile.class);
            profileMethod.setAccessible(true);
            profileMethod.invoke((Object)skullMeta, resolvableProfile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        skullBuilder.meta = skullMeta;
        return skullBuilder;
    }

    public static SkullBuilder fromPlayer(Player player) {
        return SkullBuilder.skullFromGameProfile(((CraftPlayer)player).getHandle().getGameProfile());
    }
}

