/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.objects;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.api.enums.Result;
import de.eisi05.npc.api.interfaces.NpcClickAction;
import de.eisi05.npc.api.manager.NpcManager;
import de.eisi05.npc.api.manager.TeamManager;
import de.eisi05.npc.api.objects.CustomNameTag;
import de.eisi05.npc.api.objects.NpcHolder;
import de.eisi05.npc.api.objects.NpcName;
import de.eisi05.npc.api.objects.NpcOption;
import de.eisi05.npc.api.utils.ObjectSaver;
import de.eisi05.npc.api.utils.Reflections;
import de.eisi05.npc.api.utils.Var;
import de.eisi05.npc.api.utils.Versions;
import de.eisi05.npc.api.wrapper.packets.AnimatePacket;
import de.eisi05.npc.api.wrapper.packets.SetEntityDataPacket;
import de.eisi05.npc.api.wrapper.packets.SetPlayerTeamPacket;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.text.serializer.json.JSONComponentSerializer;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NPC
extends NpcHolder {
    ServerPlayer serverPlayer;
    private final List<UUID> viewers = new ArrayList<UUID>();
    private final Map<NpcOption<?, ?>, Object> options;
    private final CustomNameTag nameTag;
    private NpcName name;
    private Location location;
    private NpcClickAction clickEvent;
    private Instant createdAt = Instant.now();
    private Path npcPath;

    public NPC(@NotNull Location location) {
        this(location, UUID.randomUUID());
    }

    public NPC(@NotNull Location location, @NotNull NpcName name) {
        this(location, UUID.randomUUID(), name);
    }

    public NPC(@NotNull Location location, @NotNull UUID uuid) {
        this(location, uuid, NpcName.empty());
    }

    public NPC(@NotNull Location location, @NotNull UUID uuid, @NotNull NpcName name) {
        this.name = name;
        this.location = location;
        DedicatedServer server = ((CraftServer)Bukkit.getServer()).getServer();
        ServerLevel level = ((CraftWorld)location.getWorld()).getHandle();
        GameProfile profile = new GameProfile(uuid, "NPC" + uuid.toString().substring(0, 13));
        this.serverPlayer = new ServerPlayer((MinecraftServer)server, level, profile, ClientInformation.createDefault());
        Var.moveEntity((Entity)this.serverPlayer, location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        this.npcPath = NpcApi.plugin.getDataFolder().toPath().resolve("NPC").resolve(String.valueOf(uuid) + ".npc");
        this.serverPlayer.connection = new ServerGamePacketListenerImpl((MinecraftServer)server, new Connection(PacketFlow.SERVERBOUND), this.serverPlayer, CommonListenerCookie.createInitial((GameProfile)profile, (boolean)true));
        this.options = new HashMap();
        for (NpcOption<?, ?> value : NpcOption.values()) {
            this.setOption(value, Var.unsafeCast(value.getDefaultValue()));
        }
        Display.TextDisplay display = new Display.TextDisplay(EntityType.TEXT_DISPLAY, (Level)((CraftWorld)location.getWorld()).getHandle());
        Var.moveEntity((Entity)display, location.getX(), location.getY() + 2.0, location.getZ(), 0.0f, 0.0f);
        this.nameTag = new CustomNameTag(display);
        this.serverPlayer.listName = CraftChatMessage.fromJSON((String)((String)JSONComponentSerializer.json().serialize(name.getName())));
        this.serverPlayer.passengers = ImmutableList.of((Object)((Display.TextDisplay)this.nameTag.getDisplay()));
        NpcManager.addNPC(this);
    }

    private NPC(@NotNull Location location, @NotNull NpcName name, @NotNull Map<NpcOption<?, ?>, Object> options, @Nullable NpcClickAction clickEvent) {
        this(location, UUID.randomUUID(), name);
        this.options.putAll(options);
        this.clickEvent = clickEvent;
    }

    @NotNull
    public NPC copy(@NotNull Location newLocation) {
        return new NPC(newLocation, this.name.copy(), new HashMap(this.options), this.clickEvent == null ? null : this.clickEvent.copy());
    }

    public boolean isSaved() {
        return Files.exists(this.npcPath, new LinkOption[0]);
    }

    @Override
    public void save() throws IOException {
        this.npcPath.toFile().getParentFile().mkdirs();
        new ObjectSaver(this.npcPath.toFile()).write(SerializedNPC.serializedNPC(this), false);
        super.save();
    }

    @NotNull
    public Object getServerPlayer() {
        return this.serverPlayer;
    }

    @Nullable
    public NpcClickAction getClickEvent() {
        return this.clickEvent;
    }

    @NotNull
    public NPC setClickEvent(@Nullable NpcClickAction event) {
        this.clickEvent = event;
        return this;
    }

    public boolean isEnabled() {
        return this.getOption(NpcOption.ENABLED);
    }

    public void setEnabled(boolean enabled) {
        this.setOption(NpcOption.ENABLED, enabled);
        this.reload();
    }

    public boolean isEditable() {
        return this.getOption(NpcOption.EDITABLE);
    }

    public void setEditable(boolean editable) {
        this.setOption(NpcOption.EDITABLE, editable);
    }

    public <T> void setOption(@NotNull NpcOption<T, ?> option, @Nullable T value) {
        if (value == null) {
            this.options.remove(option);
        } else {
            this.options.put(option, value);
        }
        if (NpcApi.config.autoUpdate()) {
            this.viewers.forEach(uuid -> {
                Player player = Bukkit.getPlayer((UUID)uuid);
                if (player == null) {
                    return;
                }
                option.getPacket(value, this, player).ifPresent(packetWrapper -> ((CraftPlayer)player).getHandle().connection.send((Packet)packetWrapper));
            });
        }
    }

    @NotNull
    public <T> T getOption(@NotNull NpcOption<T, ?> option) {
        return (T)this.options.getOrDefault(option, option.getDefaultValue());
    }

    public void playAnimation(@NotNull Player player, @NotNull AnimatePacket.Animation animation) {
        ((CraftPlayer)player).getHandle().connection.send((Packet)AnimatePacket.create(this.serverPlayer, animation));
    }

    public void reload() {
        ArrayList<UUID> viewers = new ArrayList<UUID>(this.viewers);
        this.hideNpcFromAllPlayers();
        TeamManager.clear(this.getGameProfileName());
        viewers.stream().filter(uuid -> Bukkit.getPlayer((UUID)uuid) != null).forEach(uuid -> this.showNPCToPlayer(Bukkit.getPlayer((UUID)uuid)));
    }

    @NotNull
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(@NotNull Location location) {
        this.location = location;
        Var.moveEntity((Entity)this.serverPlayer, location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    @NotNull
    public UUID getUUID() {
        return this.serverPlayer.getUUID();
    }

    @NotNull
    public NpcName getName() {
        return this.name;
    }

    @NotNull
    public String getGameProfileName() {
        if (Versions.isCurrentVersionSmallerThan(Versions.V1_21_9)) {
            return (String)Reflections.invokeMethod(this.serverPlayer.getGameProfile(), "getName", new Object[0]).get();
        }
        return this.serverPlayer.getGameProfile().name();
    }

    public void setName(@NotNull NpcName name) {
        this.name = name;
        this.serverPlayer.listName = CraftChatMessage.fromJSON((String)((String)JSONComponentSerializer.json().serialize(name.getName())));
        this.viewers.stream().filter(uuid -> Bukkit.getPlayer((UUID)uuid) != null).forEach(uuid -> this.updateName(Bukkit.getPlayer((UUID)uuid)));
    }

    public void updateName(@NotNull Player player) {
        ((CraftPlayer)player).getHandle().connection.send((Packet)SetEntityDataPacket.create(((Display.TextDisplay)this.nameTag.getDisplay()).getId(), (SynchedEntityData)this.nameTag.applyData(this.isEnabled() ? this.name.getName(player) : NpcApi.DISABLED_MESSAGE_PROVIDER.apply(player).appendNewline().append(this.name.getName(player)))));
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public void showNpcToAllPlayers() {
        Bukkit.getOnlinePlayers().forEach(this::showNPCToPlayer);
    }

    public void showNPCToPlayer(@NotNull Player player) {
        if (!this.getOption(NpcOption.ENABLED).booleanValue() && !player.isOp()) {
            return;
        }
        if (!player.getWorld().getName().equals(this.serverPlayer.getBukkitEntity().getWorld().getName())) {
            this.hideNpcFromPlayer(player);
            return;
        }
        if (!this.viewers.contains(player.getUniqueId())) {
            this.viewers.add(player.getUniqueId());
        }
        if (!this.name.isStatic() && this.getOption(NpcOption.SHOW_TAB_LIST).booleanValue()) {
            this.setOption(NpcOption.SHOW_TAB_LIST, false);
        }
        ArrayList<Object> packets = new ArrayList<Object>();
        Arrays.stream(NpcOption.values()).filter(NpcOption::loadBefore).forEach(npcOption -> npcOption.getPacket(this.getOption((NpcOption)npcOption), this, player).ifPresent(o -> packets.add((Packet)o)));
        packets.add(ClientboundPlayerInfoUpdatePacket.createSinglePlayerInitializing((ServerPlayer)this.serverPlayer, (boolean)true));
        packets.add(this.serverPlayer.getAddEntityPacket(Var.getServerEntity((Entity)this.serverPlayer, Var.getServerLevel(this.serverPlayer))));
        boolean modified = TeamManager.exists(player, this.getGameProfileName());
        PlayerTeam wrappedPlayerTeam = (PlayerTeam)TeamManager.create(player, this.getGameProfileName());
        wrappedPlayerTeam.setNameTagVisibility(Team.Visibility.NEVER);
        packets.add((Packet)SetPlayerTeamPacket.createAddOrModifyPacket(wrappedPlayerTeam, !modified));
        packets.add((Packet)SetPlayerTeamPacket.createPlayerPacket(wrappedPlayerTeam, this.getGameProfileName(), ClientboundSetPlayerTeamPacket.Action.ADD));
        packets.add(new ClientboundRotateHeadPacket((Entity)this.serverPlayer, (byte)(this.location.getYaw() % 360.0f * 256.0f / 360.0f)));
        packets.add(new ClientboundMoveEntityPacket.Rot(this.serverPlayer.getId(), (byte)this.location.getYaw(), (byte)this.location.getPitch(), this.serverPlayer.onGround));
        if (!this.getOption(NpcOption.HIDE_NAMETAG).booleanValue()) {
            packets.add(((Display.TextDisplay)this.nameTag.getDisplay()).getAddEntityPacket(Var.getServerEntity((Entity)((Display.TextDisplay)this.nameTag.getDisplay()), Var.getServerLevel(this.serverPlayer))));
            packets.add((Packet)SetEntityDataPacket.create(((Display.TextDisplay)this.nameTag.getDisplay()).getId(), (SynchedEntityData)this.nameTag.applyData(this.isEnabled() ? this.name.getName(player) : NpcApi.DISABLED_MESSAGE_PROVIDER.apply(player).appendNewline().append(this.name.getName(player)))));
            packets.add(new ClientboundSetPassengersPacket((Entity)this.serverPlayer));
        }
        Arrays.stream(NpcOption.values()).filter(npcOption -> !npcOption.equals(NpcOption.ENABLED)).forEach(npcOption -> npcOption.getPacket(this.getOption((NpcOption)npcOption), this, player).map(o -> (Packet)o).ifPresent(packets::add));
        NpcOption.ENABLED.getPacket(this.isEnabled(), this, player).map(o -> (Packet)o).ifPresent(packets::add);
        ServerGamePacketListenerImpl connection = ((CraftPlayer)player).getHandle().connection;
        packets.forEach(arg_0 -> ((ServerGamePacketListenerImpl)connection).send(arg_0));
    }

    public void hideNpcFromAllPlayers() {
        Bukkit.getOnlinePlayers().forEach(this::hideNpcFromPlayer);
    }

    public void hideNpcFromPlayer(@NotNull Player player) {
        ServerGamePacketListenerImpl connection = ((CraftPlayer)player).getHandle().connection;
        connection.send((Packet)new ClientboundRemoveEntitiesPacket(new int[]{this.serverPlayer.getId(), ((Display.TextDisplay)this.nameTag.getDisplay()).getId()}));
        if (TeamManager.exists(player, this.getGameProfileName())) {
            PlayerTeam team = (PlayerTeam)TeamManager.create(player, this.getGameProfileName());
            connection.send((Packet)SetPlayerTeamPacket.createPlayerPacket(team, this.getGameProfileName(), ClientboundSetPlayerTeamPacket.Action.REMOVE));
            connection.send((Packet)SetPlayerTeamPacket.createRemovePacket(team));
        }
        connection.send((Packet)new ClientboundPlayerInfoRemovePacket(List.of(this.getUUID())));
        this.viewers.remove(player.getUniqueId());
    }

    public void delete() throws IOException {
        if (this.serverPlayer == null) {
            return;
        }
        this.hideNpcFromAllPlayers();
        NpcManager.removeNPC(this);
        this.serverPlayer.remove(Entity.RemovalReason.DISCARDED);
        this.serverPlayer = null;
        this.npcPath.toFile().getParentFile().mkdirs();
        Files.deleteIfExists(this.npcPath);
    }

    public void lookAtPlayer(@NotNull Player viewer) {
        Location npcLoc = this.serverPlayer.getBukkitEntity().getLocation();
        Location playerLoc = viewer.getLocation();
        if (npcLoc.getWorld() != playerLoc.getWorld()) {
            return;
        }
        double dx = playerLoc.getX() - npcLoc.getX();
        double dy = playerLoc.getY() + viewer.getEyeHeight() - (npcLoc.getY() + this.serverPlayer.getBukkitEntity().getEyeHeight() * this.getOption(NpcOption.SCALE));
        double dz = playerLoc.getZ() - npcLoc.getZ();
        double distanceXZ = Math.sqrt(dx * dx + dz * dz);
        float yaw = (float)Math.toDegrees(Math.atan2(-dx, dz));
        float pitch = (float)Math.toDegrees(-Math.atan2(dy, distanceXZ));
        byte yawByte = (byte)(yaw * 256.0f / 360.0f);
        byte pitchByte = (byte)(pitch * 256.0f / 360.0f);
        ServerGamePacketListenerImpl connection = ((CraftPlayer)viewer).getHandle().connection;
        connection.send((Packet)new ClientboundRotateHeadPacket((Entity)this.serverPlayer, yawByte));
        connection.send((Packet)new ClientboundMoveEntityPacket.Rot(this.serverPlayer.getId(), yawByte, pitchByte, this.serverPlayer.onGround()));
    }

    @NotNull
    public BukkitTask walkTo(final @NotNull de.eisi05.npc.api.pathfinding.Path path, final @Nullable Player player, double walkSpeed, final boolean changeRealLocation, final @Nullable Consumer<Result> onEnd) {
        final double speed = Math.max(Math.min(walkSpeed, 1.0), 0.1);
        double gravity = -0.08;
        double jumpVelocity = 0.5;
        double terminal = -0.5;
        double stepHeight = 0.6;
        return new BukkitRunnable(){
            final List<Location> pathPoints;
            int index;
            Vector current;
            double yVel;
            float previousYaw;
            Vector previousMovement;
            {
                this.pathPoints = path.asLocations();
                this.index = 0;
                this.current = NPC.this.location.toVector();
                this.yVel = 0.0;
                this.previousYaw = NPC.this.location.getYaw();
                this.previousMovement = NPC.this.location.getDirection();
            }

            public void run() {
                float yaw;
                float targetYaw;
                Vector lookDir;
                boolean onGround;
                if (this.index >= this.pathPoints.size()) {
                    if (!path.getWaypoints().isEmpty()) {
                        Location last = path.getWaypoints().getLast();
                        Vector lastVector = last.toVector();
                        Vector lastMovement = lastVector.clone().subtract(this.current);
                        ClientboundRotateHeadPacket rotateHeadPacket = new ClientboundRotateHeadPacket((Entity)NPC.this.serverPlayer, (byte)(last.getYaw() * 256.0f / 360.0f));
                        ClientboundTeleportEntityPacket teleportEntityPacket = new ClientboundTeleportEntityPacket(NPC.this.serverPlayer.getId(), new PositionMoveRotation(new Vec3(lastVector.toVector3f()), new Vec3(lastMovement.toVector3f()), last.getYaw(), last.getPitch()), Set.of(), true);
                        NPC.this.sendNpcMovePackets(player, teleportEntityPacket, rotateHeadPacket);
                    }
                    if (changeRealLocation) {
                        NPC.this.setLocation(path.getWaypoints().isEmpty() ? this.pathPoints.getLast() : path.getWaypoints().getLast());
                        if (player != null) {
                            for (UUID uuid : NPC.this.viewers) {
                                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
                                if (!offlinePlayer.isOnline() || uuid.equals(player.getUniqueId())) continue;
                                NPC.this.hideNpcFromPlayer(offlinePlayer.getPlayer());
                                NPC.this.showNPCToPlayer(offlinePlayer.getPlayer());
                            }
                        }
                    }
                    if (onEnd != null) {
                        onEnd.accept(Result.SUCCESS);
                    }
                    this.cancel();
                    return;
                }
                Vector target = this.pathPoints.get(this.index).toVector();
                Vector toTarget = target.clone().subtract(this.current);
                if (toTarget.lengthSquared() < 0.04 && Math.abs(toTarget.getY()) < 0.2) {
                    ++this.index;
                    return;
                }
                Vector horizontal = new Vector(toTarget.getX(), 0.0, toTarget.getZ());
                Vector horizontalMove = horizontal.lengthSquared() > 1.0E-6 ? horizontal.clone().normalize().multiply(speed) : new Vector(0, 0, 0);
                double nextDist = target.clone().subtract(this.current.clone().add(horizontalMove)).lengthSquared();
                if (nextDist > toTarget.lengthSquared()) {
                    this.current = target;
                    ++this.index;
                    return;
                }
                World world = NPC.this.location.getWorld();
                int bx = (int)Math.floor(this.current.getX());
                int bz = (int)Math.floor(this.current.getZ());
                int searchStart = (int)Math.floor(this.current.getY());
                int groundBlockY = Integer.MIN_VALUE;
                for (int y = searchStart; y >= searchStart - 3; --y) {
                    Block block = world.getBlockAt(bx, y - 1, bz);
                    if (!block.getType().isSolid() || block.getType().isAir() || block.isPassable()) continue;
                    groundBlockY = y - 1;
                    break;
                }
                if (groundBlockY == Integer.MIN_VALUE) {
                    groundBlockY = world.getHighestBlockYAt(bx, bz) - 1;
                }
                double groundY = (double)groundBlockY + 1.0;
                boolean bl = onGround = this.current.getY() <= groundY + 1.0E-5;
                if (onGround) {
                    if (toTarget.getY() > 0.0 && toTarget.getY() <= 0.6 && horizontal.lengthSquared() > 1.0E-6) {
                        this.current = this.current.clone().add(new Vector(0.0, Math.min(toTarget.getY(), 0.6), 0.0));
                        this.yVel = 0.0;
                        onGround = true;
                    } else if (toTarget.getY() > 0.5) {
                        this.yVel = 0.5;
                        onGround = false;
                    } else {
                        this.yVel = 0.0;
                        this.current = new Vector(this.current.getX(), groundY, this.current.getZ());
                    }
                }
                double yDelta = 0.0;
                if (!onGround) {
                    this.yVel += -0.08;
                    if (this.yVel < -0.5) {
                        this.yVel = -0.5;
                    }
                    yDelta = this.yVel;
                    if (this.current.getY() + yDelta <= groundY) {
                        yDelta = groundY - this.current.getY();
                        this.yVel = 0.0;
                        onGround = true;
                    }
                }
                Vector movement = new Vector(horizontalMove.getX(), yDelta, horizontalMove.getZ());
                this.current = this.current.clone().add(movement);
                if (this.index + 1 < this.pathPoints.size()) {
                    Vector currentTarget = this.pathPoints.get(this.index).toVector().clone();
                    Vector nextTarget = this.pathPoints.get(this.index + 1).toVector().clone();
                    lookDir = currentTarget.clone().add(nextTarget).multiply(0.5).subtract(this.current);
                } else {
                    lookDir = this.pathPoints.get(this.index).toVector().clone().subtract(this.current);
                }
                Vector horizontalVec = new Vector(lookDir.getX(), 0.0, lookDir.getZ());
                if (horizontalVec.lengthSquared() < 1.0E-6) {
                    horizontalVec = this.previousMovement.clone();
                }
                for (targetYaw = (float)(Math.atan2(horizontalVec.getZ(), horizontalVec.getX()) * 180.0 / Math.PI - 90.0); targetYaw > 180.0f; targetYaw -= 360.0f) {
                }
                while (targetYaw < -180.0f) {
                    targetYaw += 360.0f;
                }
                float diff = targetYaw - this.previousYaw;
                if (diff > 180.0f) {
                    diff -= 360.0f;
                }
                if (diff < -180.0f) {
                    diff += 360.0f;
                }
                float maxTurn = 15.0f;
                diff = Math.max(-maxTurn, Math.min(maxTurn, diff));
                this.previousYaw = yaw = this.previousYaw + diff;
                this.previousMovement = horizontalVec.clone();
                Vector targetVec = this.pathPoints.get(Math.min(this.index + 1, this.pathPoints.size() - 1)).toVector().clone().subtract(this.current);
                double horizontalLen = Math.sqrt(targetVec.getX() * targetVec.getX() + targetVec.getZ() * targetVec.getZ());
                float pitch = (float)(-Math.atan2(targetVec.getY(), horizontalLen) * 180.0 / Math.PI) / 1.5f;
                ClientboundRotateHeadPacket rotateHeadPacket = new ClientboundRotateHeadPacket((Entity)NPC.this.serverPlayer, (byte)(yaw * 256.0f / 360.0f));
                ClientboundTeleportEntityPacket teleportEntityPacket = new ClientboundTeleportEntityPacket(NPC.this.serverPlayer.getId(), new PositionMoveRotation(new Vec3(this.current.toVector3f()), new Vec3(movement.toVector3f()), yaw, pitch), Set.of(), onGround);
                NPC.this.sendNpcMovePackets(player, teleportEntityPacket, rotateHeadPacket);
            }

            public synchronized void cancel() throws IllegalStateException {
                super.cancel();
                if (onEnd != null) {
                    onEnd.accept(Result.CANCELLED);
                }
            }
        }.runTaskTimer(NpcApi.plugin, 1L, 1L);
    }

    private void sendNpcMovePackets(@Nullable Player player, @NotNull ClientboundTeleportEntityPacket teleportEntityPacket, @NotNull ClientboundRotateHeadPacket rotateHeadPacket) {
        if (player != null) {
            ServerPlayer serverPlayer1 = ((CraftPlayer)player).getHandle();
            serverPlayer1.connection.send((Packet)teleportEntityPacket);
            serverPlayer1.connection.send((Packet)rotateHeadPacket);
        } else {
            for (UUID uuid : this.viewers) {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
                if (!offlinePlayer.isOnline()) continue;
                ServerPlayer serverPlayer1 = ((CraftPlayer)offlinePlayer.getPlayer()).getHandle();
                serverPlayer1.connection.send((Packet)teleportEntityPacket);
                serverPlayer1.connection.send((Packet)rotateHeadPacket);
            }
        }
    }

    void changeUUID(@NotNull UUID newUUID) {
        try {
            Files.deleteIfExists(this.npcPath);
            this.npcPath = NpcApi.plugin.getDataFolder().toPath().resolve("NPC").resolve(String.valueOf(newUUID) + ".npc");
            this.save();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CustomNameTag getNameTag() {
        return this.nameTag;
    }

    public record SerializedNPC(@NotNull UUID world, double x, double y, double z, float yaw, float pitch, @NotNull UUID id, @NotNull Serializable name, @NotNull Map<String, ? extends Serializable> options, @Nullable NpcClickAction clickEvent, @NotNull Instant createdAt) implements Serializable
    {
        private static final long serialVersionUID = 1L;

        @NotNull
        public static SerializedNPC serializedNPC(@NotNull NPC npc) {
            HashMap options = new HashMap();
            npc.options.forEach((key, value) -> options.put(key.getPath(), (Serializable)Var.unsafeCast(key.serialize(npc.getOption(key)))));
            return new SerializedNPC(npc.getLocation().getWorld().getUID(), npc.getLocation().getX(), npc.getLocation().getY(), npc.getLocation().getZ(), npc.getLocation().getYaw(), npc.getLocation().getPitch(), npc.getUUID(), npc.getName(), options, npc.clickEvent, npc.createdAt);
        }

        private Object readResolve() throws ObjectStreamException {
            NpcName fixedName;
            Serializable serializable = this.name;
            if (serializable instanceof NpcName) {
                NpcName sn;
                fixedName = sn = (NpcName)serializable;
            } else {
                serializable = this.name;
                if (serializable instanceof String) {
                    String oldName = (String)((Object)serializable);
                    fixedName = NpcName.of(JSONComponentSerializer.json().deserialize((Object)oldName));
                } else {
                    throw new IllegalStateException("Unexpected type for name field: " + String.valueOf(this.name.getClass()));
                }
            }
            return new SerializedNPC(this.world, this.x, this.y, this.z, this.yaw, this.pitch, this.id, fixedName, this.options, this.clickEvent, this.createdAt);
        }

        @NotNull
        public <T, S extends Serializable> NPC deserializedNPC() {
            NPC npc = new NPC(new Location(Bukkit.getWorld((UUID)this.world), this.x, this.y, this.z, this.yaw, this.pitch), this.id, (NpcName)this.name).setClickEvent(this.clickEvent == null ? this.clickEvent : this.clickEvent.initialize());
            this.options.forEach((string, serializable) -> NpcOption.getOption(string).ifPresent(npcOption -> npc.setOption(npcOption, npcOption.deserialize((Serializable)Var.unsafeCast(serializable)))));
            npc.createdAt = this.createdAt == null ? Instant.now() : this.createdAt;
            return npc;
        }
    }
}

