/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.pathfinding;

import org.bukkit.Location;

public class Tile {
    private final short x;
    private final short y;
    private final short z;
    private final String uid;
    private double g = -1.0;
    private double h = -1.0;
    private Tile parent;

    public Tile(short x, short y, short z, Tile parent) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.parent = parent;
        this.uid = String.valueOf(x) + y + z;
    }

    public Location getLocation(Location start) {
        return new Location(start.getWorld(), (double)(start.getBlockX() + this.x), (double)(start.getBlockY() + this.y), (double)(start.getBlockZ() + this.z));
    }

    public Tile getParent() {
        return this.parent;
    }

    public void setParent(Tile parent) {
        this.parent = parent;
    }

    public short getX() {
        return this.x;
    }

    public int getX(Location i) {
        return i.getBlockX() + this.x;
    }

    public short getY() {
        return this.y;
    }

    public int getY(Location i) {
        return i.getBlockY() + this.y;
    }

    public short getZ() {
        return this.z;
    }

    public int getZ(Location i) {
        return i.getBlockZ() + this.z;
    }

    public String getUID() {
        return this.uid;
    }

    public boolean equals(Tile t) {
        return t.getX() == this.x && t.getY() == this.y && t.getZ() == this.z;
    }

    public void calculateBoth(int sx, int sy, int sz, int ex, int ey, int ez, boolean update) {
        this.calculateG(sx, sy, sz, update);
        this.calculateH(sx, sy, sz, ex, ey, ez, update);
    }

    public void calculateH(int sx, int sy, int sz, int ex, int ey, int ez, boolean update) {
        if (update || this.h == -1.0) {
            int hx = sx + this.x;
            int hy = sy + this.y;
            int hz = sz + this.z;
            this.h = this.getEuclideanDistance(hx, hy, hz, ex, ey, ez);
        }
    }

    public void calculateG(int sx, int sy, int sz, boolean update) {
        if (update || this.g == -1.0) {
            Tile currentParent;
            Tile currentTile = this;
            int gCost = 0;
            while ((currentParent = currentTile.getParent()) != null) {
                int dx = currentTile.getX() - currentParent.getX();
                int dy = currentTile.getY() - currentParent.getY();
                int dz = currentTile.getZ() - currentParent.getZ();
                dx = this.abs(dx);
                dy = this.abs(dy);
                dz = this.abs(dz);
                gCost = dx == 1 && dy == 1 && dz == 1 ? (int)((double)gCost + 1.7) : ((dx == 1 || dz == 1) && dy == 1 || (dx == 1 || dz == 1) && dy == 0 ? (int)((double)gCost + 1.4) : (int)((double)gCost + 1.0));
                currentTile = currentParent;
            }
            this.g = gCost;
        }
    }

    public double getG() {
        return this.g;
    }

    public double getH() {
        return this.h;
    }

    public double getF() {
        return this.h + this.g;
    }

    private double getEuclideanDistance(int sx, int sy, int sz, int ex, int ey, int ez) {
        double dx = sx - ex;
        double dy = sy - ey;
        double dz = sz - ez;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private int abs(int i) {
        return i < 0 ? -i : i;
    }
}

