/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.manager;

import de.eisi05.npc.api.NpcApi;
import de.eisi05.npc.api.objects.NPC;
import de.eisi05.npc.api.utils.ObjectSaver;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class NpcManager {
    private static final List<NPC> listNPC = new ArrayList<NPC>();

    public static void addNPC(@NotNull NPC npc) {
        listNPC.add(npc);
    }

    @NotNull
    public static List<NPC> getList() {
        return listNPC;
    }

    public static void removeNPC(@NotNull NPC npc) {
        listNPC.remove(npc);
    }

    public static void clear() {
        listNPC.clear();
    }

    @NotNull
    public static Optional<NPC> fromUUID(@NotNull UUID uuid) {
        return listNPC.stream().filter(npc -> npc.getUUID().equals(uuid)).findFirst();
    }

    public static void loadNPCs() {
        File file = new File(NpcApi.plugin.getDataFolder(), "NPC");
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        long failCounter = 0L;
        long successCounter = 0L;
        for (File file1 : files) {
            if (!file1.getName().endsWith(".npc")) continue;
            try {
                NPC.SerializedNPC serializedNPC = (NPC.SerializedNPC)new ObjectSaver(file1).read();
                serializedNPC.deserializedNPC().showNpcToAllPlayers();
                ++successCounter;
            }
            catch (Exception e) {
                ++failCounter;
            }
        }
        if (successCounter == 1L) {
            NpcApi.plugin.getLogger().info("Successfully loaded " + successCounter + " NPC");
        } else if (successCounter > 1L) {
            NpcApi.plugin.getLogger().info("Successfully loaded " + successCounter + " NPC's");
        }
        if (failCounter == 1L) {
            NpcApi.plugin.getLogger().warning("Failed to load " + failCounter + " NPC");
        } else if (failCounter > 1L) {
            NpcApi.plugin.getLogger().warning("Failed to load " + failCounter + " NPC's");
        }
    }
}

